/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchApplyCommand
extends SimpleShellCommand {
    protected Strategy s = Strategy.MANUAL;

    public OPatchApplyCommand(ActionType automationAction, Strategy s) {
        super(automationAction);
        this.s = s;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        Map<String, String> opatchNapplyOptions;
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        List<GenericPatch> sortedPatches = CommandUtils.sortPatchesById(patches);
        CommandUtils.storePatchIDsInContext(context, sortedPatches);
        ArrayList<String> cmds = new ArrayList<String>();
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String ohName = oh.getName() == null ? "" : oh.getName().replace(" ", "");
        String user = oh.getOwner();
        if (user == null || user.equals("")) {
            user = "user";
        }
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        String phBaseFile = "/tmp/" + ohName + "_" + user + "_patchList";
        if (env.isTargetOnWindows()) {
            phBaseFile = oh.getPath() + "\\.patch_storage\\" + ohName + "_" + user + "_patchList";
        }
        cmds.addAll(this.writePatchLocationsToFileCommand(sortedPatches, phBaseFile));
        String opatchPath = CommandUtils.getOPatchPath(oh);
        String cmd = opatchPath + " napply -phBaseFile " + phBaseFile + " -local " + invPtrOption + " -oh " + oh.getPath();
        if (this.s.equals((Object)Strategy.DCLI)) {
            cmd = cmd + " -silent";
        }
        if ((env.getExecutionMode().equals((Object)ExecutionMode.EM) || env.getExecutionMode().equals((Object)ExecutionMode.OPATCH)) && !cmd.contains("-silent")) {
            cmd = cmd + " -silent";
        }
        if ((opatchNapplyOptions = env.getOPatchNapplyOptions()) != null) {
            for (Map.Entry<String, String> entry : opatchNapplyOptions.entrySet()) {
                String key = entry.getKey();
                if (cmd.contains(key) || this.IsExclusive(key)) continue;
                cmd = cmd + this.ConstructOptions(entry.getKey(), entry.getValue());
            }
        }
        cmds.add(cmd);
        return cmds;
    }

    private boolean IsExclusive(String key) {
        return "-remote".equals(key);
    }

    private String ConstructOptions(String key, String value) {
        return " " + key + " " + value;
    }

    private List<String> writePatchLocationsToFileCommand(List<GenericPatch> sortedPatches, String phBaseFile) {
        ArrayList<String> cmds = new ArrayList<String>();
        boolean firstPatch = true;
        for (GenericPatch patch : sortedPatches) {
            String echoCmd = "";
            if (firstPatch) {
                echoCmd = "echo " + patch.getPatchLocation() + " > " + phBaseFile;
                firstPatch = false;
            } else {
                echoCmd = echoCmd + "echo " + patch.getPatchLocation() + " >> " + phBaseFile;
            }
            cmds.add(echoCmd);
        }
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchApplyCommand> {
        @Override
        public OPatchApplyCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("apply")) {
                return null;
            }
            OPatchApplyCommand com = new OPatchApplyCommand(a, s);
            return com;
        }
    }
}

