/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Operation;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.OPlanAccessOptParamKeys;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchLsinventoryGrepCommand
extends SimpleShellCommand {
    public OPatchLsinventoryGrepCommand(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        String GREP_COMMAND = CommandUtils.getGrepCommand(oh);
        ArrayList<String> cmds = new ArrayList<String>();
        String opatchPath = CommandUtils.getOPatchPath(oh);
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        List<GenericPatch> patches = !env.getExecutionMode().equals((Object)ExecutionMode.EM) ? env.getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        CommandUtils.storePatchIDsInContext(context, patches);
        for (GenericPatch patch : patches) {
            if (!(patch instanceof OPatchSingleton) && !(patch instanceof CompositePatch)) continue;
            String mkdirCmd = "";
            String customLogDirCmd = "";
            Map<OPlanAccessOptParamKeys, String> optParam = OPlan.getInstance().getOPlanEnv().getOptionalParam();
            if (optParam.containsKey((Object)OPlanAccessOptParamKeys.opatchCustomLogDir)) {
                String customLogDirPath = CommandUtils.getCustomLogDir(optParam.get((Object)OPlanAccessOptParamKeys.opatchCustomLogDir), oh.getPath());
                mkdirCmd = "mkdir -p " + customLogDirPath + " ; ";
                customLogDirCmd = " -customLogDir " + customLogDirPath;
            }
            String cmd = mkdirCmd + opatchPath + " lsinventory" + invPtrOption + " -oh " + oh.getPath() + customLogDirCmd + " | " + GREP_COMMAND + " " + patch.getPatchID();
            if (env.getExecutionMode().equals((Object)ExecutionMode.EM) && env.getOperation().equals((Object)Operation.ROLLBACK)) {
                if (!env.isTargetOnWindows()) {
                    cmd = "tmp=$(" + cmd + ");test ! \"$tmp\"";
                } else {
                    String user = oh.getOwner();
                    if (user == null || user.equals("")) {
                        user = "user";
                    }
                    String tmpFile = oh.getPath() + "\\.patch_storage\\OplanLsi_" + user + ".tmp";
                    String emptyFile = oh.getPath() + "\\.patch_storage\\emptyfile_" + user;
                    String createEmptyFile = "type nul > " + emptyFile;
                    String fc = "fc " + tmpFile + " " + emptyFile + " > nul";
                    cmd = cmd + " > " + tmpFile + " & " + createEmptyFile + " & " + fc;
                }
            }
            cmds.add(cmd);
        }
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchLsinventoryGrepCommand> {
        @Override
        public OPatchLsinventoryGrepCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("lsinventorygrepforpatches")) {
                return null;
            }
            OPatchLsinventoryGrepCommand com = new OPatchLsinventoryGrepCommand(a);
            return com;
        }
    }
}

