/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.cmdtranslator.commands;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import model.common.OracleHome;
import model.patchmodel.CompositePatch;
import model.patchmodel.GenericPatch;
import model.patchmodel.OPatchSingleton;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.OpatchAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.SimpleShellCommand;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchRollbackCommand
extends SimpleShellCommand {
    protected Strategy s = Strategy.MANUAL;

    public OPatchRollbackCommand(ActionType a, Strategy s) {
        super(a);
        this.s = s;
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        Map<String, String> opatchRollbackOptions;
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType(oh.getHomeType())) : CommandUtils.getPatchesByOHOwnerForEM(oh);
        if (patches == null || patches.size() == 0) {
            return null;
        }
        CommandUtils.storePatchIDsInContext(context, patches);
        String invPtrOption = CommandUtils.getInvPtrOption(oh);
        String opatchPath = CommandUtils.getOPatchPath(oh);
        StringBuffer ids = new StringBuffer();
        OPlanEnv env = OPlan.getInstance().getOPlanEnv();
        for (GenericPatch patch : patches) {
            if (patch instanceof OPatchSingleton) {
                if (ids.length() > 0) {
                    ids.append(",");
                }
                ids.append(patch.getPatchID());
            }
            if (!(patch instanceof CompositePatch)) continue;
            CompositePatch cpatch = (CompositePatch)patch;
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append(cpatch.getPatchIdOfRollbackPatch());
        }
        String cmd = opatchPath + " nrollback -local -id " + ids.toString() + invPtrOption + " -oh " + oh.getPath();
        if (this.s.equals((Object)Strategy.DCLI)) {
            cmd = cmd + " -silent";
        }
        if ((env.getExecutionMode().equals((Object)ExecutionMode.EM) || env.getExecutionMode().equals((Object)ExecutionMode.OPATCH)) && !cmd.contains("-silent")) {
            cmd = cmd + " -silent";
        }
        if ((opatchRollbackOptions = env.getOPatchRollbackOptions()) != null) {
            for (Map.Entry<String, String> entry : opatchRollbackOptions.entrySet()) {
                String key = entry.getKey();
                if (cmd.contains(key) || this.IsExclusive(key)) continue;
                cmd = cmd + this.ConstructOptions(entry.getKey(), entry.getValue());
            }
        }
        return Collections.singletonList(cmd);
    }

    private boolean IsExclusive(String key) {
        return "-remote".equals(key);
    }

    private String ConstructOptions(String key, String value) {
        return " " + key + " " + value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<OPatchRollbackCommand> {
        @Override
        public OPatchRollbackCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof OpatchAction) || !a.getType().equals("rollback")) {
                return null;
            }
            OPatchRollbackCommand com = new OPatchRollbackCommand(a, s);
            return com;
        }
    }
}

