/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.sdk.exec.api;

import java.util.ArrayList;
import java.util.List;
import model.common.AbstractBaseTarget;
import oracle.oplan.sdk.exec.api.ExecutionStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupByTargetType<T extends AbstractBaseTarget> {
    private final List<ExecutionStep> steps;
    private List<TargetGroup<T>> targetGrouping = new ArrayList<TargetGroup<T>>();
    private boolean worthGrouping = true;
    private final Class<T> clazz;

    public GroupByTargetType(Class<T> clazz, List<ExecutionStep> steps) {
        this.steps = steps;
        this.clazz = clazz;
        this.makeTargetGroup();
    }

    public boolean isWorthGrouping() {
        return this.worthGrouping;
    }

    private void makeTargetGroup() {
        TargetGroup<T> prev = null;
        ArrayList<T> targets = new ArrayList<T>();
        for (ExecutionStep step : this.steps) {
            T tgt = this.extractTarget(step);
            if (prev == null || prev.getTarget() != null && !prev.getTarget().equals(tgt)) {
                prev = new TargetGroup<T>(tgt);
                prev.getExecSteps().add(step);
                this.targetGrouping.add(prev);
                if (targets.contains(tgt)) {
                    this.worthGrouping = false;
                }
                targets.add(tgt);
                continue;
            }
            prev.getExecSteps().add(step);
        }
    }

    private T extractTarget(ExecutionStep step) {
        return step.getStepProperties().getFirstTarget(this.clazz);
    }

    public List<TargetGroup<T>> getTargetGrouping() {
        return this.targetGrouping;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TargetGroup<T extends AbstractBaseTarget> {
        T target;
        List<ExecutionStep> execSteps;

        public TargetGroup(T target) {
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }

        public void setTarget(T target) {
            this.target = target;
        }

        public List<ExecutionStep> getExecSteps() {
            if (this.execSteps == null) {
                this.execSteps = new ArrayList<ExecutionStep>();
            }
            return this.execSteps;
        }
    }
}

