/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.util;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapHelper;
import com.oracle.glcm.patch.auto.db.util.BootstrapParams;
import com.oracle.glcm.patch.auto.db.util.BootstrapPlugin;
import com.oracle.glcm.patch.auto.db.util.BootstrapResult;
import com.oracle.glcm.patch.auto.db.utils.BootstrapConstants;
import com.oracle.glcm.patch.auto.db.utils.BootstrapUtil;
import com.oracle.glcm.patch.auto.session.PatchInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.sysman.oii.oiii.OiiiVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SRVMBootstrapPlugin
implements BootstrapPlugin {
    private Logger _logger = Logger.getLogger(SRVMBootstrapPlugin.class.getName());
    private static final int MAX_UNIQUE_ID_FOR_OCT_PSU_OR_BP = 18013887;
    private Properties prop = new Properties();
    private String patchInformationForBootstrapping = "";

    @Override
    public BootstrapResult execute(BootstrapParams bootstrapParams) {
        BootstrapResult bootstrapResult = new BootstrapResult();
        bootstrapResult.setPluginType(BootstrapResult.PluginType.SRVM);
        bootstrapResult.setResult(BootstrapResult.Status.SUCCESS);
        try {
            this.setPatchInformation(bootstrapParams.getPatchInfo());
            if (!bootstrapParams.isStandaloneSidbPatching()) {
                if (bootstrapParams.isRemotePatching()) {
                    String pathWithFilesFromLoc = bootstrapParams.getPathWithFilesFromLoc();
                    this.prop.setProperty(BootstrapConstants.COMMAND.getValue(), bootstrapParams.getOperationType().name().toLowerCase());
                    this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), pathWithFilesFromLoc);
                } else if (!StringUtil.isNullOrEmpty((String)bootstrapParams.getPatchInfo().getPatchId())) {
                    this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
                    this._logger.info("Updating properties while rolling back using patch ID ");
                } else {
                    this.processPatchLocation(bootstrapParams.getPatchInfo(), bootstrapParams.getGridHome(), bootstrapParams.getGridVersion());
                }
                String gridHomeLoc = bootstrapParams.getGridHome();
                if (!StringUtil.isNullOrEmpty((String)gridHomeLoc, (boolean)true)) {
                    this.prop.setProperty(BootstrapConstants.GRID_HOME_PATH.getValue(), gridHomeLoc);
                }
                this.setOraclebaseLocation();
                BootstrapUtil.storePropertiesFile((Properties)this.prop, (String)(System.getProperty(BootstrapConstants.OPATCHAUTO_PATCHWORK_PATH.getValue()) + File.separator + BootstrapConstants.BOOTSTRAP_PROPERTIES.getValue()), (boolean)true);
            }
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(PatchActionUtil.getBashCmd());
            cmds.add("-c");
            String currentUser = System.getProperty("user.name");
            this._logger.fine("The currentUser is: " + currentUser);
            int retValue = 0;
            String scriptPath = bootstrapParams.getBaseLocation() + File.separator + "OPatch" + File.separator + "auto" + File.separator + "database" + File.separator + "bin" + File.separator + "BootStrapping.pl";
            Credential credential = bootstrapParams.getCredential();
            String shellCmd = BootstrapHelper.getPerlLibPath(bootstrapParams.getBaseLocation(), bootstrapParams.isRemotePatching()) + " " + scriptPath + " " + this.getArguments(bootstrapParams);
            this._logger.fine("The command is : " + shellCmd);
            if (credential == null) {
                cmds.add(shellCmd);
            } else {
                String homeOwner = DBPatchingHelper.getHomeOwner((String)bootstrapParams.getBaseLocation());
                this._logger.fine("The home owner is : " + homeOwner);
                if (!currentUser.equalsIgnoreCase(homeOwner) && !"root".equalsIgnoreCase(currentUser)) {
                    cmds.add("echo '" + new String(credential.getPassword()) + "'" + " | " + PatchActionUtil.getSudoCmd() + " -S -u " + homeOwner + " " + shellCmd);
                } else {
                    cmds.add(shellCmd);
                }
            }
            this._logger.info("Executing BootStrapping.pl");
            retValue = BootstrapHelper.execute(cmds, true);
            if (retValue != 0) {
                bootstrapResult.setResult(BootstrapResult.Status.FAILED);
                bootstrapResult.setErrorCode(72058);
                bootstrapResult.setErrorMessage("BootStrapping.pl execution failed with return value " + retValue);
            }
            this._logger.info("Return value from bootstrap : " + retValue);
        }
        catch (Exception ex) {
            this._logger.severe(ex.getMessage());
            bootstrapResult.setResult(BootstrapResult.Status.FAILED);
            bootstrapResult.setErrorCode(72058);
            bootstrapResult.setErrorMessage(ex.getMessage());
        }
        this._logger.fine("Completed srvm bootstrapping with result " + bootstrapResult);
        return bootstrapResult;
    }

    private void processPatchLocation(PatchInfo patchInfo, String gridHome, String gridVersion) throws OPatchAutoException {
        String bundleXMLpath;
        File automationFile;
        String path = StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory()) ? patchInfo.getPatchLocation() : patchInfo.getPatchBaseDirectory();
        String bundleXMLPath = BootstrapHelper.searchBundleXML(new File(path));
        if (!StringUtil.isNullOrEmpty((String)bundleXMLPath, (boolean)true)) {
            this.patchInformationForBootstrapping = path = new File(bundleXMLPath).getParent();
            this._logger.fine(" Updated patch location : " + path);
        }
        if ((automationFile = new File(bundleXMLpath = path + File.separator + BootstrapConstants.BUNDLE_XML.getValue())) != null && automationFile.exists() && !automationFile.isDirectory()) {
            this.startBootStrapping(automationFile, gridHome, gridVersion);
        } else {
            this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
        }
    }

    private void startBootStrapping(File automationFile, String gridHome, String gridVersion) throws OPatchAutoException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(automationFile);
            doc.getDocumentElement().normalize();
            System.setProperty("ORACLE_HOME", gridHome);
            OiiiVersion crsVersionNo = new OiiiVersion(OiiiVersion.maskLastVersionDigit((String)gridVersion));
            this._logger.info("Crsversion:" + crsVersionNo.getVerString());
            boolean isFound = this.isBootstrappingFromHome(doc, crsVersionNo);
            if (!isFound) {
                this.checkBootstrapLibInPatch(doc);
            }
        }
        catch (ParserConfigurationException e) {
            this._logger.info("Error: ParserConfigurationException: " + e.getMessage());
            throw new OPatchAutoException("Failed while parsing file " + automationFile + " due to ParserConfigurationException : " + e.getMessage(), new Object[0]);
        }
        catch (SAXException e) {
            this._logger.info("Error: SAXException: " + e.getMessage());
            throw new OPatchAutoException("Failed while parsing file " + automationFile + " due to SAXException : " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this._logger.info("Error: IOException: " + e.getMessage());
            throw new OPatchAutoException("Failed while parsing file " + automationFile + " due to IOException : " + e.getMessage(), new Object[0]);
        }
    }

    private boolean isBootstrappingFromHome(Document doc, OiiiVersion crsVersionNo) {
        boolean isFound = false;
        NodeList targetNodeList = doc.getElementsByTagName("target_type");
        if (targetNodeList != null && targetNodeList.getLength() > 0) {
            for (int j = 0; j < targetNodeList.getLength(); ++j) {
                Element el = (Element)targetNodeList.item(j);
                if (!el.hasAttribute("version")) continue;
                String version = el.getAttribute("version");
                OiiiVersion patchVersionNo = new OiiiVersion(version);
                this._logger.fine("Patch version:" + patchVersionNo.getVerString());
                if (!crsVersionNo.laterThan(patchVersionNo)) continue;
                this._logger.info("CRS version greater than the patch version:" + patchVersionNo.getVerString());
                this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
                isFound = true;
            }
        } else {
            this._logger.info("No node element found in bundle xml");
            isFound = true;
            this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
        }
        return isFound;
    }

    private void setOraclebaseLocation() {
        String ohPath = this.prop.getProperty(BootstrapConstants.GRID_HOME_PATH.getValue());
        if (StringUtil.isNullOrEmpty((String)ohPath)) {
            ohPath = System.getProperty(BootstrapConstants.OPATCH_ORACLE_HOME.getValue());
        }
        String oracleBase = OUIDriver.checkOracleBase((String)ohPath);
        this._logger.info("Oracle base location:" + oracleBase);
        this.prop.setProperty(BootstrapConstants.ORACLE_BASE.getValue(), oracleBase);
    }

    private void checkBootstrapLibInPatch(Document doc) {
        NodeList nodeList = doc.getElementsByTagName("system_patch_bundle_xml");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element el = (Element)nodeList.item(j);
                if (el.hasAttribute("unique_patch_id")) {
                    String uniquePatchID = el.getAttribute("unique_patch_id");
                    if (Integer.parseInt(uniquePatchID) > 18013887) {
                        this._logger.info("Patch unique version is greater than min bootstrap patch version");
                        this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "patch");
                        continue;
                    }
                    this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
                    continue;
                }
                this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
            }
        } else {
            this.prop.setProperty(BootstrapConstants.BOOTSTRAP_PATH.getValue(), "gihome");
        }
    }

    private String getArguments(BootstrapParams bootstrapParams) throws OPatchAutoException, IOException {
        StringBuffer arguments = new StringBuffer();
        arguments.append(" -detect_oh=" + bootstrapParams.getBaseLocation());
        arguments.append(" -customLogDir=" + bootstrapParams.getCustomLogDir());
        arguments.append(" -customConfigDir=" + bootstrapParams.getCustomConfigDir());
        arguments.append(" -operationtype=" + bootstrapParams.getOperationType().name().toLowerCase());
        arguments.append(" -isActionSession=" + (bootstrapParams.isRemotePatching() ? "1" : "0"));
        arguments.append(" -patch_path=" + this.patchInformationForBootstrapping);
        arguments.append(" -DEBUGVAL=" + bootstrapParams.isEnableDebugging());
        arguments.append(" -sidb=" + bootstrapParams.isStandaloneSidbPatching());
        arguments.append(" -PATCHWORK=" + BootstrapHelper.getPatchWorkDirectory());
        arguments.append(" ");
        return arguments.toString();
    }

    private void setPatchInformation(PatchInfo patchInfo) {
        String string = this.patchInformationForBootstrapping = StringUtil.isNullOrEmpty((String)patchInfo.getPatchBaseDirectory()) ? patchInfo.getPatchLocation() : patchInfo.getPatchBaseDirectory();
        if (StringUtil.isNullOrEmpty((String)this.patchInformationForBootstrapping)) {
            this.patchInformationForBootstrapping = patchInfo.getPatchId();
        }
    }
}

