/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.patchmodel.GenericPatch;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.ExecutionMode;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.cmdtranslator.commands.GenericShellCommand;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrePostRACPatchScriptCommand
extends GenericShellCommand {
    private String type;
    private List<String> scriptList = new ArrayList<String>();
    private String script;

    private PrePostRACPatchScriptCommand(CommandAction commandAction) {
        super(commandAction);
        this.type = commandAction.getType();
    }

    public List<ExecutionStep> generateExecutionSteps(ConfigGraph configGraph, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> executionSteps = new ArrayList<ExecutionStep>();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            if (!this.checkIfStepValid(configGraph, abstractBaseTarget)) continue;
            for (int i = 0; i < this.scriptList.size(); ++i) {
                this.script = this.scriptList.get(i);
                ExecutionStep es = this.getExecutionStep(configGraph, abstractBaseTarget);
                if (es == null) continue;
                executionSteps.add(es);
            }
        }
        return executionSteps;
    }

    private boolean checkIfStepValid(ConfigGraph g, AbstractBaseTarget t) {
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        CommandContext context = contextPopulator.populateContext(g, t);
        if (this.automationAction.isActsOnClone()) {
            contextPopulator.fixCloneContext(context);
        }
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        List<GenericPatch> patches = this.getPatches(oh);
        String filename = "prepatch.sh";
        if (this.type.equalsIgnoreCase("postRACPatchApplyshell") || this.type.equalsIgnoreCase("postRACPatchRollbackshell")) {
            filename = "postpatch.sh";
        }
        for (GenericPatch patch : patches) {
            Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("PatchRoot: " + patch.getPatchLocation());
            String path = patch.getPatchLocation() + "/custom/scripts/" + filename;
            File f = new File(path);
            if (!f.exists() || f.isDirectory() || this.scriptList.contains(path)) continue;
            this.scriptList.add(path);
        }
        Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("isValid: " + this.scriptList.size());
        return this.scriptList.size() > 0;
    }

    private List<GenericPatch> getPatches(OracleHome oh) {
        List patches;
        if (this.type.equalsIgnoreCase("postRACPatchApplyshell") || this.type.equalsIgnoreCase("preRACPatchApplyshell")) {
            List patchList = !OPlan.getInstance().getOPlanEnv().getExecutionMode().equals((Object)ExecutionMode.EM) ? OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString()) : CommandUtils.getPatchesByOHOwnerForEM((OracleHome)oh);
            patches = CommandUtils.sortPatchesById((List)patchList);
        } else {
            patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.valueOf(oh.getHomeType()).toString());
        }
        return patches;
    }

    public List<String> getShellCommands(CommandContext context) {
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        ArrayList<String> cmds = new ArrayList<String>();
        StringBuilder cmd = new StringBuilder(this.script);
        cmd.append(" ");
        cmd.append("-dbhome");
        cmd.append(" ");
        cmd.append(oh.getPath());
        Logger.getLogger(PrePostRACPatchScriptCommand.class.getName()).info("cmd: " + cmd.toString());
        cmds.add(cmd.toString());
        return cmds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements CommandBuilder<PrePostRACPatchScriptCommand> {
        public PrePostRACPatchScriptCommand getCommand(ActionType a, Strategy s) {
            if (a instanceof CommandAction && a.getType() != null && (a.getType().equals("preRACPatchApplyshell") || a.getType().equals("postRACPatchApplyshell") || a.getType().equals("preRACPatchRollbackshell") || a.getType().equals("postRACPatchRollbackshell"))) {
                return new PrePostRACPatchScriptCommand((CommandAction)a);
            }
            return null;
        }
    }
}

