/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.cmdtranslator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.opatch.system.automation.jaxb.ActionType;
import oracle.opatch.system.automation.jaxb.CommandAction;
import oracle.opatch.system.automation.jaxb.Strategy;
import oracle.oplan.db.cmdtranslator.DBCommandUtils;
import oracle.oplan.db.cmdtranslator.SqlCommandUtils;
import oracle.oplan.db.cmdtranslator.commands.CRSCommandActionType;
import oracle.oplan.db.cmdtranslator.commands.SqlPatchCommand;
import oracle.oplan.db.engine.CRSContextPopulator;
import oracle.oplan.db.patch.CRSApplicabilityTarget;
import oracle.oplan.sdk.cmdtranslator.Command;
import oracle.oplan.sdk.cmdtranslator.CommandBuilder;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cmdtranslator.CommandUtils;
import oracle.oplan.sdk.exec.api.ExecutionStep;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.SystemModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopStartSqlHomeCommand
extends Command {
    private static String OPLAN_LOG = null;
    CommandAction automationAction;
    Logger logger = Logger.getLogger(SqlPatchCommand.class.getName());

    public StopStartSqlHomeCommand(CommandAction automationAction) {
        super((ActionType)automationAction);
        this.automationAction = automationAction;
    }

    protected List<ExecutionStep> generateExecutionSteps(ConfigGraph g, List<? extends AbstractBaseTarget> actsOnlyOnTargets) {
        ArrayList<ExecutionStep> steps = new ArrayList<ExecutionStep>();
        CRSContextPopulator contextPopulator = new CRSContextPopulator();
        for (AbstractBaseTarget abstractBaseTarget : actsOnlyOnTargets) {
            ExecutionStep executionStep;
            CommandContext context = contextPopulator.populateContext(g, abstractBaseTarget);
            if (this.automationAction.isActsOnClone()) {
                contextPopulator.fixCloneContext(context);
            }
            if ((executionStep = this.getExecutionStep(context)) == null) continue;
            steps.add(executionStep);
        }
        return steps;
    }

    protected ExecutionStep getExecutionStep(CommandContext context) {
        List patches;
        OracleHome oh = (OracleHome)context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget db = context.getPrimaryTarget();
        if (DBCommandUtils.shouldExecuteSqlCommand(db, patches = OPlan.getInstance().getOPlanEnv().getPatchesBag().getPatchesForTargetType(CommandUtils.getApplicabilityTargetType((String)CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString())), (ActionType)this.automationAction)) {
            if (DBCommandUtils.isPhysicalStandbyDatabase(db)) {
                context = DBCommandUtils.resetContextForStandbyDB(db);
                oh = (OracleHome)context.getFirstTarget(OracleHome.class);
                db = context.getPrimaryTarget();
            }
            ExecutionStep executionStep = CommandUtils.getBasicExecutionStep((ActionType)this.automationAction, (CommandContext)context, null);
            if (this.automationAction.isActsOnClone() && DBCommandUtils.isRemoteDB(db)) {
                this.logger.info("Current step is running on remote db " + db.getDisplayName() + ". Set acts_on_clone property to null");
                executionStep.getAutomationAction().setActsOnClone(null);
            }
            OPLAN_LOG = "$ORACLE_HOME" + File.separator + "cfgtoollogs" + File.separator + "oplan";
            ArrayList<String> cmds = new ArrayList<String>();
            String oracleSid = SqlCommandUtils.getOracleSIDForActiveInstance(executionStep, db);
            boolean isSQLPatchUpgradeMode = false;
            if ((db instanceof SIDatabase || db instanceof RACDatabase) && db instanceof RACDatabase && (isSQLPatchUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode())) {
                String type = "";
                if (this.automationAction.getType().equals(CRSCommandActionType.SqlHomeStart.toString())) {
                    type = "start";
                } else if (this.automationAction.getType().equals(CRSCommandActionType.SqlHomeStop.toString())) {
                    type = "stop";
                }
                List hosts = context.getTargets(Host.class);
                for (Host host : hosts) {
                    this.getStopStartHomeCommand(oh, type, cmds, host.getHostName());
                }
            }
            for (String s : cmds) {
                executionStep.getCommand().add(new ExecutionStep.Command(s));
            }
            if (cmds != null && cmds.size() == 0) {
                executionStep = null;
            }
            return executionStep;
        }
        return null;
    }

    private static String getUUID(OracleHome oh) {
        boolean clone = false;
        if (oh.getOriginalOracleHome() != null) {
            oh = oh.getOriginalOracleHome();
            clone = true;
        }
        String str = oh.getUniqueId().replace(':', '_');
        if (clone) {
            str = str + "_clone";
        }
        return str;
    }

    private void getStopStartHomeCommand(OracleHome oh, String type, List<String> cmds, String hostName) {
        String uuid = StopStartSqlHomeCommand.getUUID(oh);
        String staFileLoc = "$ORACLE_HOME" + File.separator + "cfgtoollogs" + File.separator + "oplan" + File.separator + "statfile" + File.separator + hostName;
        cmds.add("mkdir -p " + staFileLoc);
        File statefile = new File(staFileLoc, uuid + "_" + hostName + ".stat");
        String cmd = "cd $ORACLE_HOME; ORACLE_HOME=" + oh.getPath() + " ./bin/srvctl " + type + " home -o " + "$ORACLE_HOME" + " -n " + hostName;
        if (type.equalsIgnoreCase("stop")) {
            cmd = cmd + " -f";
            if (oh.getHomeType().equals("rac")) {
                String version = DBCommandUtils.getRACDBVersionForCurrentHome(oh);
                if (version != null) {
                    cmd = version.startsWith("11") ? cmd + " -t TRANSACTIONAL" : cmd + " -stopoption TRANSACTIONAL";
                } else {
                    Logger.getLogger(SqlPatchCommand.class.getName()).info("Unable to get the DB version, so not performing stop DB home in transactional mode");
                }
            }
        }
        cmd = cmd + " -s " + statefile;
        cmds.add(cmd);
        if (type.equalsIgnoreCase("start")) {
            cmds.add("rm -rf " + staFileLoc);
        }
    }

    protected List<? extends AbstractBaseTarget> getApplicableTargets(ConfigGraph g) {
        Class type = SystemModelUtils.getClassForType((String)this.automationAction.getActsOn());
        return g.getTargets(type, this.automationAction.getStripe());
    }

    public static class Builder
    implements CommandBuilder {
        public Command getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(CRSCommandActionType.SqlHomeStart.toString()) && !a.getType().equals(CRSCommandActionType.SqlHomeStop.toString())) {
                return null;
            }
            return new StopStartSqlHomeCommand((CommandAction)a);
        }
    }
}

