/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import model.common.AbstractBaseTarget;
import model.common.Host;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.HAS;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import model.db_crs.SIDatabase;
import oracle.oplan.db.cookies.CRSMakeCloneHome;
import oracle.oplan.sdk.cmdtranslator.CommandContext;
import oracle.oplan.sdk.cookies.CloneCookie;
import oracle.oplan.sdk.engine.ContextPopulator;
import oracle.oplan.sdk.graphlib.ConfigGraph;
import oracle.oplan.sdk.intg.OPlanIntgFactory;
import oracle.oplan.sdk.oplan.OPlan;

public class CRSContextPopulator
extends ContextPopulator {
    static Logger logger = Logger.getLogger(CRSContextPopulator.class.getName());

    public void fixCloneContext(CommandContext context) {
        List origs = context.getTargets(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        ArrayList<OracleHome> clones = new ArrayList<OracleHome>();
        for (OracleHome orig : origs) {
            CRSMakeCloneHome makeCloneHome = (CRSMakeCloneHome)OPlan.getInstance().getMakeCloneHome();
            List<OracleHome> clonehomes = makeCloneHome.getHomeClone(orig);
            for (OracleHome clone : clonehomes) {
                if ((primaryTarget instanceof RACDatabase || primaryTarget instanceof RACDBInstance || primaryTarget instanceof SIDatabase) && primaryTarget.getProperty(CloneCookie.class) != null) {
                    if (!((CloneCookie)primaryTarget.getProperty(CloneCookie.class)).getClonePath().equals(clone.getPath())) continue;
                    clones.add(clone);
                    continue;
                }
                clones.add(clone);
            }
        }
        if (context.getPrimaryTarget() instanceof OracleHome) {
            List oracleHomes = OPlan.getInstance().getMakeCloneHome().getHomeClone((OracleHome)context.getPrimaryTarget());
            context.setPrimaryTarget((AbstractBaseTarget)oracleHomes.get(0));
        }
        if (clones != null && clones.size() != 0) {
            context.putTargets(clones);
        }
    }

    private CommandContext populateContextForRACDatabase(ConfigGraph g, RACDatabase racDB) {
        CommandContext context = new CommandContext();
        ArrayList<RACDBInstance> instances = new ArrayList<RACDBInstance>();
        ArrayList<Host> hosts = new ArrayList<Host>();
        ArrayList<OracleHome> oracleHomeList = new ArrayList<OracleHome>();
        List sortedHosts = g.getTargets(Host.class);
        OPlanIntgFactory oplanIntgFactory = OPlan.getInstance().getOPlanIntgFactory();
        sortedHosts = oplanIntgFactory.getSequencingEngineUtils().sortHosts(g.getTargets(Host.class), g);
        for (Host host : sortedHosts) {
            for (RACDBInstance inst : g.getConnectedTargets((AbstractBaseTarget)racDB, RACDBInstance.class)) {
                if (!inst.getHost().getName().equalsIgnoreCase(host.getName())) continue;
                instances.add(inst);
                hosts.add(inst.getHost());
                oracleHomeList.add(this.getRunsFromHome(g, (AbstractBaseTarget)inst));
            }
        }
        context.setPrimaryTarget((AbstractBaseTarget)racDB);
        context.putTargets(instances);
        context.putTargets(hosts);
        context.putTargets(oracleHomeList);
        return context;
    }

    private CommandContext populateContextForRACDBInstance(ConfigGraph g, RACDBInstance dbinst) {
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)dbinst);
        context.putTarget((AbstractBaseTarget)dbinst.getDbRAC());
        context.putTarget((AbstractBaseTarget)dbinst.getHost());
        context.putTarget((AbstractBaseTarget)this.getRunsFromHome(g, (AbstractBaseTarget)dbinst));
        return context;
    }

    private CommandContext populateContextForCluster(ConfigGraph g, CRSCluster cluster) {
        ArrayList hosts = new ArrayList(cluster.getNodes());
        Collections.sort(hosts, g.getComparator());
        CommandContext context = new CommandContext();
        context.setPrimaryTarget((AbstractBaseTarget)cluster);
        context.putTargets(hosts);
        ArrayList<HAS> has = new ArrayList<HAS>();
        ArrayList<OracleHome> ohs = new ArrayList<OracleHome>();
        for (HAS inst : g.getConnectedTargets((AbstractBaseTarget)cluster, HAS.class)) {
            has.add(inst);
            ohs.add(this.getRunsFromHome(g, (AbstractBaseTarget)inst));
        }
        if (has.size() > 0) {
            context.putTargets(has);
            context.putTargets(ohs);
        }
        return context;
    }

    public CommandContext populateContext(ConfigGraph g, AbstractBaseTarget target) {
        if (target instanceof RACDatabase) {
            return this.populateContextForRACDatabase(g, (RACDatabase)target);
        }
        if (target instanceof RACDBInstance) {
            return this.populateContextForRACDBInstance(g, (RACDBInstance)target);
        }
        if (target instanceof OracleHome) {
            return this.populateContextForOH(g, (OracleHome)target);
        }
        if (target instanceof CRSCluster) {
            return this.populateContextForCluster(g, (CRSCluster)target);
        }
        return this.getGenericContext(g, target);
    }
}

