/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.oplan;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.Host;
import model.db_crs.CRSCluster;
import oracle.oplan.sdk.oplan.OPlan;
import oracle.oplan.sdk.oplan.OPlanEnv;
import oracle.oplan.sdk.oplan.OPlanUserException;
import oracle.osysmodel.driver.sdk.productdriver.OUIDriver;

public class CandidateHomeCheck {
    Logger logger = Logger.getLogger(CandidateHomeCheck.class.getName());
    SystemInstance si;

    public CandidateHomeCheck(SystemInstance si) {
        this.si = si;
    }

    public boolean checkCandidateHomeOfRAC() throws OPlanUserException {
        block13: {
            OPlanEnv env = OPlan.getInstance().getOPlanEnv();
            String localSourceOH = System.getenv("ORACLE_HOME");
            try {
                if (localSourceOH != null) {
                    this.logger.log(Level.INFO, "Local source oracle home is:\t" + localSourceOH);
                    String candidateOH = env.getProperty("MoveConfigToOH");
                    this.logger.log(Level.INFO, "Specified candidate home is:\t" + candidateOH);
                    if (candidateOH == null || candidateOH.length() <= 0) break block13;
                    Object[] compInfo = this.getTopLevelCompOfOracleHome(localSourceOH);
                    if (compInfo != null) {
                        String localHost = this.checkLocalHost();
                        CRSCluster crsCluster = (CRSCluster)this.si.getTargetsOfType(CRSCluster.class).get(0);
                        if (crsCluster != null) {
                            HashMap map;
                            List nodeList = crsCluster.getNodes();
                            String[] remoteNodeList = new String[nodeList.size() - 1];
                            for (int i = 0; i < nodeList.size(); ++i) {
                                Host node = (Host)nodeList.get(i);
                                String nodeName = node.getNodeName();
                                if (nodeName.equalsIgnoreCase(localHost)) continue;
                                remoteNodeList[i] = nodeName;
                            }
                            if (System.getProperty("oracle.installer.scratchPath") == null || System.getProperty("oracle.installer.scratchPath").length() == 0) {
                                System.setProperty("oracle.installer.scratchPath", "/tmp");
                            }
                            if ((map = OUIDriver.isHomeOnRemoteNode((String[])remoteNodeList, (String)candidateOH, (Object)compInfo[0], (Object)compInfo[1])) != null) {
                                String isHomeOnRemoteNode;
                                String isClusterInv = null;
                                if (map.get("IS_CLUSTER_INV") != null) {
                                    isClusterInv = (String)map.get("IS_CLUSTER_INV");
                                }
                                if ("YES".equals(isClusterInv)) {
                                    isHomeOnRemoteNode = null;
                                    if (map.get("IS_HOME_ON_REMOTE_NODE") != null && "NO".equals(isHomeOnRemoteNode = (String)map.get("IS_HOME_ON_REMOTE_NODE"))) {
                                        return false;
                                    }
                                } else {
                                    isHomeOnRemoteNode = null;
                                    if (map.get("IS_HOME_ON_REMOTE_NODE") != null && "NO".equals(isHomeOnRemoteNode = (String)map.get("IS_HOME_ON_REMOTE_NODE"))) {
                                        return false;
                                    }
                                }
                            }
                            return true;
                        }
                        break block13;
                    }
                    this.logger.log(Level.INFO, "Can not get top level component in oracle home " + localSourceOH);
                    return false;
                }
                this.logger.log(Level.INFO, "The enviroment varibale \"ORACLE_HOME\" does not set");
                return false;
            }
            catch (Exception e) {
                throw new OPlanUserException((Throwable)e, "ERROR_TO_CHECK_CLONE_HOME", new Object[]{localSourceOH, e.getMessage()});
            }
        }
        return true;
    }

    private String checkLocalHost() {
        return OPlan.getInstance().getLocalInfo().getLocalHostName();
    }

    public Object[] getTopLevelCompOfOracleHome(String oracleHome) {
        return OUIDriver.getTopLevelCompOfOracleHome((String)oracleHome);
    }
}

