/*
 * Decompiled with CFR 0.152.
 */
package oracle.oplan.db.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.SystemInstance;
import model.common.AbstractBaseTarget;
import model.common.OracleHome;
import model.db_crs.CRSCluster;
import model.db_crs.RACDBInstance;
import model.db_crs.RACDatabase;
import oracle.oplan.db.validation.causes.MultipleCRSObject;
import oracle.oplan.db.validation.causes.NoCRS;
import oracle.oplan.db.validation.causes.NoRAC;
import oracle.oplan.db.validation.causes.NoRACinstances;
import oracle.osysmodel.validation.BundleUtils;
import oracle.osysmodel.validation.ConfigValidationException;
import oracle.osysmodel.validation.Rule;
import oracle.osysmodel.validation.RuleResult;
import oracle.osysmodel.validation.causes.BaseCause;
import oracle.osysmodel.validation.causes.MissingHome;
import oracle.osysmodel.validation.causes.MissingHost;
import oracle.osysmodel.validation.causes.MissingVersion;
import oracle.osysmodel.validation.rules.BaseRule;

public class CRSRACsValid
extends BaseRule {
    Logger logger = Logger.getLogger(CRSRACsValid.class.getName());

    public CRSRACsValid(SystemInstance config) {
        super(config);
        this.successMessage = " RAC configuration managed by CRS is valid ";
    }

    public RuleResult invoke() throws ConfigValidationException {
        this.logger.log(Level.FINE, "Invoking rule to ensure that if the RAC object exists, it has instances running out of it and the version, home and host details set.");
        ArrayList<BaseCause> nullCauses = new ArrayList<BaseCause>();
        if (this.config.getTop() == null) {
            this.logger.log(Level.FINE, "System Instance top was found to be null. Ensuring if no crs object exists.");
            List crsList = this.config.getTargetsOfType(CRSCluster.class);
            if (crsList == null || crsList.isEmpty()) {
                this.logger.log(Level.FINE, "CRSCluster does not exist.");
                nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"NO_CRS", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            if (crsList.size() != 1) {
                this.logger.log(Level.FINE, "More than one CRS object recognized. Set top to the CRSObject");
                nullCauses.add(new MultipleCRSObject(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"MULTIPLE_CRS_OBJECT", (Object[])new Object[0])));
                return new RuleResult((Rule)this, null, nullCauses);
            }
            this.logger.log(Level.INFO, "Setting the top to the CRSObject");
            this.config.setTop((AbstractBaseTarget)crsList.get(0));
        } else if (!(this.config.getTop() instanceof CRSCluster)) {
            this.logger.log(Level.FINE, "SystemInstance top is not CRSCluster object");
            nullCauses.add(new NoCRS(null, BundleUtils.getMessage(CRSRACsValid.class, (String)"TOP_NOT_CRS", (Object[])new Object[0])));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        CRSCluster crs = (CRSCluster)this.config.getTop();
        ArrayList<CRSCluster> list = new ArrayList<CRSCluster>();
        List racs = crs.getDbRAC();
        if (racs == null || racs.isEmpty()) {
            this.logger.log(Level.FINE, "The CRS cluster has no RAC Databases associated with it.");
            list.add(crs);
            nullCauses.add(new NoRAC(list, BundleUtils.getMessage(CRSRACsValid.class, (String)"NO_RAC", (Object[])new Object[]{BundleUtils.makeStringOutOfList(list)})));
            return new RuleResult((Rule)this, null, nullCauses);
        }
        ArrayList<RACDBInstance> missingVersion = new ArrayList<RACDBInstance>();
        ArrayList<RACDBInstance> missingHome = new ArrayList<RACDBInstance>();
        ArrayList<OracleHome> missingHost = new ArrayList<OracleHome>();
        ArrayList<RACDatabase> noInstances = new ArrayList<RACDatabase>();
        HashMap racVersion = new HashMap();
        for (RACDatabase rac : racs) {
            Object version = null;
            if (rac.getDbInstances() != null && !rac.getDbInstances().isEmpty()) {
                for (RACDBInstance instance : rac.getDbInstances()) {
                    OracleHome home = instance.getRuns_from();
                    if (home == null) {
                        this.logger.log(Level.FINE, "The instance " + instance.getInstanceName() + " doesn't have the runs_from home set.");
                        missingHome.add(instance);
                    } else {
                        this.logger.log(Level.FINE, "The home at " + home.getPath() + " doesn't have the hosts set.");
                        List hosts = home.getHosts();
                        if (hosts == null || hosts.isEmpty()) {
                            missingHost.add(home);
                        }
                    }
                    if (instance.getVersion() != null && instance.getVersion().trim().length() != 0) continue;
                    this.logger.log(Level.FINE, "The instance is missing version information.");
                    missingVersion.add(instance);
                }
                continue;
            }
            this.logger.log(Level.FINE, "The RAC Database has no instances associated with it.");
            noInstances.add(rac);
        }
        ArrayList<Object> failureCauses = new ArrayList<Object>();
        if (!missingVersion.isEmpty()) {
            failureCauses.add(new MissingVersion(missingVersion, BundleUtils.getMessage(CRSRACsValid.class, (String)"MISSING_VERSION", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingVersion)})));
        }
        if (!missingHome.isEmpty()) {
            failureCauses.add(new MissingHome(missingHome, BundleUtils.getMessage(CRSRACsValid.class, (String)"RACINSTANCE_MISSING_HOME", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHome)})));
        }
        if (!missingHost.isEmpty()) {
            failureCauses.add(new MissingHost(missingHost, BundleUtils.getMessage(CRSRACsValid.class, (String)"MISSING_HOST", (Object[])new Object[]{BundleUtils.makeStringOutOfList(missingHost)})));
        }
        if (!noInstances.isEmpty()) {
            failureCauses.add((Object)new NoRACinstances(noInstances, BundleUtils.getMessage(CRSRACsValid.class, (String)"NO_RACINSTANCE", (Object[])new Object[]{BundleUtils.makeStringOutOfList(noInstances)})));
        }
        if (!failureCauses.isEmpty()) {
            return new RuleResult((Rule)this, new Boolean(false), failureCauses);
        }
        return new RuleResult((Rule)this);
    }
}

