/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchConfigAction;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.helpers.PatchHelper;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.configinventory.patch.ActionType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PatchConfigInv;
import oracle.glcm.opatch.common.impl.configinventory.patch.PatchType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PhaseType;
import oracle.glcm.opatch.common.impl.configinventory.patch.PhaseTypeValue;
import oracle.glcm.opatch.common.impl.configinventory.patch.StatusValue;
import oracle.glcm.opatch.common.utils.LocalUtils;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;
import org.xml.sax.SAXException;

public class PatchConfigurationInvDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<PatchConfigInv> pciClass = PatchConfigInv.class;
    private static String pciPackage = pciClass.getPackage().getName();
    private static String pciXsdFile = "patch_config_inventory.xsd";
    private File pciXmlFileFullPath = null;
    private PatchConfigInv invObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private Schema schema = null;

    public PatchConfigurationInvDAO(String domainDir) throws FileNotFoundException, DomainInventoryLoadingException, DomainInventoryUpdatingException {
        this.logger.info("Enter PatchConfigurationInvDAO constructor...");
        File domainDirFile = new File(domainDir);
        if (!domainDirFile.exists() || !domainDirFile.isDirectory()) {
            throw new FileNotFoundException("Domain directory does not exist.");
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)pciPackage);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = pciClass.getResource(pciXsdFile);
            this.schema = sf.newSchema(url);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for domain config inventory", (Throwable)e);
        }
        catch (SAXException e) {
            throw new DomainInventoryLoadingException("Failed to initialize jaxb context for domain config inventory", (Throwable)e);
        }
        String file = PatchHelper.getPatchConfigInventoryFileLocation(domainDir);
        this.pciXmlFileFullPath = new File(file);
        if (!this.pciXmlFileFullPath.exists() || !this.pciXmlFileFullPath.isFile()) {
            this.logger.info("Patch Config Inventory xml file " + file + " does not exist. Create a new object");
            this.invObj = new PatchConfigInv();
            File dciFullDirFile = new File(PatchHelper.getDomainConfigInventoryDirLocation(domainDir));
            if (!(dciFullDirFile.exists() && !dciFullDirFile.isFile() || dciFullDirFile.mkdirs())) {
                throw new FileNotFoundException("Cannot create directory:" + dciFullDirFile.getName());
            }
            try {
                this.pciXmlFileFullPath.createNewFile();
            }
            catch (IOException e) {
                throw new FileNotFoundException("Cannot create file:" + this.pciXmlFileFullPath.getName());
            }
            this.saveToFile(this.invObj);
            this.logger.info("Done done creating PatchConfigInv obj in constructor, and created blank xml file");
        } else {
            try {
                this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
                this.logger.info("Done loading existing xml file in PatchConfigurationInvDAO constructor");
            }
            catch (JAXBException je) {
                throw new DomainInventoryLoadingException("Failed to load or parse the patch_config_inventory.xml", (Throwable)je);
            }
            this.logger.info("Done PatchConfigurationInvDAO constructor");
        }
    }

    private synchronized void saveToFile(PatchConfigInv obj) throws DomainInventoryUpdatingException {
        try {
            this.marshaller.marshal((Object)obj, this.pciXmlFileFullPath);
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Failed to marshall to file patch_config_inventory.xml", (Throwable)e);
        }
    }

    public synchronized void createPatchEntries(List<Patch> listPatch) throws DomainInventoryUpdatingException {
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
            List listPatchEntry = this.invObj.getPatch();
            for (Patch p : listPatch) {
                boolean duplicate = false;
                for (PatchType pt : listPatchEntry) {
                    if (!pt.getUpi().equals(p.getPatchUpi())) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    this.logger.warning("Duplicated patch with patch upi:" + p.getPatchUpi() + " not added to inventory");
                    continue;
                }
                PatchType pt = new PatchType();
                String patchUpi = p.getPatchUpi();
                if (patchUpi == null) {
                    throw new DomainInventoryUpdatingException("Patch: " + p.getPatchId() + "does not have patch UPI");
                }
                pt.setId(p.getPatchId());
                pt.setUpi(patchUpi);
                List listPhase = pt.getPhase();
                listPhase.add(this.createPhase(p, PhaseTypeValue.ONLINE));
                listPhase.add(this.createPhase(p, PhaseTypeValue.OFFLINE));
                listPatchEntry.add(pt);
            }
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Failed to udpate patch config inventory, marshalling failed", (Throwable)e);
        }
        finally {
            try {
                this.marshaller.marshal((Object)this.invObj, this.pciXmlFileFullPath);
            }
            catch (JAXBException e) {
                throw new DomainInventoryUpdatingException("Failed to write out the patch config inventory content");
            }
        }
    }

    private PhaseType createPhase(Patch patch, PhaseTypeValue phase) {
        PhaseType pt = new PhaseType();
        pt.setPatchStatus(StatusValue.INITIAL);
        pt.setType(phase);
        List listAction = pt.getAction();
        List listPatchDeployArtifacts = patch.getPatchDeployArtifacts();
        for (PatchDeployArtifact pda : listPatchDeployArtifacts) {
            List listPca = pda.getPatchConfigAction();
            for (PatchConfigAction pca : listPca) {
                if (!LocalUtils.checkStringExistsInListIgnoreCase(phase.value(), pca.getCategory())) continue;
                ActionType at = new ActionType();
                at.setId(pca.getId());
                at.setDate(LocalUtils.convertDate(new Date()));
                at.setActionStatus(StatusValue.INITIAL);
                listAction.add(at);
            }
        }
        return pt;
    }

    public PatchType getPatchInventoryEntry(String patchId) throws DomainInventoryLoadingException {
        PatchType result = null;
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
            List listPatchEntry = this.invObj.getPatch();
            for (PatchType pt : listPatchEntry) {
                if (!pt.getId().equals(patchId)) continue;
                result = pt;
                break;
            }
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load patch_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load patch_config_inventory.xml file", (Throwable)e);
        }
        return result;
    }

    public List<PatchType> getPatchInventoryEntries() throws DomainInventoryLoadingException {
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load patch_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load patch_config_inventory.xml file", (Throwable)e);
        }
        return this.invObj.getPatch();
    }

    public synchronized PatchType removePatchInventoryEntry(String patchId) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        PatchType result = null;
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
            List listPatchEntry = this.invObj.getPatch();
            for (PatchType pt : listPatchEntry) {
                if (!pt.getId().equals(patchId)) continue;
                result = pt;
                listPatchEntry.remove(pt);
                break;
            }
            if (result == null) {
                this.logger.info("Patch Entry with id: " + patchId + " does not exist in patch config inventory");
            } else {
                this.marshaller.marshal((Object)this.invObj, this.pciXmlFileFullPath);
            }
        }
        catch (JAXBException e) {
            throw new DomainInventoryUpdatingException("Error when trying to load or flush the action_config_inventory.xml", (Throwable)e);
        }
        return result;
    }

    public StatusValue getPatchStatus(String patchId, PhaseTypeValue phase) throws DomainInventoryLoadingException {
        StatusValue result;
        block4: {
            result = null;
            try {
                this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
                List listPatchEntry = this.invObj.getPatch();
                for (PatchType pt : listPatchEntry) {
                    if (!pt.getId().equals(patchId)) continue;
                    List listPhases = pt.getPhase();
                    for (PhaseType phaseT : listPhases) {
                        if (phaseT.getType() != phase) continue;
                        result = phaseT.getPatchStatus();
                        break block4;
                    }
                    break;
                }
            }
            catch (JAXBException e) {
                this.logger.severe("Failed to load patch_config_inventory.xml file");
                throw new DomainInventoryLoadingException("Failed to load patch_config_inventory.xml file", (Throwable)e);
            }
        }
        return result;
    }

    public synchronized void updateActionStatus(String patchId, String actionId, PhaseTypeValue phase, StatusValue actionStatus) throws DomainInventoryLoadingException, DomainInventoryUpdatingException {
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
            List listPatchEntry = this.invObj.getPatch();
            block2: for (PatchType pt : listPatchEntry) {
                if (!pt.getId().equals(patchId)) continue;
                List listPhases = pt.getPhase();
                for (PhaseType phaseT : listPhases) {
                    if (phaseT.getType() != phase) continue;
                    List listAction = phaseT.getAction();
                    if (actionId == null && listAction.isEmpty()) {
                        phaseT.setPatchStatus(actionStatus);
                        break block2;
                    }
                    int tempStatus = 0;
                    for (ActionType action : listAction) {
                        if (action.getId().equals(actionId)) {
                            action.setActionStatus(actionStatus);
                            this.logger.info("Done seting status:" + actionStatus.value() + " for action id:" + action.getId() + " in patch id:" + pt.getId() + " phase:" + phaseT.getType().value());
                        }
                        tempStatus = this.getByteValue(action.getActionStatus()) | tempStatus;
                    }
                    phaseT.setPatchStatus(this.getStatusValue(tempStatus));
                    break block2;
                }
            }
            this.marshaller.marshal((Object)this.invObj, this.pciXmlFileFullPath);
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load patch_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load patch_config_inventory.xml file", (Throwable)e);
        }
    }

    private byte getByteValue(StatusValue sv) {
        if (sv == StatusValue.INITIAL) {
            return 1;
        }
        if (sv == StatusValue.SUCCESS) {
            return 2;
        }
        if (sv == StatusValue.FAILURE) {
            return 4;
        }
        if (sv == StatusValue.NOT_APPLICABLE) {
            return 8;
        }
        if (sv == StatusValue.WARNING) {
            return 16;
        }
        throw new RuntimeException("Error: Status value of actions is not valid:" + sv.toString());
    }

    private StatusValue getStatusValue(int sv) {
        BigInteger bi = BigInteger.valueOf(sv);
        if (bi.testBit(2)) {
            return StatusValue.FAILURE;
        }
        if (bi.testBit(0)) {
            return StatusValue.INITIAL;
        }
        if (bi.testBit(4)) {
            return StatusValue.WARNING;
        }
        if (bi.testBit(1)) {
            return StatusValue.SUCCESS;
        }
        if (bi.testBit(3)) {
            return StatusValue.NOT_APPLICABLE;
        }
        throw new RuntimeException("Integer value of action status is not valid:" + sv);
    }

    public List<Patch> getDelta(List<Patch> listPatch, PhaseTypeValue ptv) throws DomainInventoryLoadingException {
        try {
            this.invObj = (PatchConfigInv)SecureUnmarshaller.unmarshal(this.unmarshaller, this.pciXmlFileFullPath);
            ArrayList<Patch> toBeRemoved = new ArrayList<Patch>();
            ArrayList<Patch> listPatchUpdated = new ArrayList<Patch>();
            if (listPatch == null || listPatch.isEmpty()) {
                return listPatchUpdated;
            }
            listPatchUpdated.addAll(listPatch);
            List listPatchEntry = this.invObj.getPatch();
            for (Patch p : listPatchUpdated) {
                for (PatchType pt : listPatchEntry) {
                    if (!p.getPatchId().equals(pt.getId())) continue;
                    List listPhase = pt.getPhase();
                    for (PhaseType phaseT : listPhase) {
                        if (phaseT.getType() != ptv || phaseT.getPatchStatus() != StatusValue.SUCCESS && phaseT.getPatchStatus() != StatusValue.WARNING && phaseT.getPatchStatus() != StatusValue.NOT_APPLICABLE) continue;
                        toBeRemoved.add(p);
                    }
                }
            }
            if (toBeRemoved.isEmpty() || listPatchUpdated.removeAll(toBeRemoved)) {
                return listPatchUpdated;
            }
            this.logger.warning("Error while removing completed patches from the list patch");
            return listPatchUpdated;
        }
        catch (JAXBException e) {
            this.logger.severe("Failed to load patch_config_inventory.xml file");
            throw new DomainInventoryLoadingException("Failed to load patch_config_inventory.xml file", (Throwable)e);
        }
    }
}

