/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.TempFileHandler;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandlerConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class RestHandlerConfigImpl
implements RestHandlerConfig {
    protected static Map<String, Repository> _repositoryCache = new HashMap<String, Repository>();
    protected File _tempFolder = null;
    protected int _connectionTimeout = Integer.getInteger("RestHandlerConnectionTimeout", 600000);
    protected int _readTimeout = Integer.getInteger("RestHandlerReadTimeout", 600000);
    protected int _retryCount = Integer.getInteger("RestHandlerRetryCount", 3);

    @Override
    public Repository getRepository(String name) throws RestException {
        return _repositoryCache.get(name);
    }

    void addRepository(Repository repository) throws RestException {
        if (repository == null) {
            throw new RestException("The repository specified is null.");
        }
        this.addRepository(repository.getName(), repository);
    }

    void addRepository(String key, Repository repository) throws RestException {
        if (repository == null) {
            throw new RestException("The repository specified was null.");
        }
        if (StringUtil.isNullOrEmpty((String)key, (boolean)true)) {
            throw new RestException("The repository key specified was null or empty.");
        }
        _repositoryCache.put(key, repository);
    }

    @Override
    public abstract String getDefaultRepositoryBaseURL();

    @Override
    public String getDefaultRepositoryURL(String repositoryName) {
        return this.getRepositoryURL(this.getDefaultRepositoryBaseURL(), repositoryName);
    }

    @Override
    public abstract String getRepositoryURL(String var1, String var2);

    @Override
    public synchronized Repository getDefaultCacheRepository() throws RestException {
        Repository cacheRepository = this.getRepository("default-local-cache-repository");
        if (cacheRepository == null) {
            File dir;
            String location = System.getProperty("rest.default.cache.repository");
            if (!StringUtil.isNullOrEmpty((String)location)) {
                dir = new File(location);
                System.out.println("Setting LocalRepository location to " + dir.getAbsolutePath());
            } else {
                String userHome = System.getProperty("user.home");
                if (StringUtil.isNullOrEmpty((String)userHome)) {
                    throw new RestException("Unable to retrieve 'user.home'");
                }
                dir = new File(userHome, ".m2/repository");
            }
            cacheRepository = this.setDefaultCacheRepository(dir);
        }
        return cacheRepository;
    }

    @Override
    public synchronized Repository setDefaultCacheRepository(File dir) throws RestException {
        if (dir == null) {
            throw new IllegalArgumentException("Directory specified is null.");
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new RestException("Please specify a directory : " + dir.getAbsolutePath());
            }
        } else {
            boolean created = dir.mkdirs();
            if (!created) {
                throw new RestException("Unable to create dir : " + dir.getAbsolutePath());
            }
        }
        if (!dir.canRead() || !dir.canWrite()) {
            throw new RestException("Unable to read/write to dir : " + dir.getAbsolutePath());
        }
        Repository repository = RestFactory.getRepository("default-local-cache-repository", RepositoryType.CACHE, dir.getPath(), dir.getPath());
        repository.setLocalRepository(true);
        this.addRepository(repository);
        return repository;
    }

    public File getTempFolder() throws IOException {
        if (this._tempFolder == null) {
            this._tempFolder = TempFileHandler.getTempFolder();
        }
        return this._tempFolder;
    }

    public File getTempFile(String prefix, String suffix) throws IOException {
        File file = File.createTempFile(prefix, suffix, this.getTempFolder());
        file.deleteOnExit();
        return file;
    }

    @Override
    public int getConnectionTimeout() {
        return this._connectionTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this._readTimeout;
    }

    @Override
    public int getRetryCount() {
        return this._retryCount;
    }

    @Override
    public String getGroupIdPath(String group) {
        if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
            return "";
        }
        group = group.trim();
        return group.replace(".", "/");
    }

    @Override
    public String getArtifactId(String artifact) {
        if (StringUtil.isNullOrEmpty((String)artifact, (boolean)true)) {
            return artifact;
        }
        artifact = artifact.trim();
        return artifact.replace(" ", "_");
    }
}

