/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.binary;

import com.oracle.cie.common.util.StringUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.systempatch.SystemPatchData;

public class SessionResults
implements Externalizable {
    private ArrayList<PatchResult> allPatchResults = new ArrayList();
    private ArrayList<OPatchPatchInfo> sortedPatchInfoList = new ArrayList();
    private IAnalysisReport iAnalysisReport = null;
    private boolean nAnalysis = false;
    private boolean analysis = false;
    private boolean rollback = false;
    private boolean registration = false;
    private List<SystemPatchData> rollBackBundlePatchData = new ArrayList<SystemPatchData>();
    private List<SystemPatchData> systemPatchToBeApplied = new ArrayList<SystemPatchData>();

    public SessionResults(boolean analyze, boolean rollback) {
        this.analysis = analyze;
        this.rollback = rollback;
    }

    public SessionResults() {
        this.registration = true;
    }

    public String collectSuccessSummary() {
        StringBuffer summary = new StringBuffer();
        ArrayList<PatchResult> successfulPatches = this.getSuccessfulPatches();
        if (successfulPatches.size() > 0) {
            if (this.registration) {
                summary.append("\n==Following directories were SUCCESSFULLY registered for patching:\n");
            } else {
                summary.append("\n==Following patches were SUCCESSFULLY " + (this.analysis ? "analyzed to be " : "") + (this.rollback ? "rolled back:\n" : "applied:\n"));
            }
            for (PatchResult success : successfulPatches) {
                if (this.registration) {
                    summary.append("\nDirectory: ").append(success.getPatchLocn()).append("\n");
                    continue;
                }
                summary.append("\n").append(success.toStringShort());
            }
        } else {
            summary.append("None of the patches succeeded.\n");
        }
        return summary.toString();
    }

    public String collectFailSummary() {
        StringBuffer summary = new StringBuffer();
        ArrayList<PatchResult> failedPatches = this.getFailedPatches();
        if (failedPatches.size() > 0) {
            if (this.registration) {
                summary.append("\n==Following directories FAILED in registration for patching:\n");
            } else {
                summary.append("\n==Following patches FAILED in " + (this.analysis ? "analysis for " : "") + (this.rollback ? "rollback:\n" : "apply:\n"));
            }
            for (PatchResult failed : failedPatches) {
                if (this.registration) {
                    summary.append("\nDirectory: ").append(failed.getPatchLocn()).append("\n");
                    summary.append("Reason: ").append(failed.getReason()).append("\n");
                    continue;
                }
                summary.append("\n").append(failed.toStringShort());
            }
        } else {
            summary.append("None of the patches failed.\n");
        }
        return summary.toString();
    }

    public String collectSkipSummary() {
        StringBuffer summary = new StringBuffer();
        ArrayList<PatchResult> skippedPatches = this.getSkippedPatches();
        if (skippedPatches.size() > 0) {
            if (this.registration) {
                summary.append("\n==Following directories were SKIPPED because they were not been identified as patches:\n");
            } else {
                summary.append("\n==Following patches were SKIPPED:\n");
            }
            for (PatchResult skipped : skippedPatches) {
                if (this.registration) {
                    summary.append("\nPatch: ").append(skipped.getPatchLocn()).append("\n");
                    continue;
                }
                summary.append("\n").append(skipped.toStringShort());
            }
        } else {
            summary.append("None of the patches were skipped.\n");
        }
        return summary.toString();
    }

    public String collectSessionSummary() {
        StringBuffer summary = new StringBuffer();
        ArrayList<PatchResult> successfulPatches = this.getSuccessfulPatches();
        ArrayList<PatchResult> skippedPatches = this.getSkippedPatches();
        ArrayList<PatchResult> failedPatches = this.getFailedPatches();
        if (failedPatches.size() > 0) {
            summary.append("\n" + this.collectFailSummary());
        }
        if (skippedPatches.size() > 0) {
            summary.append("\n" + this.collectSkipSummary());
        }
        if (successfulPatches.size() > 0) {
            summary.append("\n" + this.collectSuccessSummary());
        }
        return summary.toString();
    }

    private ArrayList<PatchResult> scanAllPatchResults(String status) {
        ArrayList<PatchResult> listOfPR = new ArrayList<PatchResult>();
        for (PatchResult pr : this.allPatchResults) {
            String pr_status = pr.getResult();
            if (!pr_status.equals(status)) continue;
            listOfPR.add(pr);
        }
        return listOfPR;
    }

    protected PatchResult getExistingPR(String patch_locn) {
        for (PatchResult pr : this.allPatchResults) {
            if (!pr.getPatchLocn().equals(patch_locn)) continue;
            return pr;
        }
        return null;
    }

    protected void addPatchResult(PatchResult incoming) {
        PatchResult removable = null;
        for (PatchResult current : this.allPatchResults) {
            if (!current.equals(incoming)) continue;
            removable = current;
            break;
        }
        if (null != removable) {
            this.allPatchResults.remove(removable);
        }
        this.allPatchResults.add(incoming);
    }

    protected void addPatchResults(ArrayList<PatchResult> prList) {
        for (PatchResult pr : prList) {
            this.addPatchResult(pr);
        }
    }

    public ArrayList<PatchResult> getAllResults() {
        return this.allPatchResults;
    }

    public ArrayList<PatchResult> getSuccessfulPatches() {
        return this.scanAllPatchResults("SUCCESSFUL");
    }

    public ArrayList<OPatchPatchInfo> collectSuccessfulPatchList() {
        ArrayList<OPatchPatchInfo> piList = new ArrayList<OPatchPatchInfo>();
        for (PatchResult pr : this.getSuccessfulPatches()) {
            for (OPatchPatchInfo pi : this.getAnalyzedOpatchPatchList()) {
                String piId;
                String prId = pr.getPatchID();
                if (StringUtil.isNullOrEmpty((String)prId)) {
                    String prLocation = pr.getPatchLocn();
                    prLocation = prLocation.replaceAll("/+$", "");
                    prId = prLocation.substring(prLocation.lastIndexOf(File.separator) + 1, prLocation.length());
                }
                if (StringUtil.isNullOrEmpty((String)(piId = pi.getPatchID()))) {
                    String piLocation = pi.getPatchLocation();
                    piLocation = piLocation.replaceAll("/+$", "");
                    piId = piLocation.substring(piLocation.lastIndexOf(File.separator) + 1, piLocation.length());
                    pi.setPatchID(piId);
                }
                if (!prId.equals(piId)) continue;
                piList.add(pi);
            }
        }
        return piList;
    }

    public ArrayList<PatchResult> getSkippedPatches() {
        return this.scanAllPatchResults("SKIPPED");
    }

    public ArrayList<PatchResult> getFailedPatches() {
        return this.scanAllPatchResults("FAILED");
    }

    public ArrayList<String> getSortedListofPatchIDs() {
        ArrayList<String> patchIDList = new ArrayList<String>();
        for (OPatchPatchInfo patchInfo : this.sortedPatchInfoList) {
            patchIDList.add(patchInfo.getPatchID());
        }
        return patchIDList;
    }

    public List<OPatchPatchInfo> getAnalyzedOpatchPatchList() {
        return this.sortedPatchInfoList;
    }

    public List<SystemPatchData> getSystemPatchDataToBeApplied() {
        return this.systemPatchToBeApplied;
    }

    public void setSystemPatchDataToBeApplied(List<SystemPatchData> appliedSystemPatchData) {
        if (appliedSystemPatchData != null && !appliedSystemPatchData.isEmpty()) {
            this.systemPatchToBeApplied.addAll(appliedSystemPatchData);
        }
    }

    protected void setIAnalysisReport(IAnalysisReport report) {
        this.iAnalysisReport = report;
        if (report != null) {
            List orderedList = null;
            orderedList = this.isRollback() ? this.iAnalysisReport.getNRollbackPatches() : this.iAnalysisReport.getNApplyPatches();
            for (OPatchPatch patch : orderedList) {
                this.sortedPatchInfoList.add(new OPatchPatchInfo(patch));
            }
        }
        this.nAnalysis = true;
    }

    public void setSystemPatchDataToBeRollback(List<SystemPatchData> patchDataList) {
        if (patchDataList != null && !patchDataList.isEmpty()) {
            this.rollBackBundlePatchData.addAll(patchDataList);
        }
    }

    public List<SystemPatchData> getSystemPatchDataToBeRollback() {
        return this.rollBackBundlePatchData;
    }

    protected IAnalysisReport getIAnalysisReport() {
        return this.iAnalysisReport;
    }

    protected void setNAnalysis(boolean mode) {
        this.nAnalysis = mode;
    }

    protected boolean isNAnalysis() {
        return this.nAnalysis;
    }

    protected boolean isRollback() {
        return this.rollback;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.nAnalysis);
        out.writeBoolean(this.rollback);
        out.writeBoolean(this.analysis);
        out.writeBoolean(this.registration);
        out.writeObject(this.allPatchResults);
        out.writeObject(this.sortedPatchInfoList);
        out.writeObject(this.rollBackBundlePatchData);
        out.writeObject(this.systemPatchToBeApplied);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nAnalysis = in.readBoolean();
        this.rollback = in.readBoolean();
        this.analysis = in.readBoolean();
        this.registration = in.readBoolean();
        this.allPatchResults = (ArrayList)in.readObject();
        this.sortedPatchInfoList = (ArrayList)in.readObject();
        this.rollBackBundlePatchData = (List)in.readObject();
        this.systemPatchToBeApplied = (List)in.readObject();
    }
}

