/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.patchanalyzer.PatchingConstants;
import oracle.opatchauto.core.patchanalyzer.systempatch.ISystemPatchGenerator;
import oracle.opatchauto.core.patchanalyzer.systempatch.SubpatchModel;
import oracle.opatchauto.core.patchanalyzer.systempatch.SystemPatchBundleXML;
import oracle.opatchauto.core.patchanalyzer.systempatch.engsystempatch.HashComputeFunction;

public class IncludeAutomationXml
extends HashComputeFunction {
    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (SubpatchModel subPatch : bundleXml.getSubpatchList()) {
            if (subPatch.getPatchingTool() != ISystemPatchGenerator.PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + File.separator + subPatchLoc;
            if (OPatchAutoBinaryUtil.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                File compositePatchDir = new File(subPatchAbsLoc);
                if (!compositePatchDir.exists()) continue;
                for (File sp : compositePatchDir.listFiles()) {
                    if (!sp.isDirectory()) continue;
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + PatchingConstants.ACTIONS_XML).getAbsolutePath());
                    metaList.add(new File(sp.getAbsolutePath() + File.separator + PatchingConstants.INVENTORY_XML).getAbsolutePath());
                }
                continue;
            }
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + PatchingConstants.ACTIONS_XML).getAbsolutePath());
            metaList.add(new File(patchLocation, subPatchLoc + File.separator + PatchingConstants.INVENTORY_XML).getAbsolutePath());
        }
        metaList.add(new File(patchLocation, "automation" + File.separator + "apply_automation.xml").getAbsolutePath());
        metaList.add(new File(patchLocation, "automation" + File.separator + "rollback_automation.xml").getAbsolutePath());
        return metaList;
    }

    @Override
    protected String getHashFunction() {
        return "sha1";
    }
}

