/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.nextgen.common.ini;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.nextgen.common.ini.IniFile;
import com.oracle.cie.nextgen.common.ini.IniSection;
import com.oracle.cie.nextgen.common.ini.OraparamIni;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;

public class DefaultOraparamIni
extends OraparamIni {
    private static final Logger _logger = Logger.getLogger(DefaultOraparamIni.class.getName());
    public static final String PARAM_FILE = "oracle.installer.paramFile";
    private static IniFile _defaultIniFile = null;

    protected DefaultOraparamIni(String paramFileLoc) throws IOException {
        super(paramFileLoc);
    }

    private static synchronized IniFile getDefaultIniFile() {
        if (_defaultIniFile == null) {
            String paramFileLoc = DefaultOraparamIni.getDefaultParamFileLoc();
            if (paramFileLoc == null) {
                return null;
            }
            try {
                _defaultIniFile = new DefaultOraparamIni(paramFileLoc).getIniFile();
            }
            catch (IOException ioe) {
                _logger.finer("Caught IOException trying to create default oraparam.ini object: " + ioe.getMessage());
                return null;
            }
        }
        return _defaultIniFile;
    }

    private static String getDefaultParamFileLoc() {
        String paramFileLoc = System.getProperty(PARAM_FILE);
        if (StringUtil.isNullOrEmpty((String)paramFileLoc)) {
            paramFileLoc = null;
        } else {
            Path f = NioHelper.getInstance().getPath(paramFileLoc, new String[0]);
            if (Files.exists(f, new LinkOption[0]) && Files.isRegularFile(f, new LinkOption[0]) && Files.isReadable(f)) {
                paramFileLoc = f.toAbsolutePath().toString();
            } else {
                _logger.finer("Candidate oraparam.ini does not exist or is not a file or is not readable: " + paramFileLoc);
                paramFileLoc = null;
            }
        }
        _logger.finer("Using oraparam.ini: " + paramFileLoc);
        return paramFileLoc;
    }

    public static String getOraparamProfileString(String var, String def) {
        return DefaultOraparamIni.getOraparamProfileString("Oracle", var, def);
    }

    public static String getOraparamProfileString(String section, String var, String def) {
        String val;
        IniSection iniSection;
        String result = def;
        IniFile iniFile = DefaultOraparamIni.getDefaultIniFile();
        if (iniFile != null && (iniSection = iniFile.getSection(section)) != null && !StringUtil.isNullOrEmpty((String)(val = iniSection.getValue(var)))) {
            result = val;
        }
        _logger.finer("getOraparamProfileString: section=" + section + " var=" + var + " def=" + def + " result=" + result);
        return result;
    }

    public static String[] getOraparamProfileStringList(String var, String[] def) {
        return DefaultOraparamIni.getOraparamProfileStringList("Oracle", var, def);
    }

    public static String[] getOraparamProfileStringList(String sectionName, String var, String[] def) {
        String[] result = def;
        try {
            IniFile iniFile = DefaultOraparamIni.getDefaultIniFile();
            if (iniFile != null) {
                result = iniFile.getProfileStringList(sectionName, var, def);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static synchronized void reset() {
        _defaultIniFile = null;
    }

    public static void save(File dest) throws IOException {
        DefaultOraparamIni.save(NioHelper.getInstance().getPath(dest));
    }

    public static void save(Path dest) throws IOException {
        _logger.finer("Saving oraparam.ini to " + dest);
        if (Files.exists(dest, new LinkOption[0])) {
            _logger.fine("File already exists at " + dest + " so save is not performed");
        } else {
            IniFile iniFile = DefaultOraparamIni.getDefaultIniFile();
            if (iniFile != null) {
                iniFile.writeFileTo(dest);
            } else {
                _logger.fine("No oraparam.ini file to save");
            }
        }
    }

    public static boolean alwaysRunConfig() {
        return false;
    }

    public static boolean canIgnoreBuildNumber() {
        return !Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("USE_BUILD_NUMBER", "false"));
    }

    public static boolean createOldStyleRegEntries() {
        return Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("CREATE_OLD_STYLE_REGENTRIES", "false"));
    }

    public static String[] getClusterwareInfo() {
        return DefaultOraparamIni.getOraparamProfileStringList("CLUSTERWARE", null);
    }

    public static String getHttpRetryCount() {
        return DefaultOraparamIni.getOraparamProfileString("HTTP_RETRY_COUNT", "3");
    }

    public static String getHttpRetryInterval() {
        return DefaultOraparamIni.getOraparamProfileString("HTTP_RETRY_INTERVAL", "1000");
    }

    public static String getLogLocation() {
        return DefaultOraparamIni.getLogLocation(null);
    }

    public static String getLogLocation(String defaultLogLocationPropertyValue) {
        String logLocation = DefaultOraparamIni.getOraparamProfileString("LOG_LOCATION", defaultLogLocationPropertyValue);
        if (StringUtil.isNullOrEmpty((String)logLocation)) {
            _logger.fine("Can't determine the value of LOG_LOCATION in oraparam.ini; using CENTRAL_INVENTORY");
            return "CENTRAL_INVENTORY";
        }
        if (logLocation.equals("ORACLE_HOME") || logLocation.equals("CENTRAL_INVENTORY")) {
            return logLocation;
        }
        return "CENTRAL_INVENTORY";
    }

    public static int getShowHostNameValue() {
        int result = 0;
        String val = DefaultOraparamIni.getOraparamProfileString("SHOW_HOSTNAME", "NEVER_SHOW");
        if ("NEVER_SHOW".equalsIgnoreCase(val)) {
            result = 0;
        } else if ("ALWAYS_SHOW".equalsIgnoreCase(val)) {
            result = 1;
        } else if ("CONDITION_SHOW".equalsIgnoreCase(val)) {
            result = 2;
        }
        return result;
    }

    public static boolean isApplTopStage() {
        return false;
    }

    public static boolean isIgnoreCluster() {
        if ("false".equalsIgnoreCase(DefaultOraparamIni.getOraparamProfileString("IGNORECLUSTER", null))) {
            _logger.warning("IGNORECLUSTER=FALSE in oraparam.ini is ignored; always assumed TRUE");
        }
        return true;
    }

    public static boolean isSuppressIgnoreWarnings() {
        return Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("SUPPRESS_IGNORE_WARNINGS", "false"));
    }

    public static boolean isVendorClusterware() {
        return Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("VENDORCLUSTERWARE", "false"));
    }

    public static boolean useOldInstallPrereqs() {
        return Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("USE_OLD_INSTALL_PREREQS", "false"));
    }

    public static boolean usePrereqChecker() {
        return Boolean.parseBoolean(DefaultOraparamIni.getOraparamProfileString("USE_PREREQ_CHECKER", "true"));
    }
}

