/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.JarAction;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchactions.onewaycopyAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OJVMHelper;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class OJVMHelperImpl
implements OJVMHelper {
    @Override
    public boolean isOJVMPatchForPatchApply(String patchDirectory) {
        boolean isOjvmPatch = false;
        Path patchDirectoryPath = WrapperFactory.getNioServiceWrapper().getPath(patchDirectory, new String[0]);
        if (!this.isEmpty(patchDirectory) && Files.isReadable(patchDirectoryPath)) {
            try {
                OPatchPatch[] patchArray;
                for (OPatchPatch patch : patchArray = OPatchPatch.getPatches(patchDirectory)) {
                    PatchObject patchObject = patch.getPo();
                    isOjvmPatch = patchObject.getPatchInventory().isOjvmPatch();
                    if (!isOjvmPatch) continue;
                    return isOjvmPatch;
                }
            }
            catch (OPatchException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
        }
        return isOjvmPatch;
    }

    @Override
    public boolean isOJVMPatchForPatchRollback(String oracleHome, String patchID) {
        boolean isOjvmPatch = false;
        Path oracleHomePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
        if (!this.isEmpty(patchID) && !this.isEmpty(oracleHome) && Files.isReadable(oracleHomePath)) {
            String[] patchIDs = new String[]{patchID};
            StringBuffer patchStorage = new StringBuffer(oracleHome + File.separator + OPatchEnv.getPatchStorageName());
            Path patchStoragePath = WrapperFactory.getNioServiceWrapper().getPath(patchStorage.toString(), new String[0]);
            DirectoryStream.Filter<Path> dirFilter = this.getDirectoriesFilter(patchIDs);
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchStoragePath, dirFilter);
                Iterator<Path> dirStreamItr = dirStream.iterator();
                if (null == dirStreamItr || !dirStreamItr.hasNext()) {
                    OLogger.log((int)OLogger.FINE, (String)("There is no patchID " + patchID + " under patchStorageDir " + patchStoragePath.toAbsolutePath().toString()));
                    return isOjvmPatch;
                }
            }
            catch (IOException e1) {
                OLogger.log((int)OLogger.SEVERE, (String)e1.getMessage());
                return isOjvmPatch;
            }
            try {
                PatchObject[] patchObject;
                String compositeFilePatch = CompositePatchObject.getCompositeFilePathFromOH((String)oracleHome, (String)patchID);
                String[] constituentList = new String[]{compositeFilePatch};
                Path compositeFilePatchPath = WrapperFactory.getNioServiceWrapper().getPath(compositeFilePatch, new String[0]);
                constituentList = Files.exists(compositeFilePatchPath, new LinkOption[0]) ? CompositePatchObject.getConstituentList((String)compositeFilePatch) : new String[]{patchID};
                for (PatchObject po : patchObject = OPatchUtilHelper.getPatchesToRollback((String)oracleHome, (String[])constituentList, (String)"isOJVMPatchForPatchRollback")) {
                    isOjvmPatch = po.getPatchInventory().isOjvmPatch();
                    if (!isOjvmPatch) continue;
                    return isOjvmPatch;
                }
            }
            catch (Exception e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
        }
        return isOjvmPatch;
    }

    @Override
    public List<String> getFileLocationForPatchApply(String patchDirectory, String fileName) {
        ArrayList<String> listOfFilePath = new ArrayList<String>();
        Path patchDirectoryPath = WrapperFactory.getNioServiceWrapper().getPath(patchDirectory, new String[0]);
        if (!this.isEmpty(fileName) && !this.isEmpty(patchDirectory) && Files.isReadable(patchDirectoryPath)) {
            try {
                OPatchPatch[] patchArray = OPatchPatch.getPatches(patchDirectory);
                boolean isCompositePatch = false;
                String patchBaseDirectory = patchDirectory;
                if (patchArray != null && patchArray.length > 1) {
                    isCompositePatch = true;
                }
                for (OPatchPatch patch : patchArray) {
                    PatchObject po = patch.getPo();
                    PatchComponent[] patchComps = po.getPatchComponents();
                    if (isCompositePatch) {
                        patchBaseDirectory = patchDirectory + File.separator + patch.getPatchId();
                    }
                    for (PatchComponent pc : patchComps) {
                        listOfFilePath.addAll(this.locateFileInActions(fileName, patchBaseDirectory, pc, true));
                    }
                }
            }
            catch (OPatchException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
        } else {
            OLogger.log((int)OLogger.WARNING, (String)("Invalid PatchDirectory " + patchDirectory + " / FileName " + fileName));
        }
        return listOfFilePath;
    }

    @Override
    public List<String> getFileLocationForPatchRollback(String oracleHome, String fileName, String patchID) {
        ArrayList<String> listOfFilePath = new ArrayList<String>();
        Path oracleHomePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
        if (!this.isEmpty(patchID) && !this.isEmpty(fileName) && !this.isEmpty(oracleHome) && Files.isReadable(oracleHomePath)) {
            String compositeFilePatch = CompositePatchObject.getCompositeFilePathFromOH((String)oracleHome, (String)patchID);
            String[] constituentList = new String[]{compositeFilePatch};
            Path compositeFilePatchPath = WrapperFactory.getNioServiceWrapper().getPath(compositeFilePatch, new String[0]);
            constituentList = Files.exists(compositeFilePatchPath, new LinkOption[0]) ? CompositePatchObject.getConstituentList((String)compositeFilePatch) : new String[]{patchID};
            PatchObject[] po = null;
            try {
                if (constituentList.length > 0) {
                    po = OPatchUtilHelper.getPatchesToRollback((String)oracleHome, (String[])constituentList, (String)"getFileLocationForPatchRollback");
                }
            }
            catch (FileNotFoundException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
            catch (RuntimeException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
            catch (IOException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
            catch (Exception e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
            if (null == po) {
                return listOfFilePath;
            }
            StringBuffer patchStorage = new StringBuffer(oracleHome + File.separator + OPatchEnv.getPatchStorageName());
            Path patchStoragePath = WrapperFactory.getNioServiceWrapper().getPath(patchStorage.toString(), new String[0]);
            DirectoryStream.Filter<Path> dirFilter = this.getDirectoriesFilter(constituentList);
            try {
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchStoragePath, dirFilter);
                Map<String, List<String>> patchIdDirNameMap = this.mapPatchIDAndPatchDirectory(dirStream, po);
                for (PatchObject po1 : po) {
                    List<String> patchDirnames = patchIdDirNameMap.get(po1.getPatchID());
                    for (String patchDir : patchDirnames) {
                        StringBuffer innerPath = new StringBuffer(patchStorage);
                        PatchComponent[] patchComps = po1.getPatchComponents();
                        innerPath.append(File.separator).append(patchDir).append(File.separator);
                        for (PatchComponent pc : patchComps) {
                            listOfFilePath.addAll(this.locateFileInActions(fileName, innerPath.toString(), pc, false));
                        }
                    }
                }
            }
            catch (IOException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
            }
        }
        return listOfFilePath;
    }

    private boolean isEmpty(String string) {
        return null == string || string.equals("") || string.isEmpty();
    }

    private boolean checkFileMatchesAndExists(String currentFileName, String fileName) {
        Path currentFileNamePath;
        boolean isFileExists = false;
        if (!this.isEmpty(currentFileName) && !this.isEmpty(fileName) && (currentFileNamePath = WrapperFactory.getNioServiceWrapper().getPath(currentFileName, new String[0])).getFileName().toString().equals(fileName)) {
            if (Files.isReadable(currentFileNamePath)) {
                isFileExists = true;
            } else {
                OLogger.log((int)OLogger.FINEST, (String)(currentFileNamePath.getFileName() + " either does not exists or have no read permission."));
            }
        }
        return isFileExists;
    }

    private List<String> locateFileInActions(String fileName, String patchBaseDirectory, PatchComponent pc, boolean isPatchApply) {
        ArrayList<String> listOfFilePath = new ArrayList<String>();
        List actionsList = pc.getOrderedActions();
        actionsList.addAll(pc.getMakeList());
        for (Object pa : actionsList) {
            StringBuffer stringBuf = new StringBuffer(patchBaseDirectory + File.separator + "files" + File.separator);
            String currentFileName = null;
            switch (pa.getClass().getSimpleName()) {
                case "CopyAction": {
                    currentFileName = stringBuf.append(((CopyAction)pa).getFilename()).toString();
                    if (!this.checkFileMatchesAndExists(currentFileName, fileName)) break;
                    listOfFilePath.add(currentFileName);
                    break;
                }
                case "JarAction": {
                    currentFileName = stringBuf.append(((JarAction)pa).getClassName()).toString();
                    if (!this.checkFileMatchesAndExists(currentFileName, fileName)) break;
                    listOfFilePath.add(currentFileName);
                    break;
                }
                case "ArchiveAction": {
                    currentFileName = stringBuf.append(((ArchiveAction)pa).getObjectName()).toString();
                    if (!this.checkFileMatchesAndExists(currentFileName, fileName)) break;
                    listOfFilePath.add(currentFileName);
                    break;
                }
                case "MakeAction": {
                    currentFileName = stringBuf.append(((MakeAction)pa).getChildPath()).append(File.separator).append(((MakeAction)pa).getMakeFile()).toString();
                    if (!this.checkFileMatchesAndExists(currentFileName, fileName)) break;
                    listOfFilePath.add(currentFileName);
                    break;
                }
                case "onewaycopyAction": {
                    if (!isPatchApply || !this.checkFileMatchesAndExists(currentFileName = stringBuf.append(File.separator).append(((onewaycopyAction)pa).getFilename()).toString(), fileName)) break;
                    listOfFilePath.add(currentFileName);
                    break;
                }
            }
        }
        return listOfFilePath;
    }

    private DirectoryStream.Filter<Path> getDirectoriesFilter(final String[] patchIds) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                for (String patchId : patchIds) {
                    if (!entry.getFileName().toString().startsWith(patchId + "_")) continue;
                    return true;
                }
                return false;
            }
        };
        return filter;
    }

    private Map<String, List<String>> mapPatchIDAndPatchDirectory(DirectoryStream<Path> patchDirs, PatchObject[] pos) {
        HashMap<String, List<String>> patchIdDirNameMap = new HashMap<String, List<String>>();
        ArrayList<String> listOfPatchDirs = new ArrayList<String>();
        for (Path dir : patchDirs) {
            listOfPatchDirs.add(dir.getFileName().toString());
        }
        for (PatchObject po : pos) {
            for (String patchDir : listOfPatchDirs) {
                if (!patchDir.startsWith(po.getPatchID())) continue;
                List dirNameList = (List)patchIdDirNameMap.get(po.getPatchID());
                if (null != dirNameList) {
                    dirNameList.add(patchDir);
                    continue;
                }
                ArrayList<String> newdirNameList = new ArrayList<String>();
                newdirNameList.add(patchDir);
                patchIdDirNameMap.put(po.getPatchID(), newdirNameList);
            }
        }
        listOfPatchDirs.clear();
        return patchIdDirNameMap;
    }
}

