/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.opatchlogger.OLogger;

public class OPatchMSIDTimestamp {
    public String getHighestTimestampForAll(String oracleHome, String deployPath) {
        OLogger.printlnOnLog((String)"-------- Get highest timestamp by scanning all the deploy dirs -----------");
        ArrayList<String> listOfEarWar = this.getListofDirs(Paths.get(oracleHome, deployPath));
        HashMap<String, Long> highestOfAllDirs = new HashMap<String, Long>();
        long highestOfAll = 0L;
        OLogger.printlnOnLog((String)("List of Dirs to be processed :" + listOfEarWar));
        for (String s : listOfEarWar) {
            ArrayList<String> timestampDirs = this.getListofDirs(Paths.get(oracleHome, deployPath, s));
            if (timestampDirs.isEmpty()) continue;
            highestOfAllDirs.put(s, this.getHighestTimestamp(timestampDirs));
        }
        OLogger.printlnOnLog((String)("Directory wise highest timestamp value : " + highestOfAllDirs));
        if (!highestOfAllDirs.values().isEmpty()) {
            OLogger.printlnOnLog((String)"***************************************************************************");
            OLogger.printlnOnLog((String)"Highest of all ---------->");
            highestOfAll = (Long)Collections.max(highestOfAllDirs.values());
            OLogger.printlnOnLog((String)String.valueOf(highestOfAll));
        }
        return String.valueOf(highestOfAll);
    }

    public ArrayList<String> getListofDirs(Path rootDir) {
        File f = rootDir.toFile();
        File[] fList = f.listFiles();
        ArrayList<String> listofDirs = new ArrayList<String>();
        for (File file : fList) {
            if (!file.isDirectory()) continue;
            listofDirs.add(file.getName());
        }
        return listofDirs;
    }

    public long getHighestTimestamp(ArrayList<String> timestamps) {
        long highestTimestamp = 0L;
        ArrayList<Long> filteredList = new ArrayList<Long>();
        Pattern p = Pattern.compile("(\\d+)");
        for (String dir : timestamps) {
            String temp = dir.split("\\.")[0];
            Matcher m = p.matcher(temp);
            if (!m.matches()) continue;
            filteredList.add(Long.valueOf(temp));
        }
        if (!filteredList.isEmpty()) {
            highestTimestamp = (Long)Collections.max(filteredList);
        }
        return highestTimestamp;
    }
}

