/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.RHPHelper;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.wrappers.WrapperFactory;

public class RHPHelperImpl
implements RHPHelper {
    @Override
    public boolean isRHPPatchForPatchApply(String patchDirectory) throws OPatchException {
        boolean isRhpPatch = false;
        Path patchDirectoryPath = WrapperFactory.getNioServiceWrapper().getPath(patchDirectory, new String[0]);
        if (!this.isEmpty(patchDirectory) && Files.isReadable(patchDirectoryPath)) {
            try {
                OPatchPatch[] patchArray;
                for (OPatchPatch patch : patchArray = OPatchPatch.getPatches(patchDirectory)) {
                    PatchObject patchObject = patch.getPo();
                    isRhpPatch = patchObject.getPatchInventory().isRhpPatch();
                    if (!isRhpPatch) continue;
                    return isRhpPatch;
                }
            }
            catch (OPatchException e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
                throw e;
            }
        }
        return isRhpPatch;
    }

    @Override
    public boolean isRHPPatchForPatchRollback(String oracleHome, String patchID) throws Exception {
        boolean isRhpPatch = false;
        Path oracleHomePath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
        if (!this.isEmpty(patchID) && !this.isEmpty(oracleHome) && Files.isReadable(oracleHomePath)) {
            String[] patchIDs = new String[]{patchID};
            StringBuffer patchStorage = new StringBuffer(oracleHome + File.separator + OPatchEnv.getPatchStorageName());
            Path patchStoragePath = WrapperFactory.getNioServiceWrapper().getPath(patchStorage.toString(), new String[0]);
            DirectoryStream.Filter<Path> dirFilter = this.getDirectoriesFilter(patchIDs);
            try {
                PatchObject[] patchObject;
                DirectoryStream<Path> dirStream = Files.newDirectoryStream(patchStoragePath, dirFilter);
                Iterator<Path> dirStreamItr = dirStream.iterator();
                if (null == dirStreamItr || !dirStreamItr.hasNext()) {
                    OLogger.log((int)OLogger.FINE, (String)("There is no patchID " + patchID + " under patchStorageDir " + patchStoragePath.toAbsolutePath().toString()));
                    return isRhpPatch;
                }
                String compositeFilePatch = CompositePatchObject.getCompositeFilePathFromOH((String)oracleHome, (String)patchID);
                String[] constituentList = new String[]{compositeFilePatch};
                Path compositeFilePatchPath = WrapperFactory.getNioServiceWrapper().getPath(compositeFilePatch, new String[0]);
                constituentList = Files.exists(compositeFilePatchPath, new LinkOption[0]) ? CompositePatchObject.getConstituentList((String)compositeFilePatch) : new String[]{patchID};
                for (PatchObject po : patchObject = OPatchUtilHelper.getPatchesToRollback((String)oracleHome, (String[])constituentList, (String)"isRHPPatchForPatchRollback")) {
                    isRhpPatch = po.getPatchInventory().isRhpPatch();
                    if (!isRhpPatch) continue;
                    return isRhpPatch;
                }
            }
            catch (Exception e) {
                OLogger.log((int)OLogger.SEVERE, (String)e.getMessage());
                throw e;
            }
        }
        return isRhpPatch;
    }

    private boolean isEmpty(String string) {
        return null == string || string.equals("") || string.isEmpty();
    }

    private DirectoryStream.Filter<Path> getDirectoriesFilter(final String[] patchIds) {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                for (String patchId : patchIds) {
                    if (!entry.getFileName().toString().startsWith(patchId + "_")) continue;
                    return true;
                }
                return false;
            }
        };
        return filter;
    }
}

