/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.helper.util.HelperUtility;
import dbmodel.common.OracleHome;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ClusterInformationLoader;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class SessionData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String sessionID = "";
    private Map<String, ArrayList<OPatchPatchInfo>> analyzedResultsMap = new HashMap<String, ArrayList<OPatchPatchInfo>>();
    private static String customConfigDir = "";
    private String crsHome = "";
    private ClusterInformationLoader.CrsType crsType;
    private String walletLoc = "";
    private char[] walletPwd;
    private static SessionData data;
    private ArrayList<String> runningHosts = null;
    private String[] initiatedHosts = null;
    private ArrayList<String> remoteList = new ArrayList();
    private boolean localCRSStatus;
    private String RHPPatching = "";
    private boolean remoteStateUnknown = false;
    private boolean crsStateValidated = false;

    private SessionData() {
    }

    public static SessionData getInstance() {
        if (data == null) {
            data = new SessionData();
            data.collectCrsInfo();
        }
        return data;
    }

    public static SessionData getSerializedInstance(String sessionID) {
        block5: {
            try {
                String location = SessionData.getSerializedLocation();
                File f = new File(location);
                if (!f.exists()) {
                    return null;
                }
                SessionData oldSession = (SessionData)FileUtility.deserializeDataObj((String)location);
                if (sessionID == null) {
                    data = oldSession;
                    break block5;
                }
                if (oldSession.getSessionID() != null && oldSession.getSessionID().equals(sessionID)) {
                    data = oldSession;
                    break block5;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return data;
    }

    public static void setConfigDir(String dir) {
        if (null != dir) {
            customConfigDir = dir;
        } else {
            try {
                customConfigDir = HelperUtility.detectOraBaseConfig() + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR;
                SessionData.getInstance().saveDataObject();
            }
            catch (OPatchAutoException e) {
                customConfigDir = "";
            }
        }
    }

    public static String getConfigDir() {
        return customConfigDir;
    }

    private static String getSerializedLocation() {
        return customConfigDir + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR + "sessionData_" + OUIDriver.extractHostName((String)OPatchAutoHelper.getOPatchAutoHost());
    }

    public void saveDataObject() {
        String location = SessionData.getSerializedLocation();
        Logger logger = Logger.getLogger(SessionData.class.getName());
        try {
            FileUtility.persistDataObj((String)location, (Object)this, (boolean)true);
            logger.fine("Session ID: " + this.getSessionID());
            logger.fine("Config Dir: " + customConfigDir);
            logger.fine("CRS running on: " + this.getRunningHosts().toString());
            logger.fine("Remote Nodes list: " + this.getRemoteList().toString());
            logger.fine("Hosts with a session already initiated: " + Arrays.asList(this.getInitiatedHosts()).toString());
            logger.fine("Local CRS running: " + this.isLocalCRSUp());
            logger.fine("Validation completed: " + this.isCrsStateValidated());
            logger.fine("RHP Patching session: " + this.isRHPPatching());
        }
        catch (IOException e) {
            logger.warning(e.toString());
            logger.warning("Failed to serialize session data");
        }
    }

    public void cleanup() {
        String location = SessionData.getSerializedLocation();
        File f = new File(location);
        if (f.exists()) {
            f.delete();
        }
        data = null;
    }

    public String getCrsHome() {
        return this.crsHome;
    }

    private void setCrsHome(String crsHome) {
        this.crsHome = crsHome;
        SessionData.getInstance().saveDataObject();
    }

    public ClusterInformationLoader.CrsType getCrsType() {
        return this.crsType;
    }

    private void setCrsType(ClusterInformationLoader.CrsType crsType) {
        this.crsType = crsType;
        SessionData.getInstance().saveDataObject();
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
        SessionData.getInstance().saveDataObject();
    }

    public void addToAnalyzedResultsMap(String home, ArrayList<OPatchPatchInfo> opatchpatchinfo) {
        this.analyzedResultsMap.put(home, opatchpatchinfo);
        Logger logger = Logger.getLogger(SessionData.class.getName());
        logger.finest("analyzed results map size : " + this.analyzedResultsMap.size());
        logger.finest("Target Home: " + home);
        for (OPatchPatchInfo info : opatchpatchinfo) {
            logger.finest("analyzed patch Id: " + info.getPatchID());
            logger.finest("analyzed patch Location: " + info.getPatchLocation());
        }
        SessionData.getInstance().saveDataObject();
    }

    public ArrayList<OPatchPatchInfo> getAnalyzedPatchList(String home) {
        return this.analyzedResultsMap.get(home);
    }

    public void setRunningHosts(ArrayList<String> runningHosts) {
        this.runningHosts = runningHosts;
        SessionData.getInstance().saveDataObject();
    }

    public ArrayList<String> getRunningHosts() {
        if (this.runningHosts == null) {
            this.runningHosts = new ArrayList();
        }
        return this.runningHosts;
    }

    public void setInitiatedHosts(String[] initiatedHosts) {
        this.initiatedHosts = initiatedHosts;
        SessionData.getInstance().saveDataObject();
    }

    public String[] getInitiatedHosts() {
        if (this.initiatedHosts == null) {
            this.initiatedHosts = new String[0];
        }
        return this.initiatedHosts;
    }

    public ArrayList<String> getRemoteList() {
        return this.remoteList;
    }

    public void setRemoteList(ArrayList<String> remoteList) {
        this.remoteList = remoteList;
        SessionData.getInstance().saveDataObject();
    }

    public void setLocalCRSStatus(boolean localCRSStatus) {
        this.localCRSStatus = localCRSStatus;
    }

    public boolean isLocalCRSUp() {
        return this.localCRSStatus;
    }

    public void setRHPPatching(boolean RHPPatching) {
        this.RHPPatching = String.valueOf(RHPPatching);
        SessionData.getInstance().saveDataObject();
    }

    public String isRHPPatching() {
        return this.RHPPatching;
    }

    public void setRemoteStateUnknown(boolean remoteStateUnknown) {
        this.remoteStateUnknown = remoteStateUnknown;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isRemoteStateUnknown() {
        return this.remoteStateUnknown;
    }

    public void setCrsStateValidated(boolean crsStateValidated) {
        this.crsStateValidated = crsStateValidated;
        SessionData.getInstance().saveDataObject();
    }

    public boolean isCrsStateValidated() {
        return this.crsStateValidated;
    }

    public String getWalletLoc() {
        return this.walletLoc;
    }

    public void setWalletLoc(String walletLoc) {
        this.walletLoc = walletLoc;
        SessionData.getInstance().saveDataObject();
    }

    public char[] getWalletPwd() {
        return this.walletPwd;
    }

    public void setWalletPwd(char[] walletPwd) {
        this.walletPwd = walletPwd;
        SessionData.getInstance().saveDataObject();
    }

    private void collectCrsInfo() {
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        List<OracleHome> oracleHomes = configGraph.getTargets(OracleHome.class);
        String crsHome = null;
        for (OracleHome oh : oracleHomes) {
            if (oh.getHomeType().equals("crs")) {
                crsHome = oh.getPath();
                break;
            }
            if (!oh.getHomeType().equals("siha")) continue;
            crsHome = oh.getPath();
            break;
        }
        if (crsHome != null) {
            this.setCrsHome(crsHome);
            this.crsType = ClusterInformationLoader.getInstance().getCRSType();
            this.setCrsType(this.crsType);
        }
    }
}

