/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.idprocessor;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.idprocessor.AnalyzedPatchInfoStore;
import com.oracle.glcm.patch.auto.db.framework.patchtarget.PatchApplicableTarget;
import com.oracle.glcm.patch.auto.db.framework.sdk.patch.PatchPackagesBag;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.patch.CRSApplicabilityTarget;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.patchsdk.PatchPackageException;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class PatchIDProcessor {
    private static final String ANALYZED_PATCHID_DETAILS_XML = ".analyzed_patchid_details.xml";
    private String patchingInfoLoc = null;
    private AnalyzedPatchInfoStore patchInfoStore;
    private final Logger _logger = Logger.getLogger(PatchIDProcessor.class.getName());

    private PatchIDProcessor() {
    }

    public static PatchIDProcessor getInstance() {
        return Loader._handler;
    }

    public synchronized void updateAnalyzedPatchDetails(PatchTarget patchTarget, List<OPatchPatchInfo> patchInfoDetails) {
        PatchApplicableTarget patchApplicableTarget = new PatchApplicableTarget();
        patchApplicableTarget.setHome(patchTarget.getHome().getLocation());
        patchApplicableTarget.setHost(patchTarget.getHost().getHost());
        patchApplicableTarget.setTargetType(patchTarget.getType());
        for (OPatchPatchInfo patchDetails : patchInfoDetails) {
            this._logger.fine("Storing analyzed patch info " + patchDetails.toString() + " for target " + patchTarget.toString());
            this.patchInfoStore.storePatchInformation(patchApplicableTarget, patchDetails);
            this.updatePatchPackage(patchApplicableTarget, patchDetails);
        }
        this.save();
    }

    public void initialize(String sessionID) {
        String summaryFileName = this.getAnalyzedPatchInfoFile();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AnalyzedPatchInfoStore.class});
            Unmarshaller jaxbMarshaller = jaxbContext.createUnmarshaller();
            this.patchInfoStore = (AnalyzedPatchInfoStore)jaxbMarshaller.unmarshal(new File(summaryFileName));
            if (!sessionID.equals(this.patchInfoStore.getSessionID())) {
                this.patchInfoStore.clear();
                if (new File(summaryFileName).exists()) {
                    new File(summaryFileName).delete();
                }
            }
        }
        catch (JAXBException e) {
            this.patchInfoStore = new AnalyzedPatchInfoStore();
        }
        if (!new File(summaryFileName).exists()) {
            String crsOwner = OUIDriver.checkFileOwner((File)new File(PatchPlanner.getInstance().getOPlanEnv().getOracleHome(), "oraInst.loc"));
            DBPatchingUtil.createNewFile(summaryFileName, crsOwner, null);
        }
        this.patchInfoStore.init(sessionID);
    }

    public void updatePatchPackage() {
        if (this.patchInfoStore.size() > 0) {
            Set<PatchApplicableTarget> targetList = this.patchInfoStore.getPatchTargetList();
            for (PatchApplicableTarget target : targetList) {
                CopyOnWriteArrayList<OPatchPatchInfo> applicablePatchLiist = this.patchInfoStore.getListofAppliedPatches(target);
                for (OPatchPatchInfo patchDetails : applicablePatchLiist) {
                    this._logger.fine("Updating analyzed patch info " + patchDetails.toString() + " for target " + target.toString());
                    this.updatePatchPackage(target, patchDetails);
                }
            }
        }
    }

    private void save() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AnalyzedPatchInfoStore.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            String summaryFileName = this.getAnalyzedPatchInfoFile();
            jaxbMarshaller.marshal((Object)this.patchInfoStore, new File(summaryFileName));
            this._logger.fine("Saved file successfully :: " + summaryFileName);
        }
        catch (JAXBException e) {
            this._logger.fine(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public String getAnalyzedPatchInfoFile() {
        if (this.patchingInfoLoc == null) {
            try {
                String baseLoc = OPatchAutoHelper.getOPatchAutoHome();
                this.patchingInfoLoc = baseLoc + DBCommonPatchingConstants.OPATCH_AUTO_DBSESSIONINFO + ANALYZED_PATCHID_DETAILS_XML;
            }
            catch (OPatchAutoException e) {
                this.patchingInfoLoc = File.separator + "tmp" + File.separator + ANALYZED_PATCHID_DETAILS_XML;
            }
        }
        this._logger.finer("Analyzed patch info file " + this.patchingInfoLoc);
        return this.patchingInfoLoc;
    }

    private void updatePatchPackage(PatchApplicableTarget target, OPatchPatchInfo patchInfo) {
        PatchPackagesBag bag = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag();
        try {
            ArrayList<String> applicableTargetList = new ArrayList<String>();
            applicableTargetList.add(this.getTarget(target.getTargetType()));
            bag.updatePatchPackage(patchInfo.getPatchID(), patchInfo, applicableTargetList);
            this._logger.finer("Updated patch package bag for patch ID=" + patchInfo.getPatchID());
        }
        catch (PatchPackageException e) {
            this._logger.severe(e.getLocalizedMessage());
        }
    }

    private String getTarget(String targetType) {
        String applicableTarget = null;
        if (targetType.equals("crs")) {
            applicableTarget = CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.crs.toString();
        } else if (targetType.equals("rac") || targetType.equals("rac-shared") || targetType.equals("rac-nonshared")) {
            applicableTarget = CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.rac.toString();
        } else if (targetType.equals("siha")) {
            applicableTarget = CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.siha.toString();
        } else if (targetType.equals("sidb")) {
            applicableTarget = CRSApplicabilityTarget.OPlanRecognizedCRSApplicabilityTarget.sidb.toString();
        }
        this._logger.finer("Applicable target type=" + applicableTarget);
        return applicableTarget;
    }

    private static class Loader {
        static PatchIDProcessor _handler = new PatchIDProcessor();

        private Loader() {
        }
    }
}

