/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.framework.sdk.readme;

import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.Cmds2Script;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.TextReadmeGenerator;
import com.oracle.glcm.patch.auto.db.framework.sdk.readme.TextTreeGenerator;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.opatch.system.db.automation.jaxb.DeploymentSubType;

public class ReadmeFactory {
    private static ReadmeFactory readMeFactory = null;
    private Logger logger = Logger.getLogger(ReadmeFactory.class.getName());
    private String bundleKey = null;
    private TextReadmeGenerator textReadmeGenerator = null;
    private DefaultMutableTreeNode tree;

    public static ReadmeFactory getInstance() {
        if (readMeFactory == null) {
            readMeFactory = new ReadmeFactory();
        }
        return readMeFactory;
    }

    private void initialize() {
        this.textReadmeGenerator = new TextReadmeGenerator(this);
        try {
            this.textReadmeGenerator.initialize();
            Cmds2Script.initialize();
            this.tree = PatchPlanner.getInstance().getConfigGraph().createTreeTable();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void logExecutionStep(List<ExecutionStep> steps) {
        assert (steps.size() > 0);
        this.classifyPlans();
        try {
            if (this.textReadmeGenerator == null) {
                this.initialize();
            }
            this.textReadmeGenerator.logStepsInReadme(steps);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception while generating text readme", e);
        }
        try {
            Cmds2Script.cmds2ScriptFile(steps);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Could not write commands to script.", e);
        }
    }

    public String getConfigTreeText() {
        if (this.textReadmeGenerator == null) {
            this.initialize();
        }
        return this.textReadmeGenerator.getConfigTextTree();
    }

    public String getBundleMessagePrefix() {
        return this.bundleKey;
    }

    public int getSystemInstanceEntityCount() {
        return TextTreeGenerator.getAllNodeCount(this.tree);
    }

    public DefaultMutableTreeNode getConfigTree() {
        return this.tree;
    }

    public static String getOperationBundlePropertySuffixKey(PatchPlanEnv patchPlanEnv) {
        String op = patchPlanEnv.getProperty("Operation");
        if (op == null) {
            return "";
        }
        if (OPatchAutoCommand.apply.name().equalsIgnoreCase(op)) {
            return "APPLY";
        }
        if (OPatchAutoCommand.rollback.name().equalsIgnoreCase(op)) {
            return "ROLLBACK";
        }
        return "";
    }

    private void classifyPlans() {
        PatchPlanEnv patchPlanEnv = PatchPlanner.getInstance().getOPlanEnv();
        String op = patchPlanEnv.getProperty("Operation");
        String deploymentSubType = patchPlanEnv.getProperty("autoDeploymentSubType".toString());
        if (deploymentSubType.equals(DeploymentSubType.ROLLING_UPGRADE.toString()) && op.equalsIgnoreCase(OPatchAutoCommand.apply.name())) {
            this.bundleKey = "InplaceApplyRollingManual";
        } else if (deploymentSubType.equals(DeploymentSubType.NON_ROLLING_UPGRADE.toString()) && op.equalsIgnoreCase(OPatchAutoCommand.apply.name())) {
            this.bundleKey = "InplaceApplyNonRollingManual";
        } else if (deploymentSubType.equals(DeploymentSubType.ROLLING_UPGRADE.toString()) && op.equalsIgnoreCase(OPatchAutoCommand.rollback.name())) {
            this.bundleKey = "InplaceRollbackRollingManual";
        } else if (deploymentSubType.equals(DeploymentSubType.NON_ROLLING_UPGRADE.toString()) && op.equalsIgnoreCase(OPatchAutoCommand.rollback.name())) {
            this.bundleKey = "InplaceRollbackNonRollingManual";
        }
    }

    public void close() throws Exception {
        if (this.textReadmeGenerator != null) {
            this.textReadmeGenerator.deInitialize();
            this.textReadmeGenerator = null;
            Cmds2Script.deInitalize();
        }
    }
}

