/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.Command;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PDBActions;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.CommandDetailsGenerator;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.lifecycle.ShutdownPhase;
import com.oracle.glcm.patch.auto.lifecycle.StartupPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.HomeImpl;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.PatchingPhase;
import oracle.opatch.system.db.automation.jaxb.PhaseType;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public abstract class DBShutDownStartupAction
extends DBCommonPatchAction {
    protected ConfigGraph configGraph = null;

    public DBShutDownStartupAction(Goal ... goal) {
        super(goal);
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        if (((HomeImpl)patchTarget.getHome()).isGIMRHome()) {
            return false;
        }
        boolean oopPatchingSession = DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        if (oopPatchingSession) {
            boolean oopPreparePatchingSession = DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions());
            if (oopPreparePatchingSession || this.getCurrentGoal().equals(ShutdownPhase.Goal.shutdown)) {
                isActionRequired = false;
            }
            if (isActionRequired) {
                try {
                    isActionRequired = !this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
                }
                catch (OPatchAutoException e) {
                    new PatchActionException((Throwable)e);
                }
            }
        } else if (this.getCurrentGoal().equals(OfflinePhase.Goal.finalize_binary_patching)) {
            isActionRequired = false;
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        PatchActionResult result = new PatchActionResult();
        if (!this.getPatchSession().isRollback()) {
            DBPatchingUtil.enableSRVMTrace("/tmp/liveoutput_" + patchTarget.getHost().getHost() + ".trc");
        }
        result = super.executeSteps(executionSteps, patchTarget);
        return result;
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        this.configGraph = PatchPlanner.getInstance().getConfigGraph();
        return new ArrayList<ExecutionStep>();
    }

    protected List<ExecutionStep> getStopOracleHomeCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String targetHome, String acts_on) throws OPatchAutoException {
        String stop_title_key = "Stop-Home-Title";
        String stop_msg_key = "Stop-Home-Message";
        List<ExecutionStep> steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stop.toString(), targetHome, ServiceStatus.DOWN, acts_on, stop_title_key, stop_msg_key);
        return steps;
    }

    protected List<ExecutionStep> getStartOracleHomeCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String targetHome, String acts_on) throws OPatchAutoException {
        String start_title_key = "Start-Home-Title";
        String start_msg_key = "Start-Home-Message";
        List<ExecutionStep> steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.start.toString(), targetHome, ServiceStatus.UP, acts_on, start_title_key, start_msg_key);
        return steps;
    }

    private List<ExecutionStep> getStopStartOracleHomeCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String commandType, String targetHome, ServiceStatus status, String acts_on, String readMeTitleKey, String readMeMsgKey) throws OPatchAutoException {
        ActionType actionType;
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, commandType);
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        argList.put(CommandDetailsGenerator.ActionTypeParams.SERVICE_STATUS, status);
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_NAME, "oracle.server");
        argList.put(CommandDetailsGenerator.ActionTypeParams.STRIPE_TARGETHOME, targetHome);
        ArrayList<String> dependency_type = new ArrayList<String>();
        dependency_type.add("OracleHome");
        argList.put(CommandDetailsGenerator.ActionTypeParams.DEPENDENCY_TYPE, dependency_type);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, readMeTitleKey);
        argList.put(CommandDetailsGenerator.ActionTypeParams.README_MSG_KEY, readMeMsgKey);
        String option = this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).getValue();
        if (Boolean.parseBoolean(option)) {
            if (argList.get((Object)CommandDetailsGenerator.ActionTypeParams.TYPE).equals(DBCommandActionType.stop.toString())) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StopSIDBOnly.toString());
            } else if (argList.get((Object)CommandDetailsGenerator.ActionTypeParams.TYPE).equals(DBCommandActionType.start.toString())) {
                argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StartSIDBOnly.toString());
            }
            actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        } else {
            actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.LIFECYCLE_ACTION, argList);
        }
        PatchingPhase phase = this.getPatchingPhase();
        Command stopStartOracleHomeCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopStartOracleHomeCommand);
        return steps;
    }

    protected PatchingPhase getPatchingPhase() {
        PatchingPhase phase = null;
        boolean oopSwitchPatchingSession = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        boolean oopSinglePatchingSession = DBPatchingHelper.isSingleOOPPatchingSession(this.getPatchSession().getOptions());
        phase = this.getPatchSession().isRollback() ? (oopSinglePatchingSession || oopSwitchPatchingSession ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.SWITCHBACK, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.ROLLBACK, ServiceStatus.LIMITED)) : (oopSinglePatchingSession || oopSwitchPatchingSession ? CommandDetailsGenerator.generatePatchingPhase(PhaseType.MIGRATE, ServiceStatus.LIMITED) : CommandDetailsGenerator.generatePatchingPhase(PhaseType.APPLY, ServiceStatus.LIMITED));
        return phase;
    }

    protected List<ExecutionStep> getStopStartDBConsoleCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on, StopStartOperation operation) throws OPatchAutoException {
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        if (operation == StopStartOperation.STOP) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StopDbConsole.toString());
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-DbConsole-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-DbConsole-Message");
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StartDbConsole.toString());
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-DbConsole-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Start-DbConsole-Message");
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command stopStartDBConsoleCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, stopStartDBConsoleCommand);
        return steps;
    }

    protected List<ExecutionStep> getSavePDBStateCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
        PDBActions.PDBCOmmandModel savePDBCommandModel = pdbAction.getSavePDBStateCommand(configGraph, patchTarget, acts_on);
        List<ExecutionStep> steps = this.getPDBStateCommand(configGraph, patchTarget, savePDBCommandModel.getActionType(), savePDBCommandModel.getPdbCommand());
        return steps;
    }

    protected List<ExecutionStep> getStartPDBStateCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on) throws OPatchAutoException {
        PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
        PDBActions.PDBCOmmandModel startPDBCommandModel = pdbAction.getStartPDBStateCommand(configGraph, patchTarget, acts_on);
        List<ExecutionStep> steps = this.getPDBStateCommand(configGraph, patchTarget, startPDBCommandModel.getActionType(), startPDBCommandModel.getPdbCommand());
        return steps;
    }

    private List<ExecutionStep> getPDBStateCommand(ConfigGraph configGraph, PatchTarget patchTarget, ActionType actionType, Command pdbStateCommand) throws OPatchAutoException {
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, pdbStateCommand);
        block0: for (ExecutionStep step : steps) {
            boolean isRequired = true;
            for (ExecutionStep.Command command : step.getCommand()) {
                String version = DBPatchingHelper.getDBVersion(step.getActsOnTarget());
                if (!command.getValue().startsWith("echo")) {
                    PDBActions pdbAction = new PDBActions(this.getPatchSession().isRollback());
                    isRequired = pdbAction.isPDBCommandNeedToBeExecuted(this.getPatchSession(), patchTarget, step.getRunsOnOracleHome().getPath(), step.getUser().getValue(), command.getValue(), actionType.getActsOn(), version);
                }
                if (isRequired) continue;
                step.getCommand().clear();
                continue block0;
            }
        }
        return steps;
    }

    protected List<ExecutionStep> getRelocateServicesCommandExecutionSteps(ConfigGraph configGraph, PatchTarget patchTarget, String acts_on, StopStartOperation operation) throws OPatchAutoException {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("Generating steps for RelocateDatabaseServices as part of database " + (Object)((Object)operation) + " operation.");
        }
        HashMap<CommandDetailsGenerator.ActionTypeParams, Object> argList = new HashMap<CommandDetailsGenerator.ActionTypeParams, Object>();
        if (operation == StopStartOperation.STOP) {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.RelocateDatabaseServices.toString());
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Relocate-Services-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Relocate-Services-Message");
        } else {
            argList.put(CommandDetailsGenerator.ActionTypeParams.TYPE, DBCommandActionType.StopRelocatedDatabaseServices.toString());
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-Relocated-Services-Title");
            argList.put(CommandDetailsGenerator.ActionTypeParams.README_TITLE_KEY, "Stop-Relocated-Services-Message");
        }
        argList.put(CommandDetailsGenerator.ActionTypeParams.ACTS_ON, acts_on);
        ActionType actionType = CommandDetailsGenerator.generateActionType(CommandDetailsGenerator.ActionTypes.COMMAND_ACTION, argList);
        PatchingPhase phase = this.getPatchingPhase();
        Command relocateServicesCommand = PatchPlanner.getInstance().getCommandFactory().getCommand(actionType, Strategy.MANUAL, phase);
        List<ExecutionStep> steps = this.getsteps(configGraph, patchTarget, actionType, relocateServicesCommand);
        return steps;
    }

    protected boolean ifServicesNeedsToBeRelocated(PatchTarget patchTarget) {
        return !DBPatchingHelper.isNonRollingMode(this.getPatchSession().getOptions()) && !DBPatchingHelper.isOOPPreparePatchingSession(this.getPatchSession().getOptions());
    }

    protected String listOfDatabasesStopped(String command) {
        StringBuffer buff = new StringBuffer();
        String listOfDBInstanceFile = this.getStatFileName(command);
        try {
            listOfDBInstanceFile = listOfDBInstanceFile.trim();
            FileInputStream fstream = new FileInputStream(listOfDBInstanceFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String strLine = br.readLine();
            if (strLine != null) {
                buff.append(strLine.split("-")[1]);
            }
            while ((strLine = br.readLine()) != null) {
                buff.append("," + strLine.split("-")[1]);
            }
            in.close();
            return buff.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getStatFileName(String commandVal) {
        String statFile = commandVal.substring(commandVal.lastIndexOf("-s") + 2, commandVal.length()).trim();
        int endIndex = statFile.indexOf(" ");
        if (endIndex != -1) {
            statFile = statFile.substring(0, endIndex).trim();
        }
        return statFile;
    }

    protected boolean isGIPatchingRequestedForTwelveDB(String primarypatchVersion, boolean isCRSPatchingSkipped) {
        return DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion) && DBCommandUtils.isGIPatchingRequested() && !isCRSPatchingSkipped;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = this.getLocalizedString("DBShutdownStartupAction." + this.getCurrentGoal().getName() + ".start.message", patchTarget.toReportingString());
                break;
            }
            case failure: {
                statusMsg = this.getLocalizedString("DBShutdownStartupAction." + this.getCurrentGoal().getName() + ".failure.message", patchTarget.toReportingString());
                break;
            }
            case warning: {
                statusMsg = this.getLocalizedString("DBShutdownStartupAction." + this.getCurrentGoal().getName() + ".warning.message", patchTarget.toReportingString());
                break;
            }
            case success: {
                statusMsg = this.getLocalizedString("DBShutdownStartupAction." + this.getCurrentGoal().getName() + ".success.message", patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        if (this.getCurrentGoal().equals(StartupPhase.Goal.startup) || this.getCurrentGoal().equals(ShutdownPhase.Goal.shutdown)) {
            statusMsg = this.addTag(statusMsg);
        }
        return statusMsg;
    }

    public static enum StopStartOperation {
        STARTUP,
        STOP;

    }
}

