/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.action.PatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionExecutorContainer;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionResultData;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.glcm.patch.auto.credential.CredentialManager;
import com.oracle.glcm.patch.auto.db.framework.SessionData;
import com.oracle.glcm.patch.auto.db.framework.idprocessor.PatchIDProcessor;
import com.oracle.glcm.patch.auto.db.framework.patchinfostore.PatchingSessionInfoStore;
import com.oracle.glcm.patch.auto.db.framework.patchtarget.PatchApplicableTarget;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanEnv;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.framework.sdk.util.PatchPlanUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.controller.action.BinaryPatchCommand;
import com.oracle.glcm.patch.auto.db.integration.controller.action.DBCommonPatchAction;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OOPPatchLevelUpdater;
import com.oracle.glcm.patch.auto.db.integration.model.action.BinaryActionResultData;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductSupport;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandParameters;
import com.oracle.glcm.patch.auto.db.product.constant.DBCommonPatchingConstants;
import com.oracle.glcm.patch.auto.db.product.executor.ExecutionResult;
import com.oracle.glcm.patch.auto.db.product.executor.GISystemCall;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionInfoHandler;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.validators.PatchingExecutionModeValidator;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.lifecycle.OfflinePhase;
import com.oracle.glcm.patch.auto.session.MutablePatchSession;
import com.oracle.glcm.patch.auto.session.PatchSession;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.helper.util.HelperUtility;
import dbmodel.patchmodel.GenericPatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.opatchauto.core.binary.OPatchAutoBinaryUtil;
import oracle.opatchauto.core.binary.OPatchPatchInfo;
import oracle.opatchauto.core.binary.PatchResult;
import oracle.opatchauto.core.binary.SessionResults;

public class OPatchAutoBinaryAction
extends DBCommonPatchAction {
    private static final String APPLY_ROLLBACK_SESSION_RESULT_FILE = "APPLY_ROLLBACK_SESSION_RESULT_FILE";
    private static final String ANALYZED_SESSION_RESULT_FILE = "ANALYZED_SESSION_RESULT_FILE";
    private List<String> executionSummary = null;
    private BinaryPatchCommand binaryCommand = null;
    private Map<PatchTarget, String> sessionResultFileList = new ConcurrentHashMap<PatchTarget, String>();
    private Map<PatchTarget, String> analyzedResultFileList = new ConcurrentHashMap<PatchTarget, String>();
    private String homeAttributes = null;
    private boolean oopPatchingSession;

    public OPatchAutoBinaryAction() {
        super(new Goal[]{InitPhase.Goal.init, OfflinePhase.Goal.binary_patching});
        this.binaryCommand = new BinaryPatchCommand();
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        return targetList;
    }

    @Override
    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = super.isActionRequired(patchTarget);
        if (!isActionRequired) {
            return isActionRequired;
        }
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        boolean isRollbackPatchID = DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession());
        String patchInformation = null;
        patchInformation = isRollbackPatchID ? this.getPatchSession().getPatchId() : DBPatchingHelper.getPatchLocation(this.getPatchSession());
        if (DBPatchingHelper.isOOPPatchingSession(options) && this.getPatchSession().isRollback() && StringUtil.isNullOrEmpty((String)patchInformation)) {
            return false;
        }
        if (this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching) && DBPatchingHelper.isOOPPatchingSession(options) && this.getPatchSession().isRollback()) {
            return false;
        }
        boolean isOOPApplySwitch = false;
        try {
            isOOPApplySwitch = options.getOption(DBProductParameterConstants.SWITCH_CLONE_KEY.getValue()).isSwitchEnabled();
        }
        catch (OPatchAutoException e) {
            isOOPApplySwitch = false;
        }
        if (isOOPApplySwitch || DBPatchingHelper.isOOPPatchingSession(options) && patchTarget.getHome().isSharedHome() && !OOPSessionInfoHandler.getInstance().isFirstNode(patchTarget)) {
            isActionRequired = false;
        }
        if (isActionRequired && DBPatchingHelper.skipDeployInitSession(options, this.getPatchSession().getCurrentGoal())) {
            isActionRequired = false;
        }
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    @Override
    protected PatchActionResult executeSteps(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        this.prepareHomeForPatching(patchTarget);
        String type = patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_NONSHARED.getValue()) || patchTarget.getType().equals(DBProductTypes.PRODUCT_TYPE_RAC_SHARED.getValue()) ? DBProductTypes.PRODUCT_TYPE_RAC.getValue() : patchTarget.getType();
        type = type.toUpperCase();
        if (DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions())) {
            return super.executeSteps(executionSteps, patchTarget);
        }
        PatchActionResult patchActionResult = new PatchActionResult();
        int returnCode = 0;
        String errorMsg = "";
        String patchInformation = this.getPatchInformation(executionSteps, patchTarget);
        SessionResults results = null;
        long startTime = System.currentTimeMillis();
        for (ExecutionStep executionStep : executionSteps) {
            List<ExecutionStep.Command> commands = executionStep.getCommand();
            for (ExecutionStep.Command cmd : commands) {
                GISystemCall.ExecReturn ret = this.executeCommand(patchTarget, patchInformation, cmd);
                returnCode = ret.getReturnCode();
                errorMsg = ret.getErrorMessage();
                this._logger.info("Opatchcore binary return code=" + returnCode);
                this._logger.info("Opatchcore binary output=" + ret.getNormalMessage());
                this._logger.info("Opatchcore binary error message=" + errorMsg);
                String sessionFile = this.sessionResultFileList.get(patchTarget);
                results = this.readResult(sessionFile);
                if (this.getPatchSession().isAnalyze()) {
                    patchActionResult = new PatchActionResult(PatchActionStatus.success);
                    continue;
                }
                StringBuilder builder = new StringBuilder();
                if (returnCode == 0) {
                    patchActionResult = new PatchActionResult(PatchActionStatus.success);
                    if (this.analyzedResultFileList == null || this.analyzedResultFileList.isEmpty()) continue;
                    String analyzedResultFile = this.analyzedResultFileList.get(patchTarget);
                    this._logger.fine("Analyze file to be deleted::" + analyzedResultFile);
                    if (StringUtil.isNullOrEmpty((String)analyzedResultFile)) continue;
                    new File(analyzedResultFile).delete();
                    continue;
                }
                patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                builder = results == null ? this.generateErrorSummary(patchTarget, executionStep, cmd.getValue(), ret.getNormalMessage(), ret.getErrorMessage()) : this.generateErrorSummary(patchTarget, executionStep, cmd.getValue(), results.collectFailSummary(), ret.getErrorMessage());
                ArrayList<String> details = new ArrayList<String>();
                details.add(builder.toString());
                patchActionResult.setDetails(details);
                return patchActionResult;
            }
        }
        if (patchActionResult.isSuccess() && results != null && this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            ArrayList patchSuccessList = results.collectSuccessfulPatchList();
            SessionData.getInstance().addToAnalyzedResultsMap(patchTarget.getHome(true).getLocation(), patchSuccessList);
        }
        long endTime = System.currentTimeMillis();
        if (this._logger.isLoggable(Level.FINEST)) {
            long duration = endTime - startTime;
            this._logger.finest("Time taken for execution of steps opatchauto binary step :: " + TimeUnit.MILLISECONDS.toSeconds(duration) + " seconds");
        }
        if (results != null) {
            this._logger.info(results.collectSessionSummary());
            if (returnCode == 0) {
                BinaryActionResultData resultData = new BinaryActionResultData();
                this.fillAdditionalPatchDetails(patchTarget, results, patchInformation, resultData);
                patchActionResult.setResultData((PatchActionResultData)resultData);
            }
        }
        if (results != null || !StringUtil.isNullOrEmpty((String)errorMsg)) {
            this.createSummary(returnCode, results, errorMsg);
        }
        if (this.executionSummary != null && !this.executionSummary.isEmpty()) {
            patchActionResult.setDetails(this.executionSummary);
        }
        return patchActionResult;
    }

    private boolean isCrsOrRacTarget(PatchTarget patchTarget) {
        String type = patchTarget.getProductType().getType();
        return type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
    }

    private GISystemCall.ExecReturn executeCommand(PatchTarget patchTarget, String patchInformation, ExecutionStep.Command cmd) throws OPatchAutoException {
        this.preBinarySteps(patchTarget);
        cmd.setValue(cmd.getValue().replaceAll(DBCommandParameters.TEMP_PATCH_LOC.getValue(), patchInformation));
        String ohOwner = OUIDriver.checkFileOwner((File)new File(patchTarget.getHome().getLocation(), "oraInst.loc"));
        this._logger.info(OPatchAutoHelper.getLocalizedString((String)"StepExecutor.command.info", (Object[])new Object[]{ohOwner, cmd.getValue()}));
        HashMap<String, String> envVarList = new HashMap<String, String>();
        String perlPath = DBPatchingUtil.getPerlExecutablePath();
        if (StringUtil.isNullOrEmpty((String)perlPath)) {
            perlPath = patchTarget.getHome().getLocation() + DBCommonPatchingConstants.PERL_RELATIVE_PATH;
        }
        this._logger.fine("Updating perl path as " + perlPath);
        envVarList.put("OPATCHAUTO_PERL_PATH", perlPath);
        GISystemCall.ExecReturn ret = DBPatchingHelper.process(cmd.getValue(), ohOwner, patchTarget, this.getPatchSession().getCredentialManager(), envVarList);
        return ret;
    }

    private void preBinarySteps(PatchTarget patchTarget) {
        String invPtrLoc;
        PatchPlanEnv env;
        String ctrInvLoc;
        String ouiPatchXmlPath;
        File ouiPatchXml;
        String version;
        String type = patchTarget.getProductType().getType();
        OPatchAutoOptions options = this.getPatchSession().getOptions();
        if (type.equals(DBProductTypes.PRODUCT_TYPE_RAC.getValue()) && !this.getPatchSession().isAnalyze() && !StringUtil.isNullOrEmpty((String)(version = PatchPlanner.getInstance().getPrimaryPatchVersion())) && Integer.parseInt(version.substring(0, 2)) == 19 && (ouiPatchXml = new File(ouiPatchXmlPath = (ctrInvLoc = (env = PatchPlanner.getInstance().getOPlanEnv()).getCentralInvLoc(invPtrLoc = env.getInvPtrLocation())) + File.separator + "ContentsXML" + File.separator + "oui-patch.xml")).exists()) {
            String invLocCommand = "chmod 664 " + ouiPatchXml.getAbsolutePath();
            byte[] pwd = null;
            GISystemCall.ExecReturn ret = null;
            this._logger.fine("Change the permission of the file " + ouiPatchXmlPath + " to 664");
            ret = GISystemCall.process(invLocCommand, "root", pwd);
            if (!ret.isOK()) {
                this._logger.log(Level.WARNING, ret.getErrorMessage());
            }
        }
    }

    private String getPatchInformation(List<ExecutionStep> executionSteps, PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRollbackPatchID = DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession());
        String patchInformation = null;
        patchInformation = isRollbackPatchID ? this.getPatchSession().getPatchId() : DBPatchingHelper.getPatchLocation(this.getPatchSession());
        if (!DBPatchingHelper.isGenerateStepCommand(this.getPatchSession().getOptions())) {
            Home home = patchTarget.getHome(true);
            String patchStorageDirectoryPath = DBPatchingUtil.getPatchStorageDirectoryPath(home.getLocation());
            CredentialManager credentialMgr = this.getPatchSession().getCredentialManager();
            Credential credential = DBPatchingHelper.getOwnerOrCurrentUserCred(patchTarget, credentialMgr);
            DBPatchingHelper.createPatchDirectory(home.getLocation(), patchStorageDirectoryPath, credential, "700");
            String opatchauto_storage = home.getLocation() + File.separator + ".opatchauto_storage";
            DBPatchingHelper.createPatchDirectory(home.getLocation(), opatchauto_storage, credential, "750");
            String opatchautoDB = HelperUtility.detectOraBaseHome((String)home.getLocation()) + DBCommonPatchingConstants.CFGTOOLLOGS + File.separator + "opatchautodb";
            DBPatchingHelper.createPatchDirectory(home.getLocation(), opatchautoDB, credential, "775");
            String opatchauto = HelperUtility.detectOraBaseHome((String)home.getLocation()) + DBCommonPatchingConstants.CFGTOOLLOGS + File.separator + "opatchauto";
            DBPatchingHelper.createPatchDirectory(home.getLocation(), opatchauto, credential, "775");
            String sessioninfo = HelperUtility.detectOraBaseConfig((String)home.getLocation()) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_SESSIONINFO_DIR;
            DBPatchingHelper.createPatchDirectory(home.getLocation(), sessioninfo, credential, "775");
            String dbtmp = HelperUtility.detectOraBaseConfig((String)home.getLocation()) + DBCommonPatchingConstants.OATCHAUTOCFG_DB_DIR + DBCommonPatchingConstants.CONFIG_DBTMP_DIR;
            DBPatchingHelper.createPatchDirectory(home.getLocation(), dbtmp, credential, "775");
            if (!isRollbackPatchID && this.isUpdatedPatchLocationRequired(executionSteps)) {
                patchInformation = this.findUpdatedPatchLocation(executionSteps, patchTarget);
            }
        }
        return patchInformation;
    }

    private void prepareHomeForPatching(PatchTarget target) throws OPatchAutoException {
        boolean issuccessful;
        if (this.getPatchSession().getCurrentGoal().equals(OfflinePhase.Goal.binary_patching) && DBPatchingUtil.isAIXPlatform() && (issuccessful = DBPatchingHelper.unloadAIXfiles(target, this.getPassword(target, System.getProperty("user.name"))))) {
            Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"BinaryAction.slbin.command.success", (Object[])new Object[]{"/usr/sbin/slibclean"}));
        }
    }

    private String getSessionString() {
        String sessionVal = this.getPatchSession().isRollback() ? this.getLocalizedString("rollingback.value", new Object[0]) : this.getLocalizedString("applying.value", new Object[0]);
        return sessionVal;
    }

    private String getCompletedSessionString() {
        String sessionVal = this.getPatchSession().isRollback() ? this.getLocalizedString("rolledback.session.value", new Object[0]) : this.getLocalizedString("applied.session.value", new Object[0]);
        return sessionVal;
    }

    @Override
    protected List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        boolean isRequired;
        ArrayList<ExecutionStep> executionList = new ArrayList();
        if (patchTarget.getHome().isSharedHome() && this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching) && !(isRequired = this.isStepExecutionRequiredForSharedHome(patchTarget))) {
            Reporting.report((String)this.getLocalizedString("BinaryAction.binary.patching.skipped", patchTarget.getProductType().getType()));
            return executionList;
        }
        String sessionResultFile = null;
        if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            sessionResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)1);
        } else {
            sessionResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)0);
            String analyzedResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)1);
            this.analyzedResultFileList.put(patchTarget, analyzedResultFile);
        }
        executionList = this.binaryCommand.generateCommand(patchTarget, this.getCurrentGoal(), this.getPatchSession(), sessionResultFile);
        this.sessionResultFileList.put(patchTarget, sessionResultFile);
        return executionList;
    }

    public boolean isRollbackSupported() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        boolean isAnalyzeSupported = false;
        if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            isAnalyzeSupported = true;
        }
        return isAnalyzeSupported;
    }

    public boolean isLocalParallelExecutionSupported() {
        return true;
    }

    public int getOrderingWeight(Goal goal) {
        if (goal.equals(InitPhase.Goal.init)) {
            return 20;
        }
        return 90;
    }

    @Override
    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                    statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.init.start.message", patchTarget.toReportingString());
                    break;
                }
                statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.binary.start.message", this.getSessionString(), patchTarget.toReportingString());
                break;
            }
            case failure: {
                if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                    statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.init.failure.message", patchTarget.toReportingString());
                    break;
                }
                statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.binary.failure.message", this.getSessionString(), patchTarget.toReportingString());
                break;
            }
            case warning: {
                if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                    statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.init.warning.message", patchTarget.toReportingString());
                    break;
                }
                statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.init.warning.message", this.getCompletedSessionString(), patchTarget.toReportingString());
                break;
            }
            case success: {
                if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                    statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.init.success.message", patchTarget.toReportingString());
                    break;
                }
                statusMsg = this.getLocalizedString("OPatchCoreBinaryAction.binary.success.message", this.getCompletedSessionString(), patchTarget.toReportingString());
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        statusMsg = this.addTag(statusMsg);
        return statusMsg;
    }

    @Override
    public void prepareRemoteActionExecutionHost(RemoteConnectionHandler handler, PatchActionExecutorContainer container) throws RemoteConnectionException, PatchActionException {
        super.prepareRemoteActionExecutionHost(handler, container);
        HashMap<PatchTarget, String> sessionResultFileList = new HashMap<PatchTarget, String>();
        HashMap<PatchTarget, String> analyzedResultFileList = new HashMap<PatchTarget, String>();
        for (PatchTarget patchTarget : container.getPatchTargets()) {
            String sessionResultFile = null;
            if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                sessionResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)1);
            } else {
                sessionResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)0);
                String analyzedResultFile = this.binaryCommand.getSessionFileName(patchTarget, (byte)1);
                analyzedResultFileList.put(patchTarget, analyzedResultFile);
            }
            sessionResultFileList.put(patchTarget, sessionResultFile);
        }
        if (!sessionResultFileList.isEmpty()) {
            container.addPatchActionParameter(APPLY_ROLLBACK_SESSION_RESULT_FILE, sessionResultFileList);
        }
        if (!analyzedResultFileList.isEmpty()) {
            container.addPatchActionParameter(ANALYZED_SESSION_RESULT_FILE, analyzedResultFileList);
        }
        try {
            if (this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled()) {
                container.addPatchActionParameter(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue(), (Object)Boolean.TRUE.toString());
            }
        }
        catch (OPatchAutoException e) {
            throw new PatchActionException((Throwable)e);
        }
    }

    @Override
    public void setupRemoteActionExecutionEnvironment(MutablePatchSession patchSession, PatchActionExecutorContainer container) throws PatchActionException {
        super.setupRemoteActionExecutionEnvironment(patchSession, container);
        this.sessionResultFileList = (Map)container.getPatchActionParameterValue(APPLY_ROLLBACK_SESSION_RESULT_FILE);
        this.analyzedResultFileList = (Map)container.getPatchActionParameterValue(ANALYZED_SESSION_RESULT_FILE);
        String nonRollingVal = (String)container.getPatchActionParameterValue(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue());
        Boolean oopPatching = (Boolean)container.getPatchActionParameterValue(DBProductParameterConstants.OOP_PATCHING_SESSION.getValue());
        boolean bl = this.oopPatchingSession = oopPatching == null ? false : oopPatching;
        if (!StringUtil.isNullOrEmpty((String)nonRollingVal, (boolean)true)) {
            try {
                patchSession.getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).setValue(nonRollingVal);
            }
            catch (OPatchAutoException e) {
                throw new PatchActionException((Throwable)e);
            }
        }
    }

    @Override
    public PatchAction clone() throws CloneNotSupportedException {
        PatchAction patchAction = super.clone();
        ((OPatchAutoBinaryAction)patchAction).sessionResultFileList = this.sessionResultFileList;
        ((OPatchAutoBinaryAction)patchAction).analyzedResultFileList = this.analyzedResultFileList;
        ((OPatchAutoBinaryAction)patchAction).oopPatchingSession = this.oopPatchingSession;
        return patchAction;
    }

    @Override
    public void postExecute(PatchTarget patchTarget, PatchActionResult patchActionResult) throws OPatchAutoException {
        super.postExecute(patchTarget, patchActionResult);
        if (patchActionResult.isFailure()) {
            return;
        }
        if (this.getPatchSession().getPatchTracking() != null) {
            BinaryActionResultData resultData = (BinaryActionResultData)patchActionResult.getTypedResultData(BinaryActionResultData.class);
            if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                Boolean isSkipped = Boolean.FALSE;
                if (this.isPatchTargetToBeSkipped(resultData, patchTarget)) {
                    isSkipped = Boolean.TRUE;
                }
                this._logger.info("isSkipped: " + isSkipped);
                PatchingSessionInfoStore.getInstance().updatePatchTargetStatus(patchTarget, isSkipped);
            }
            this.retrieveAdditionalInfo(patchTarget, resultData);
            if (this.isPrintSummary(patchTarget)) {
                this.retrieveSummaryDetails(patchTarget, patchActionResult);
            }
        }
    }

    private boolean isPatchTargetToBeSkipped(BinaryActionResultData resultData, PatchTarget patchTarget) {
        boolean isPatchTargetSkipped = false;
        if (resultData != null && (resultData.getSuccessfulPatchList() == null || resultData.getSuccessfulPatchList().isEmpty()) && !patchTarget.getHome().isSharedHome()) {
            isPatchTargetSkipped = true;
        }
        return isPatchTargetSkipped;
    }

    private void retrieveSummaryDetails(PatchTarget patchTarget, PatchActionResult patchActionResult) {
        List detailsList = patchActionResult.getDetailsList();
        if (detailsList == null || detailsList.isEmpty()) {
            return;
        }
        DBPatchingSummaryCreator summaryCreator = ((DBProductSupport)this.getPatchSession().getProductSupportManager().getProductSupport("db")).getDBPatchingSummaryCreator(this.getPatchSession().getCommand());
        StringBuilder summary = new StringBuilder();
        String statusID = (String)detailsList.get(0);
        int status = 0;
        if (statusID.equals(ExecutionResult.ExecutionStatus.FAILURE.toString())) {
            status = 1;
        }
        detailsList.remove(statusID);
        for (String tmp : patchActionResult.getDetailsList()) {
            summary.append(tmp);
        }
        if (this.getPatchSession().isAnalyze()) {
            summaryCreator.storePatchingSummary(status, SummaryID.patching_analyze, patchTarget, summary.toString());
        } else {
            summaryCreator.storePatchingSummary(status, SummaryID.binary_patching, patchTarget, summary.toString());
        }
    }

    private void retrieveAdditionalInfo(PatchTarget patchTarget, BinaryActionResultData resultData) throws OPatchAutoException {
        if (resultData != null) {
            if (this.getPatchSession().isRollback() && DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession()) && this.getCurrentGoal().equals(InitPhase.Goal.init)) {
                this.retrieveRollbackPatchIDDetails(patchTarget, resultData.getPatchInfoList());
            }
            if (this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching)) {
                this.retrieveSuccessfulPatchList(patchTarget, resultData);
            }
        }
    }

    private void retrieveRollbackPatchIDDetails(PatchTarget patchTarget, List<OPatchPatchInfo> patchInfoList) throws OPatchAutoException {
        if (patchInfoList != null && patchInfoList.size() > 0) {
            PatchIDProcessor.getInstance().updateAnalyzedPatchDetails(patchTarget, patchInfoList);
        }
    }

    private List<ValidationResult> validatePatchExecutionMode(List<OPatchPatchInfo> patchInfoList) throws OPatchAutoException {
        List<ValidationResult> validationResultList = new ArrayList<ValidationResult>();
        if (patchInfoList != null && !patchInfoList.isEmpty()) {
            PatchingExecutionModeValidator executionModeValidator = new PatchingExecutionModeValidator();
            ValidationParam param = new ValidationParam();
            param.set(ValidationParamKey.ANALYZED_PATCHINFO_LIST.ordinal(), patchInfoList);
            param.set(ValidationParamKey.NONROLLING_OPTION.ordinal(), this.getPatchSession().getProductSupportManager().getOptions().getOption(DBProductParameterConstants.NONROLLING_MODE_KEY.getValue()).isSwitchEnabled());
            MultipleValidationResult resultList = executionModeValidator.validate(param);
            validationResultList = resultList.getValidationResultList();
        }
        return validationResultList;
    }

    private void retrieveSuccessfulPatchList(PatchTarget patchTarget, BinaryActionResultData resultData) throws OPatchAutoException {
        List<String> successfulPatchList = resultData.getSuccessfulPatchList();
        if (successfulPatchList != null && successfulPatchList.size() > 0) {
            PatchApplicableTarget target = new PatchApplicableTarget();
            target.setHost(patchTarget.getHost().getHost());
            target.setHome(patchTarget.getHome().getLocation());
            target.setTargetType(patchTarget.getType());
            PatchingSessionInfoStore patchInfoStore = PatchingSessionInfoStore.getInstance();
            ArrayList<String> patchListToStore = new ArrayList<String>();
            boolean isRollbackUsingID = DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession());
            List<GenericPatch> genericPatches = PatchPlanner.getInstance().getOPlanEnv().getPatchesBag().getAllPatches();
            for (String patch : successfulPatchList) {
                this._logger.finest("Applied Patch: " + patch);
                if (isRollbackUsingID) {
                    patchListToStore.add(patch);
                    continue;
                }
                patch = patch.replaceAll(DBCommandParameters.TEMP_PATCH_LOC.getValue(), PatchPlanUtils.removeFileSeperatorAtEnd(patchInfoStore.getPatchLocation()));
                for (GenericPatch subPatch : genericPatches) {
                    this._logger.finest("subPatch: " + subPatch.getPatchLocation());
                    if (!subPatch.getPatchLocation().equals(patch)) continue;
                    patchListToStore.add(subPatch.getPatchID());
                }
            }
            if (DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions()) && !this.getPatchSession().isRollback()) {
                OOPPatchLevelUpdater oopPatchLevelUpdater = new OOPPatchLevelUpdater();
                oopPatchLevelUpdater.persistPatchInformation(this.getPatchSession(), patchTarget, resultData.getPatchesInventory());
            }
        }
    }

    private SessionResults readResult(String sessionResultFile) {
        this._logger.info("Reading session result from " + sessionResultFile);
        SessionResults results = null;
        try {
            FileInputStream inputStream = new FileInputStream(sessionResultFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            results = new SessionResults();
            results.readExternal((ObjectInput)objectInputStream);
            objectInputStream.close();
            inputStream.close();
            this.deleteSesionFile(sessionResultFile);
        }
        catch (FileNotFoundException e) {
            this._logger.warning(e.getMessage());
        }
        catch (IOException e) {
            this._logger.warning(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this._logger.warning(e.getMessage());
        }
        return results;
    }

    private void deleteSesionFile(String sessionFilePath) {
        if (this.getPatchSession().isAnalyze()) {
            File sessionFile = new File(sessionFilePath);
            sessionFile.delete();
        } else if (this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching)) {
            File sessionFile = new File(sessionFilePath);
            sessionFile.delete();
        }
    }

    private void createSummary(int returnCode, SessionResults results, String errorMsg) {
        boolean createSummary = this.isCreateSummary();
        if (createSummary) {
            if (this.executionSummary == null) {
                this.executionSummary = new ArrayList<String>();
            }
            if (returnCode == 0) {
                this.executionSummary.add(ExecutionResult.ExecutionStatus.SUCCESS.toString());
                this.executionSummary.add(results.collectSessionSummary());
            } else {
                this.executionSummary.add(ExecutionResult.ExecutionStatus.FAILURE.toString());
                if (results == null) {
                    this.executionSummary.add(errorMsg);
                } else if (this.getPatchSession().isAnalyze()) {
                    this.executionSummary.add(results.collectSessionSummary());
                } else {
                    this.executionSummary.add(results.collectFailSummary());
                }
            }
        }
    }

    private boolean isCreateSummary() {
        boolean createSummary = false;
        if (this.getPatchSession().isAnalyze()) {
            createSummary = true;
        } else if (this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching) || this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            createSummary = true;
        }
        return createSummary;
    }

    private boolean isPrintSummary(PatchTarget patchTarget) {
        boolean createSummary = false;
        if (this.getPatchSession().isAnalyze()) {
            createSummary = true;
        } else if (this.getCurrentGoal().equals(OfflinePhase.Goal.binary_patching) || this.getCurrentGoal().equals(InitPhase.Goal.init) && PatchingSessionInfoStore.getInstance().skipPatchTarget(patchTarget)) {
            createSummary = true;
        }
        return createSummary;
    }

    private void fillAdditionalPatchDetails(PatchTarget patchTarget, SessionResults sessionResult, String patchInformation, BinaryActionResultData resultData) throws OPatchAutoException {
        if (this.getCurrentGoal().equals(InitPhase.Goal.init)) {
            this.fillAnalyzedPatchInfoDetails(sessionResult, resultData);
        }
        this.fillSuccessfulPatchDetails(sessionResult, patchInformation, resultData);
        boolean bl = this.oopPatchingSession = this.getPatchSession().isActionSession() ? this.oopPatchingSession : DBPatchingHelper.isOOPPatchingSession(this.getPatchSession().getOptions());
        if (this.oopPatchingSession && !this.getPatchSession().isRollback()) {
            OOPPatchLevelUpdater oopPatchLevelUpdater = new OOPPatchLevelUpdater();
            List<OPatchPatchInfo> patchInfoList = oopPatchLevelUpdater.getPatchList(patchTarget);
            resultData.setPatchesInventory(patchInfoList);
        }
    }

    private void fillAnalyzedPatchInfoDetails(SessionResults sessionResult, BinaryActionResultData resultData) {
        List patchList = sessionResult.getAnalyzedOpatchPatchList();
        if (patchList != null && patchList.size() > 0) {
            resultData.setPatchInfoList(patchList);
        }
    }

    private void fillSuccessfulPatchDetails(SessionResults results, String patchLoc, BinaryActionResultData resultData) {
        ArrayList patchResultList = results.getSuccessfulPatches();
        if (patchResultList != null && patchResultList.size() > 0) {
            this._logger.finest("Patch Location:" + patchLoc);
            boolean isPatchIDBasedRollback = DBPatchingHelper.isRollbackUsingPatchId(this.getPatchSession());
            ArrayList<String> successfulPatches = new ArrayList<String>();
            for (PatchResult result : patchResultList) {
                if (isPatchIDBasedRollback) {
                    successfulPatches.add(result.getPatchID());
                    continue;
                }
                String tempPatchLoc = result.getPatchLocn();
                this._logger.finest("Applied patch location:" + tempPatchLoc);
                tempPatchLoc = tempPatchLoc.replaceAll(PatchPlanUtils.removeFileSeperatorAtEnd(patchLoc), DBCommandParameters.TEMP_PATCH_LOC.getValue());
                successfulPatches.add(tempPatchLoc);
            }
            if (successfulPatches.size() > 0) {
                resultData.setSuccessfulPatchList(successfulPatches);
            }
        }
    }

    @Override
    protected void preOperation(PatchTarget patchTarget) throws OPatchAutoException {
        PatchSession patchSession = this.getPatchSession();
        if (this.ifUpdateHome(patchTarget.getType(), patchSession.isAnalyze())) {
            String home = patchTarget.getHome().getLocation();
            File sourceFile = new File(home + File.separator + "oraInst.loc");
            File homeLocation = new File(patchTarget.getHome().getLocation());
            String homeOwner = OUIDriver.checkFileOwner((File)homeLocation);
            String homeGroup = OUIDriver.checkFileGroup((File)homeLocation);
            String sourceOwner = OUIDriver.checkFileOwner((File)sourceFile);
            String sourceGroup = OUIDriver.checkFileGroup((File)sourceFile);
            if (!(StringUtil.isNullOrEmpty((String)homeOwner) || StringUtil.isNullOrEmpty((String)homeGroup) || StringUtil.isNullOrEmpty((String)sourceOwner) || StringUtil.isNullOrEmpty((String)sourceGroup))) {
                this.homeAttributes = homeOwner + ":" + homeGroup;
                String changeOwnerCommand = "chown " + sourceOwner + ":" + sourceGroup + " " + home;
                this._logger.fine("Cached home attribute " + this.homeAttributes);
                GISystemCall.ExecReturn ret = DBPatchingHelper.process(changeOwnerCommand, "root", patchTarget, patchSession.getCredentialManager(), null);
                if (!ret.isOK()) {
                    throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72155), (Object[])new Object[]{home}), new Object[0]);
                }
            }
        }
    }

    @Override
    protected void postOperation(PatchTarget patchTarget) throws OPatchAutoException {
        PatchSession patchSession = this.getPatchSession();
        if (this.ifUpdateHome(patchTarget.getType(), patchSession.isAnalyze()) && null != this.homeAttributes) {
            String home = patchTarget.getHome().getLocation();
            String changeOwnerCommand = "chown " + this.homeAttributes + " " + home;
            this._logger.fine("Executing postOperation command " + changeOwnerCommand);
            GISystemCall.ExecReturn ret = DBPatchingHelper.process(changeOwnerCommand, "root", patchTarget, patchSession.getCredentialManager(), null);
            if (!ret.isOK()) {
                throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72155), (Object[])new Object[]{home}), new Object[0]);
            }
        }
    }

    private boolean ifUpdateHome(String type, boolean isAnalyze) {
        return OPatchAutoBinaryUtil.isCASEnabled() && this.getCurrentGoal().equals(InitPhase.Goal.init) && !isAnalyze && (type.equals(DBProductTypes.PRODUCT_TYPE_CRS.getValue()) || type.equals(DBProductTypes.PRODUCT_TYPE_SIHA.getValue()));
    }
}

