/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.action.CommonPatchAction;
import com.oracle.glcm.patch.auto.action.PatchActionException;
import com.oracle.glcm.patch.auto.action.PatchActionResult;
import com.oracle.glcm.patch.auto.action.PatchActionStatus;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.InitPhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SwitchAnalyzeAction
extends CommonPatchAction {
    public SwitchAnalyzeAction() {
        super(new Goal[]{InitPhase.Goal.init});
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIHA.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_CRS.getValue());
        targetList.add(DBProductTypes.PRODUCT_TYPE_RAC.getValue());
        return targetList;
    }

    public boolean isRemoteExecutionHandled(PatchTarget patchTarget) throws OPatchAutoException {
        return true;
    }

    public boolean isActionRequired(PatchTarget patchTarget) throws PatchActionException {
        boolean isActionRequired = DBPatchingHelper.isOOPSwitchPatchingSession(this.getPatchSession().getOptions());
        return isActionRequired;
    }

    public boolean isActionRequiredLocalOnly() {
        return true;
    }

    public boolean isAnalyzeSupported() {
        return true;
    }

    public boolean isRemoteParallelExecutionSupported() {
        return false;
    }

    public PatchActionResult execute(PatchTarget patchTarget) {
        PatchActionResult patchActionResult = new PatchActionResult();
        try {
            boolean isExist = this.isCloneHomeExist(patchTarget);
            if (!isExist) {
                patchActionResult = new PatchActionResult(PatchActionStatus.failure);
                ArrayList<String> details = new ArrayList<String>();
                details.add(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72021), (Object[])new Object[0]));
                patchActionResult.setDetails(details);
            }
        }
        catch (OPatchAutoException e) {
            patchActionResult = new PatchActionResult((Throwable)e);
        }
        return patchActionResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCloneHomeExist(PatchTarget target) throws OPatchAutoException {
        boolean isExist = false;
        String cloneHomeLoc = null;
        Host host = target.getHost();
        if (target.getHomeClone() == null) throw new OPatchAutoException(Integer.toString(72021), new Object[0]);
        cloneHomeLoc = target.getHomeClone().getLocation();
        RemoteConnectionHandler connectionHandler = null;
        if (host.isRemote()) {
            try {
                connectionHandler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)host);
                connectionHandler.connect();
                if (!connectionHandler.exists(cloneHomeLoc)) return isExist;
                if (!connectionHandler.isDirectory(cloneHomeLoc)) return isExist;
                isExist = true;
                return isExist;
            }
            catch (RemoteConnectionException e) {
                throw new OPatchAutoException((Throwable)e);
            }
            finally {
                if (connectionHandler != null && connectionHandler.isConnected()) {
                    connectionHandler.close();
                }
            }
        } else {
            File clonePath = FileUtils.getFile((String)cloneHomeLoc);
            if (!clonePath.exists()) return false;
            if (!clonePath.isDirectory()) return false;
            return true;
        }
    }

    public String getStatusMessage(PatchTarget patchTarget, PatchActionStatus status) {
        String statusMsg = null;
        switch (status) {
            case incomplete: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"SwitchAnalyzeAction.start.message", (Object[])new Object[]{patchTarget.toReportingString()});
                break;
            }
            case success: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"SwitchAnalyzeAction.success.message", (Object[])new Object[]{patchTarget.toReportingString()});
                break;
            }
            case failure: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"SwitchAnalyzeAction.failure.message", (Object[])new Object[]{patchTarget.toReportingString()});
                break;
            }
            default: {
                statusMsg = super.getStatusMessage(patchTarget, status);
            }
        }
        return statusMsg;
    }
}

