/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.controller.action.siha;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.db.framework.sdk.exec.api.ExecutionStep;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.OnlineAction;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductParameterConstants;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.DBProductTypes;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import com.oracle.glcm.patch.auto.lifecycle.Goal;
import com.oracle.glcm.patch.auto.lifecycle.OnlinePhase;
import com.oracle.glcm.patch.auto.session.PatchTarget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.opatch.system.db.automation.jaxb.ServiceStatus;

public class SIDBOnlineAction
extends OnlineAction {
    public SIDBOnlineAction() {
        super((Goal)OnlinePhase.Goal.product_patching);
    }

    @Override
    public List<ExecutionStep> generateSteps(PatchTarget patchTarget) throws OPatchAutoException {
        ArrayList<ExecutionStep> generatedSteps = new ArrayList<ExecutionStep>();
        ConfigGraph configGraph = PatchPlanner.getInstance().getConfigGraph();
        String primarypatchVersion = PatchPlanner.getInstance().getPrimaryPatchVersion();
        boolean isTwelveVersion = DBPatchingUtil.isDBVersionTweleveOrLater(primarypatchVersion);
        List<ExecutionStep> steps = null;
        if (isTwelveVersion) {
            steps = this.getStartRedoApplyCommandExecutionSteps(configGraph, patchTarget, null, "SIDatabase");
            generatedSteps.addAll(steps);
        }
        boolean actsOnClone = patchTarget.isUsingHomeClone();
        if (isTwelveVersion) {
            List<ExecutionStep> tmpSteps;
            boolean isSQLPatchInUpgradeMode = DBCommandUtils.isSQLPatchUpgradeMode();
            boolean isSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB.getValue()).isSwitchEnabled();
            Boolean isShardSidbOnlyPatching = this.getPatchSession().getOptions().getOption(DBProductParameterConstants.SIDB_ONLY.getValue()).isSwitchEnabled();
            if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(tmpSteps = this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchStartupUpgradeMode.toString(), "SIDatabase", "SQL-Startup-Upgrade-Mode-Step-Title", actsOnClone))) {
                steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.stop.toString(), "sidb", ServiceStatus.DOWN, "OracleHome", "Stop-Home-Title", "Stop-Home-Message");
                generatedSteps.addAll(steps);
                generatedSteps.addAll(tmpSteps);
                steps = this.getUpgradePDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                generatedSteps.addAll(steps);
            }
            steps = this.getPatchSession().isRollback() ? this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchRollback.toString(), "SIDatabase", actsOnClone) : this.getSQLpatchCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.SqlPatchApply.toString(), "SIDatabase", actsOnClone);
            generatedSteps.addAll(steps);
            if (isSQLPatchInUpgradeMode && !isSidbOnlyPatching && !isShardSidbOnlyPatching.booleanValue() && this.isSQLUpgrdeModeCommandRequired(steps)) {
                steps = this.getStopStartOracleHomeCommandExecutionSteps(configGraph, patchTarget, DBCommandActionType.start.toString(), "sidb", ServiceStatus.UP, "OracleHome", "Start-Home-Title", "Start-Home-Message");
                generatedSteps.addAll(steps);
                steps = this.getStartPDBStateCommandExecutionSteps(configGraph, patchTarget, "SIDatabase");
                generatedSteps.addAll(steps);
            }
        }
        return generatedSteps;
    }

    public Set<String> getSupportedProductTypes() {
        HashSet<String> targetList = new HashSet<String>();
        targetList.add(DBProductTypes.PRODUCT_TYPE_SIDB.getValue());
        return targetList;
    }
}

