/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.sdb;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.db.framework.sdk.patchplanner.PatchPlanner;
import com.oracle.glcm.patch.auto.db.integration.controller.action.PatchActionUtil;
import com.oracle.glcm.patch.auto.db.product.summary.DBPatchingSummaryCreator;
import com.oracle.glcm.patch.auto.db.product.summary.SummaryID;
import com.oracle.glcm.patch.auto.db.utils.PrintHelp;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.db_crs.DataGuard;
import dbmodel.db_crs.RACDatabase;
import dbmodel.db_crs.SIDatabase;
import dbmodel.db_crs.ShardGroup;
import dbmodel.db_crs.ShardProperty;
import dbmodel.db_crs.ShardSpace;
import java.util.ArrayList;
import java.util.List;

public class SDBSummaryOrganizer {
    public void storeSDBSummary(OPatchAutoOptions options, OPatchAutoCommand command, DBPatchingSummaryCreator _summaryCreator) throws OPatchAutoException {
        List<String> summaryList = this.getConfigContent(options, command);
        _summaryCreator.storeConfigSummary(0, SummaryID.sdb_patching, summaryList);
    }

    public void displayConfigSummary(OPatchAutoOptions options, OPatchAutoCommand command) throws OPatchAutoException {
        List<String> summaryList = this.getConfigContent(options, command);
        String args = "";
        for (String summary : summaryList) {
            args = args + summary;
            args = args + "\n";
        }
        Reporting.report((String)args);
    }

    private List<String> getConfigContent(OPatchAutoOptions options, OPatchAutoCommand command) throws OPatchAutoException {
        ArrayList<String> summaryList;
        block14: {
            List<String> allSDBOptions = PrintHelp.getAllSDBOptions(command.name());
            summaryList = new ArrayList<String>();
            summaryList.add("\nOptions used in the current patching session:");
            summaryList.add("\toperation : " + command.name());
            for (OPatchAutoOption option : options.getAllOptions()) {
                String argsStr = "";
                if (!allSDBOptions.contains(option.getKey()) || null == option.getValue() || option.getValue().length() <= 0) continue;
                argsStr = option.getKey().equalsIgnoreCase("patch.location") ? "\tpatch location : " + option.getValue() : (option.getKey().equalsIgnoreCase("patch.base.directory") ? "\tpatch directory : " + option.getValue() : (option.getKey().equalsIgnoreCase("id") ? "\tpatch ID : " + option.getValue() : (option.getKey().equalsIgnoreCase(OPatchAutoOptions.LOG_LEVEL_KEY) ? "\tlog level : " + option.getValue() : "\t" + option.getKey() + " : " + option.getValue())));
                summaryList.add(argsStr);
            }
            SystemInstance sysInst = PatchPlanner.getInstance().getSystemInstance();
            String shardingType = PatchActionUtil.getShardingType(sysInst);
            if (null == sysInst) break block14;
            boolean isOgg = PatchActionUtil.isOgg(sysInst);
            summaryList.add("\nSharded Database Configuration");
            summaryList.add("------------------------------");
            if (isOgg) {
                if (!shardingType.equalsIgnoreCase("user-defined")) {
                    List shardGroups = sysInst.getTargetsOfType(ShardGroup.class);
                    for (ShardGroup shardGroup : shardGroups) {
                        summaryList.add("\nOracle Golden Gate databases in Shard Group " + shardGroup.getShardGroupName() + " : ");
                        String sb = new String();
                        for (AbstractBaseTarget abt : shardGroup.getDatabases()) {
                            String abtShrdGrpName = this.getAbtShardGrpOrSpcName(abt, "shardgroup");
                            if (abtShrdGrpName == null || !abtShrdGrpName.equalsIgnoreCase(shardGroup.getShardGroupName())) continue;
                            sb = sb + abt.getName() + " (" + this.getDBType(abt) + ") on host " + abt.getHostName() + ", ";
                        }
                        sb = this.removeRearComa(sb);
                        summaryList.add("\t" + sb);
                    }
                } else {
                    List shardSpaces = sysInst.getTargetsOfType(ShardSpace.class);
                    for (ShardSpace shardSpace : shardSpaces) {
                        summaryList.add("\nOracle Golden Gate databases in Shard Space " + shardSpace.getShardSpaceName() + " : ");
                        String sb = new String();
                        for (AbstractBaseTarget abt : shardSpace.getDatabases()) {
                            String abtShrdSpcName = this.getAbtShardGrpOrSpcName(abt, "shardspace");
                            if (abtShrdSpcName == null || !abtShrdSpcName.equalsIgnoreCase(shardSpace.getShardSpaceName())) continue;
                            sb = sb + abt.getName() + " (" + this.getDBType(abt) + ") on host " + abt.getHostName() + ", ";
                        }
                        sb = this.removeRearComa(sb);
                        summaryList.add("\t" + sb);
                    }
                }
            } else {
                List dataguards = sysInst.getTargetsOfType(DataGuard.class);
                for (DataGuard dataGuard : dataguards) {
                    String dbname = "";
                    int drsetNumber = 0;
                    String hostname = "";
                    String dbtype = "";
                    if (dataGuard.getPrimary() instanceof SIDatabase) {
                        SIDatabase sidb = (SIDatabase)dataGuard.getPrimary();
                        dbname = sidb.getName();
                        drsetNumber = sidb.getShardProperty().getDrsetNumber();
                        hostname = sidb.getHostName();
                        dbtype = this.getDBType((AbstractBaseTarget)sidb);
                    } else if (dataGuard.getPrimary() instanceof RACDatabase) {
                        RACDatabase racdb = (RACDatabase)dataGuard.getPrimary();
                        dbname = racdb.getName();
                        drsetNumber = racdb.getShardProperty().getDrsetNumber();
                        hostname = racdb.getHostName();
                        dbtype = this.getDBType((AbstractBaseTarget)racdb);
                    }
                    summaryList.add("\nOracle Data Guard with DR-set number " + drsetNumber + " : ");
                    summaryList.add("\tPrimary database : " + dbname + "(" + dbtype + ") on host " + hostname);
                    String sb = new String();
                    for (AbstractBaseTarget abt : dataGuard.getStandbyDatabases()) {
                        sb = sb + abt.getName() + " (" + this.getDBType(abt) + ") on host " + abt.getHostName() + ", ";
                    }
                    sb = this.removeRearComa(sb);
                    summaryList.add("\tStandby database(s) : " + sb);
                }
            }
        }
        return summaryList;
    }

    private String removeRearComa(String sb) {
        if (!StringUtil.isNullOrEmpty((String)sb) && (sb = sb.trim()).endsWith(",")) {
            sb = sb.substring(0, sb.length() - 1);
        }
        return sb;
    }

    private String getDBType(AbstractBaseTarget abt) {
        String dbType = "Unknown DB type";
        String catalogDBType = null;
        if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            catalogDBType = sidb.getShardProperty().getDbType();
        } else if (abt instanceof RACDatabase) {
            RACDatabase racdb = (RACDatabase)abt;
            catalogDBType = racdb.getShardProperty().getDbType();
        }
        if (!StringUtil.isNullOrEmpty(catalogDBType)) {
            if (catalogDBType.equalsIgnoreCase("ADMIN_RAC") || catalogDBType.equalsIgnoreCase("POLICY_RAC")) {
                dbType = "RAC DB";
            } else if (catalogDBType.equalsIgnoreCase("NON_RAC")) {
                dbType = "Standalone DB";
            } else if (catalogDBType.equalsIgnoreCase("SIHA")) {
                dbType = "SIHA DB";
            }
        }
        return dbType;
    }

    private String getAbtShardGrpOrSpcName(AbstractBaseTarget abt, String value) {
        String name = null;
        ShardProperty shardProperty = new ShardProperty();
        if (abt instanceof SIDatabase) {
            SIDatabase sidb = (SIDatabase)abt;
            shardProperty = sidb.getShardProperty();
        } else if (abt instanceof RACDatabase) {
            RACDatabase racdb = (RACDatabase)abt;
            shardProperty = racdb.getShardProperty();
        }
        name = value.equals("shardgroup") ? shardProperty.getShardGroupName() : shardProperty.getShardSpaceName();
        return name;
    }
}

