/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBToOhConvertor {
    private static final Logger _log = Logger.getLogger(DBToOhConvertor.class.getName());

    public List<String> getHomeFromDatabase(String databasenames) throws OPatchAutoException {
        String[] databaseList;
        ArrayList<String> homeList = new ArrayList<String>();
        HashMap<String, String> dbnameMap = DBPatchingUtil.getDatabaseNameLocs();
        HashSet<Object> dbhomeset = new HashSet();
        HashMap<String, ArrayList<String>> databaseNames = new HashMap<String, ArrayList<String>>();
        if (dbnameMap.size() == 0) {
            throw new OPatchAutoException(OPatchAutoHelper.getPublishedMessage((String)Integer.toString(72044), (Object[])new Object[0]), new Object[0]);
        }
        for (String dbName : databaseList = databasenames.split(",")) {
            if (!dbnameMap.containsKey(dbName)) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"DBToOHConverter.invalid.database.warning", (Object[])new Object[]{dbName}));
                continue;
            }
            String dbhome = dbnameMap.get(dbName).toString();
            if (databaseNames.get(dbhome) != null) {
                databaseNames.get(dbhome).add(dbName);
                continue;
            }
            ArrayList<String> selecteddbs = new ArrayList<String>();
            selecteddbs.add(dbName);
            databaseNames.put(dbhome, selecteddbs);
        }
        dbhomeset = this.getSelectedDBHomes(databaseNames, dbnameMap);
        homeList.addAll(dbhomeset);
        return homeList;
    }

    private HashSet<String> getSelectedDBHomes(HashMap<String, ArrayList<String>> databaseNames, HashMap<String, String> dbnameMap) {
        HashSet<String> dbHomeSet = new HashSet<String>();
        StringBuffer buff = new StringBuffer("DBToOhConvertor:getSelectedDatabases called... \n");
        Iterator<String> iter = dbnameMap.keySet().iterator();
        HashMap reverseMap = new HashMap();
        while (iter.hasNext()) {
            String key = iter.next().toString();
            String value = dbnameMap.get(key).toString();
            if (reverseMap.get(value) != null) {
                ((ArrayList)reverseMap.get(value)).add(key);
                continue;
            }
            ArrayList<String> names = new ArrayList<String>();
            names.add(key);
            reverseMap.put(value, names);
        }
        iter = databaseNames.keySet().iterator();
        while (iter.hasNext()) {
            String home = iter.next().toString();
            if (reverseMap.get(home) == null || ((ArrayList)reverseMap.get(home)).size() == databaseNames.get(home).size()) continue;
            ArrayList names = (ArrayList)reverseMap.get(home);
            names.removeAll((Collection)databaseNames.get(home));
            if (names.size() > 0) {
                buff.append("Database ");
                int i = 0;
                for (String db : names) {
                    buff.append("'" + db + "'");
                    if (++i == names.size()) continue;
                    buff.append(",");
                }
                buff.append(" of home \"" + home + "\" will get impacted. Please specify all databases of the home or use the '-oh' option instead.");
            }
            _log.log(Level.WARNING, buff.toString());
        }
        dbHomeSet.addAll(databaseNames.keySet());
        return dbHomeSet;
    }
}

