/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.PatchPlanException;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandUtils;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import dbmodel.db_crs.DBService;
import dbmodel.db_crs.DBServiceNode;
import dbmodel.db_crs.RACDBInstance;
import dbmodel.db_crs.RACDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class RelocateDatabaseServices
extends SimpleShellCommand {
    Logger logger = Logger.getLogger(RelocateDatabaseServices.class.getName());
    private static Map<String, DBServiceNode> switchedNodes = new HashMap<String, DBServiceNode>();

    public RelocateDatabaseServices(CommandAction automationAction) {
        super((ActionType)automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        String cmd = "";
        ArrayList<String> cmds = null;
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        AbstractBaseTarget primaryTarget = context.getPrimaryTarget();
        if (primaryTarget instanceof RACDBInstance) {
            RACDBInstance racDBInstance = (RACDBInstance)primaryTarget;
            RACDatabase racDatabase = racDBInstance.getDbRAC();
            String hostname = racDBInstance.getHost().getHostName().toLowerCase();
            this.logger.log(Level.FINE, "Generating RelocateDatabaseServices command for RAC Datababse Instance " + racDBInstance.getName());
            if (null != racDatabase.getServices() && racDatabase.getServices().size() > 0) {
                for (DBService dbService : racDatabase.getServices()) {
                    List<DBServiceNode> activeNodes = this.getActiveNodes(dbService.getConfiguredNodes());
                    this.logger.log(Level.FINEST, "Service " + dbService.getName() + " is running : " + dbService.getIsRunning());
                    this.logger.log(Level.FINEST, "Service " + dbService.getName() + " has " + activeNodes.size() + " active nodes and " + dbService.getConfiguredNodes().size() + " configured nodes ");
                    if (dbService.getIsRunning() && activeNodes.size() == 1 && dbService.getConfiguredNodes().size() > 1 && !oh.getIsShared()) {
                        DBServiceNode configuredNodeForRelocation;
                        DBServiceNode activeNode = activeNodes.get(0);
                        if (!racDBInstance.getName().equals(activeNode.getDatabaseInstance()) || !racDBInstance.getHost().getName().equals(activeNode.getHostName())) continue;
                        this.logger.log(Level.FINE, "Service " + dbService.getName() + " is going to be relocated");
                        if (null == cmds) {
                            cmds = new ArrayList<String>();
                        }
                        if (this.automationAction.getType().equals(DBCommandActionType.StopRelocatedDatabaseServices.toString())) {
                            cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl relocate service -d " + racDatabase.getDatabaseName() + " -s " + dbService.getName();
                            configuredNodeForRelocation = this.getConfiguredNodeToRelocate(dbService, activeNode);
                            if (null == configuredNodeForRelocation) continue;
                            cmd = dbService.getAdministrationType().equalsIgnoreCase("adminManagedDB") ? cmd + " -i " + configuredNodeForRelocation.getDatabaseInstance() + " -t " + activeNode.getDatabaseInstance() : cmd + " -currentnode " + configuredNodeForRelocation.getHostName() + " -n " + activeNode.getHostName();
                            cmds.add(cmd);
                            continue;
                        }
                        cmd = "ORACLE_HOME=" + oh.getPath() + " " + oh.getPath() + "/bin/srvctl relocate service -d " + racDatabase.getDatabaseName() + " -s " + dbService.getName();
                        configuredNodeForRelocation = this.getConfiguredNodeToRelocate(dbService, activeNode);
                        if (null == configuredNodeForRelocation) continue;
                        cmd = dbService.getAdministrationType().equalsIgnoreCase("adminManagedDB") ? cmd + " -i " + activeNode.getDatabaseInstance() + " -t " + configuredNodeForRelocation.getDatabaseInstance() : cmd + " -currentnode " + activeNode.getHostName() + " -n " + configuredNodeForRelocation.getHostName();
                        cmds.add(cmd);
                        switchedNodes.put(dbService.getName(), configuredNodeForRelocation);
                        String location = DBCommandUtils.getSerializationLocationForRelocateServices(oh.getPath(), hostname);
                        try {
                            FileUtility.persistDataObj((String)location, switchedNodes, (boolean)true);
                            continue;
                        }
                        catch (IOException e) {
                            throw new PatchPlanException("Exception while persisting switchedNode information to " + location + " because " + e.getMessage());
                        }
                    }
                    if (!this.automationAction.getType().equals(DBCommandActionType.RelocateDatabaseServices.toString())) continue;
                    StringBuffer message = new StringBuffer("");
                    if (!dbService.getIsRunning()) {
                        message.append("currently not running");
                    } else if (activeNodes.size() > 1) {
                        message.append("already running on other node(s)");
                    } else if (dbService.getConfiguredNodes().size() <= 1) {
                        message.append("not configured to run on any other node(s)");
                        Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"RelocateDatabaseServices.cannot.switch.warning", (Object[])new Object[]{dbService.getName(), racDatabase.getName(), message}));
                    } else if (oh.getIsShared()) {
                        message.append("running on a shared home");
                    } else {
                        message.append("invalid");
                    }
                    this.logger.log(Level.FINE, OPatchAutoHelper.getLocalizedString((String)"RelocateDatabaseServices.cannot.switch.warning", (Object[])new Object[]{dbService.getName(), racDatabase.getName(), message}));
                }
            }
        }
        return cmds;
    }

    private List<DBServiceNode> getActiveNodes(List<DBServiceNode> configuredNodes) {
        ArrayList<DBServiceNode> activeNodes = new ArrayList<DBServiceNode>();
        for (DBServiceNode node : configuredNodes) {
            if (!node.getIsRunning()) continue;
            activeNodes.add(node);
        }
        return activeNodes;
    }

    private DBServiceNode getConfiguredNodeToRelocate(DBService service, DBServiceNode activeNode) {
        for (DBServiceNode node : service.getConfiguredNodes()) {
            if (node.getDatabaseInstance().equals(activeNode.getDatabaseInstance())) continue;
            return node;
        }
        return null;
    }

    public static class Builder
    implements CommandBuilder<RelocateDatabaseServices> {
        @Override
        public RelocateDatabaseServices getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction) || !a.getType().equals(DBCommandActionType.RelocateDatabaseServices.toString()) && !a.getType().equals(DBCommandActionType.StopRelocatedDatabaseServices.toString())) {
                return null;
            }
            return new RelocateDatabaseServices((CommandAction)a);
        }
    }
}

