/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.cmdtranslator.commands;

import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandBuilder;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.CommandContext;
import com.oracle.glcm.patch.auto.db.framework.sdk.cmdtranslator.commands.SimpleShellCommand;
import com.oracle.glcm.patch.auto.db.product.cmdtranslator.DBCommandActionType;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.system.db.automation.jaxb.ActionType;
import oracle.opatch.system.db.automation.jaxb.Command;
import oracle.opatch.system.db.automation.jaxb.CommandAction;
import oracle.opatch.system.db.automation.jaxb.Strategy;

public class StopAndStartDBCommand
extends SimpleShellCommand {
    private static String STOP_DATABASE = "/bin/srvctl stop database ";
    private static String START_DATABASE = "/bin/srvctl start database ";
    private static String STOP_RAC_DATABASE_INSTANCE = "/bin/srvctl stop instance -f ";
    private static String START_RAC_DATABASE_INSTANCE = "/bin/srvctl start instance ";

    public StopAndStartDBCommand(ActionType automationAction) {
        super(automationAction);
    }

    @Override
    public List<String> getShellCommands(CommandContext context) {
        ArrayList<String> cmds = new ArrayList<String>();
        OracleHome oh = context.getFirstTarget(OracleHome.class);
        CommandAction commandAction = (CommandAction)this.getAutomationAction();
        String type = commandAction.getType();
        StringBuilder command = new StringBuilder("ORACLE_HOME=" + oh.getPath() + " " + oh.getPath());
        Command commandDetails = (Command)commandAction.getCommand().get(0);
        if (type.equalsIgnoreCase(DBCommandActionType.StartDB.toString())) {
            command.append(START_DATABASE);
        } else if (type.equals(DBCommandActionType.StopDB.toString())) {
            command.append(STOP_DATABASE);
        } else if (type.equals(DBCommandActionType.StartDBInst.toString())) {
            command.append(START_RAC_DATABASE_INSTANCE);
        } else {
            command.append(STOP_RAC_DATABASE_INSTANCE);
        }
        this.addAdditionalParameters(command, commandDetails.getParameter());
        cmds.add(command.toString());
        return cmds;
    }

    private void addAdditionalParameters(StringBuilder command, List<String> parameter) {
        for (String param : parameter) {
            command.append(param).append(" ");
        }
    }

    public static class Builder
    implements CommandBuilder<StopAndStartDBCommand> {
        @Override
        public StopAndStartDBCommand getCommand(ActionType a, Strategy s) {
            if (!(a instanceof CommandAction && (a.getType().equals(DBCommandActionType.StopDB.toString()) || a.getType().equals(DBCommandActionType.StartDB.toString()) || a.getType().equals(DBCommandActionType.StartDBInst.toString()) || a.getType().equals(DBCommandActionType.StopDBInst.toString())))) {
                return null;
            }
            StopAndStartDBCommand ch = new StopAndStartDBCommand(a);
            return ch;
        }
    }
}

