/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.patchlevel;

import com.oracle.glcm.patch.auto.db.product.patchlevel.OracleHomePatchLevel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatchauto.core.binary.OPatchPatchInfo;

public class OracleHomePatchLevelFinder {
    private static final Logger _log = Logger.getLogger(OracleHomePatchLevelFinder.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (args != null) {
            argsList.addAll(Arrays.asList(args));
        }
        String invPtrLoc = null;
        String location = null;
        List<String> ohList = null;
        for (int x = 0; x < argsList.size(); ++x) {
            String tempArg;
            if (((String)argsList.get(x)).startsWith("-INVPTRLOC")) {
                tempArg = (String)argsList.get(x);
                invPtrLoc = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
                continue;
            }
            if (((String)argsList.get(x)).startsWith("-OBJECTLOC")) {
                tempArg = (String)argsList.get(x);
                location = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
                continue;
            }
            if (!((String)argsList.get(x)).startsWith("-OHLIST")) continue;
            tempArg = (String)argsList.get(x);
            String homeList = tempArg.substring(tempArg.indexOf(61) + 1, tempArg.length());
            ohList = Arrays.asList(homeList.split(","));
        }
        OracleHomePatchLevel oracleHomePatchLevel = new OracleHomePatchLevel();
        for (String oracleHome : ohList) {
            try {
                OPatchContext context = OPatchContext.getInstance((String)oracleHome, invPtrLoc);
                OPatchPatch[] activePatchList = context.getInstalledActivePatches();
                ArrayList<OPatchPatchInfo> patchInfos = new ArrayList<OPatchPatchInfo>();
                for (OPatchPatch patch : activePatchList) {
                    patchInfos.add(OracleHomePatchLevelFinder.findPatchLevelOnOracleHome(patch));
                }
                oracleHomePatchLevel.addOracleHomePatchLevel(oracleHome, patchInfos);
            }
            catch (OPatchException e) {
                _log.info("OPatchException: Patch info query failed due to error code: " + e.getErrorCode() + "message: " + e.getMessage());
                System.exit(100);
            }
            finally {
                try {
                    OPatchContext.destroyContextReference();
                }
                catch (OPatchException e) {
                    _log.info("OPatchException: Patch info query failed due to error code: " + e.getErrorCode() + "message: " + e.getMessage());
                    System.exit(100);
                }
            }
        }
        OracleHomePatchLevelFinder.persistPatchInfo(location, oracleHomePatchLevel);
    }

    private static OPatchPatchInfo findPatchLevelOnOracleHome(OPatchPatch patch) {
        OPatchPatchInfo patchInfo = new OPatchPatchInfo();
        patchInfo.setPatchID(patch.getPatchId());
        patchInfo.setUniquePatchID(patch.getUniquePatchIdentifier());
        patchInfo.setSQLPatch(patch.isSqlPatch());
        return patchInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistPatchInfo(String location, OracleHomePatchLevel oracleHomePatchLevel) {
        File persistFile = new File(location);
        if (!persistFile.getParentFile().exists()) {
            persistFile.getParentFile().mkdirs();
        }
        if (persistFile.exists()) {
            persistFile.delete();
        }
        FileOutputStream fileOut = null;
        ObjectOutputStream out = null;
        try {
            fileOut = new FileOutputStream(location);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(oracleHomePatchLevel);
            out.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            _log.info("FileNotFoundException: Persisting patch info failed due to  " + e.getMessage());
            System.exit(103);
        }
        catch (IOException e) {
            _log.info("IOException: Persisting patch info failed due to  " + e.getMessage());
            System.exit(103);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (IOException e) {
                _log.info("IOException: Persisting patch info failed due to  " + e.getMessage());
                System.exit(103);
            }
        }
    }
}

