/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.db.framework.sdk.graphlib.ConfigGraph;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidationController;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.DBPatchingUtil;
import com.oracle.glcm.patch.auto.db.product.oop.sessioninfo.OOPSessionCookie;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationPhase;
import com.oracle.glcm.patch.auto.db.product.validation.data.CRSValidationFilterForPatching;
import com.oracle.glcm.patch.auto.db.product.validation.data.SIHAValidationFilterForPatching;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSExecutionModeValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSLogicalStandbyNotUsedValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSObjectValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSPlatformAsRequestedValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSRACsConfigValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CRSversionGreaterValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CatalogDataValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CatalogHomeConnectionValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CheckForNullValuesValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.CluvfyValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DBStatusValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.DatabaseHomeOptionValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.GIAppplicabilityValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.GIHomeValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.GIMRhomevalidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.NonRollingOracleHomeValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.OOPPatchTargetValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.OPatchVersionValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.OracleHomePathValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.OracleHomeTypeValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RACOneVersionValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RACVersionGreaterValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RACversionCRSValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.RemoteGIStatusValidation;
import com.oracle.glcm.patch.auto.db.product.validation.validators.SDBOptionsValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.TargetRootSessionValidator;
import com.oracle.glcm.patch.auto.db.product.validation.validators.UserCredentialValidator;
import dbmodel.common.OracleHome;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class DBValidationController
implements IValidationController {
    Logger logger = Logger.getLogger(DBValidationController.class.getName());

    @Override
    public List<ValidationResult> invoke(ValidationParam params) {
        ValidationPhase validationPhase = (ValidationPhase)((Object)params.get(ValidationParamKey.VALIDATION_PHASE.ordinal()));
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        switch (validationPhase) {
            case PRODUCT_INITIALISATION: {
                validationList.addAll(this.getProductInitialiationValidatorList(params));
                break;
            }
            case BUILD_TOPOLOGY: {
                validationList.addAll(this.getTopologyBuildValidatorList(params));
                break;
            }
            case POST_TOPOLOGY: {
                validationList.addAll(this.getPostTopologyValidatorList(params));
                break;
            }
        }
        ArrayList<ValidationResult> failedValidations = new ArrayList<ValidationResult>();
        MultipleValidationResult multipleValidationResult = null;
        for (IValidator validator : validationList) {
            multipleValidationResult = validator.validate(params);
            for (ValidationResult validationResult : multipleValidationResult.getValidationResultList()) {
                this.logger.fine("Validation status :: " + (Object)((Object)validationResult.getStatus()));
                if (!validationResult.getStatus().equals((Object)ValidationResult.ValidationStatus.FAILED)) continue;
                this.logger.fine("Validation failed with reason  :: " + validationResult.getFailureReason());
                this.logger.info("Validation failed due to :" + OPatchAutoHelper.getPublishedMessage((String)Integer.toString(validationResult.getFailureReason().getErrorCode()), (Object[])new Object[]{validationResult.getPayload()}));
                failedValidations.add(validationResult);
            }
        }
        return failedValidations;
    }

    private Collection<? extends IValidator> getPostTopologyValidatorList(ValidationParam params) {
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        validationList.add(new UserCredentialValidator());
        validationList.add(new OPatchVersionValidator());
        validationList.add(new TargetRootSessionValidator());
        validationList.add(new OOPPatchTargetValidator());
        return validationList;
    }

    private Collection<? extends IValidator> getProductInitialiationValidatorList(ValidationParam params) {
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        boolean isSdbMode = false;
        if (params.get(ValidationParamKey.SDB_OPTION.ordinal()) != null) {
            isSdbMode = (Boolean)params.get(ValidationParamKey.SDB_OPTION.ordinal());
        }
        boolean isDgMode = false;
        if (params.get(ValidationParamKey.DG_OPTION.ordinal()) != null) {
            isDgMode = (Boolean)params.get(ValidationParamKey.DG_OPTION.ordinal());
        }
        boolean isShardGrpMode = false;
        boolean isShardSpcMode = false;
        if (params.get(ValidationParamKey.SHARD_GROUP.ordinal()) != null) {
            isShardGrpMode = (Boolean)params.get(ValidationParamKey.SHARD_GROUP.ordinal());
        } else if (params.get(ValidationParamKey.SHARD_SPACE.ordinal()) != null) {
            isShardSpcMode = (Boolean)params.get(ValidationParamKey.SHARD_SPACE.ordinal());
        }
        if (isSdbMode) {
            validationList.add(new CatalogHomeConnectionValidator());
        }
        boolean isSidbOnlyMode = false;
        if (params.get(ValidationParamKey.SIDB_ONLY.ordinal()) != null) {
            isSidbOnlyMode = (Boolean)params.get(ValidationParamKey.SIDB_ONLY.ordinal());
        }
        if (!(isSidbOnlyMode || isSdbMode || isDgMode || isShardGrpMode || isShardSpcMode)) {
            validationList.add(new OracleHomePathValidation());
            validationList.add(new DatabaseHomeOptionValidation());
            validationList.add(new GIAppplicabilityValidation());
            validationList.add(new NonRollingOracleHomeValidation());
        }
        return validationList;
    }

    private List<IValidator> getTopologyBuildValidatorList(ValidationParam param) {
        HashSet<String> platforms = new HashSet<String>();
        platforms.add("267");
        platforms.add("226");
        platforms.add("23");
        platforms.add("212");
        platforms.add("197");
        platforms.add("209");
        boolean isSdbMode = false;
        if (param.get(ValidationParamKey.SDB_OPTION.ordinal()) != null) {
            isSdbMode = (Boolean)param.get(ValidationParamKey.SDB_OPTION.ordinal());
        }
        List<IValidator> validationList = null;
        if (isSdbMode) {
            validationList = new ArrayList<IValidator>();
            validationList.add(new CatalogDataValidator());
            validationList.add(new SDBOptionsValidator());
        } else {
            ConfigGraph graph = (ConfigGraph)param.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
            List<OracleHome> homes = graph.getTargets(OracleHome.class);
            boolean hasCrs = false;
            for (OracleHome home : homes) {
                if (!home.getHomeType().equalsIgnoreCase("crs")) continue;
                hasCrs = true;
                break;
            }
            if (hasCrs) {
                validationList = this.getCRSValidatorList(param);
                validationList.add(0, new CRSPlatformAsRequestedValidator(platforms, true));
            } else {
                validationList = this.getSIHAValidatorList(param);
                validationList.add(0, new CRSPlatformAsRequestedValidator(platforms, false));
            }
        }
        return validationList;
    }

    private List<IValidator> getCRSValidatorList(ValidationParam param) {
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        if (!((Boolean)param.get(ValidationParamKey.HOME_KEY_OPTION.ordinal())).booleanValue()) {
            validationList.add(new CheckForNullValuesValidator());
            param.set(ValidationParamKey.METHOD_VALIDATION_FILTER.ordinal(), CRSValidationFilterForPatching.getObjectsToValidate());
        }
        boolean isSidbOnlyMode = false;
        if (param.get(ValidationParamKey.SIDB_ONLY.ordinal()) != null) {
            isSidbOnlyMode = (Boolean)param.get(ValidationParamKey.SIDB_ONLY.ordinal());
        }
        validationList.add(new OracleHomeTypeValidator());
        ConfigGraph graph = (ConfigGraph)param.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<OracleHome> homes = graph.getTargets(OracleHome.class);
        boolean hasCrs = false;
        boolean hasRac = false;
        for (OracleHome home : homes) {
            if (home.getHomeType().equalsIgnoreCase("crs")) {
                hasCrs = true;
                OracleHome crsHome = home;
                continue;
            }
            if (!home.getHomeType().equalsIgnoreCase("rac")) continue;
            hasRac = true;
        }
        if (hasCrs) {
            OOPSessionCookie.OOPOperationType operationType = (OOPSessionCookie.OOPOperationType)((Object)param.get(ValidationParamKey.OOP_OPERATION_TYPE.ordinal()));
            if (DBPatchingUtil.isDBVersionTweleveOrLater(graph.getRootVertex().getVersion()) || graph.getRootVertex().getVersion().startsWith("11") && ((Boolean)param.get(ValidationParamKey.REMOTE_PATCHING.ordinal())).booleanValue()) {
                validationList.add(new CRSExecutionModeValidator());
            }
            boolean cluvfyRequired = false;
            if (((Boolean)param.get(ValidationParamKey.OOP_ENABLED.ordinal())).booleanValue()) {
                if (operationType != null && operationType != OOPSessionCookie.OOPOperationType.SWITCH && operationType != OOPSessionCookie.OOPOperationType.ROLLBACK) {
                    cluvfyRequired = true;
                }
            } else {
                cluvfyRequired = true;
            }
            if (cluvfyRequired) {
                validationList.add(new CluvfyValidator());
            } else {
                this.logger.fine("CluvfyValidator will be skipped for this type of patching session.");
            }
            if (!(isSidbOnlyMode || !DBPatchingUtil.isDBVersionTweleveOrLater(graph.getRootVertex().getVersion()) || ((Boolean)param.get(ValidationParamKey.GENERATE_STEP_OPTION.ordinal())).booleanValue() || operationType != null && operationType == OOPSessionCookie.OOPOperationType.PREPARE)) {
                validationList.add(new RemoteGIStatusValidation());
            }
            validationList.add(new CRSObjectValidator());
            validationList.add(new GIHomeValidator());
            validationList.add(new CRSversionGreaterValidator("11.2.0.2"));
            if (hasRac) {
                validationList.add(new CRSRACsConfigValidator());
                validationList.add(new RACversionCRSValidator());
                validationList.add(new RACOneVersionValidator("12.1.0.1.0"));
                validationList.add(new CRSLogicalStandbyNotUsedValidator());
                validationList.add(new GIMRhomevalidator());
            }
        } else if (hasRac) {
            validationList.add(new RACVersionGreaterValidator("11.2.0.2"));
            validationList.add(new RACOneVersionValidator("12.1.0.1.0"));
            validationList.add(new CRSLogicalStandbyNotUsedValidator());
            validationList.add(new GIMRhomevalidator());
        }
        if (!isSidbOnlyMode) {
            validationList.add(new DBStatusValidation("crs"));
        }
        return validationList;
    }

    private List<IValidator> getSIHAValidatorList(ValidationParam param) {
        ArrayList<IValidator> validationList = new ArrayList<IValidator>();
        ConfigGraph graph = (ConfigGraph)param.get(ValidationParamKey.CONFIG_GRAPH.ordinal());
        List<OracleHome> homes = graph.getTargets(OracleHome.class);
        boolean hasSIHA = false;
        boolean hasSIDB = false;
        for (OracleHome home : homes) {
            if (home.getHomeType().equalsIgnoreCase("siha")) {
                hasSIHA = true;
                continue;
            }
            if (!home.getHomeType().equalsIgnoreCase("sidb")) continue;
            hasSIDB = true;
        }
        if (hasSIHA && hasSIDB) {
            param.set(ValidationParamKey.METHOD_VALIDATION_FILTER.ordinal(), SIHAValidationFilterForPatching.getObjectsToValidate(true));
            validationList.add(new CheckForNullValuesValidator());
        } else if (hasSIDB) {
            param.set(ValidationParamKey.METHOD_VALIDATION_FILTER.ordinal(), SIHAValidationFilterForPatching.getObjectsToValidate(false));
            validationList.add(new CheckForNullValuesValidator());
        }
        validationList.add(new OracleHomeTypeValidator());
        boolean isSidbOnlyMode = false;
        if (param.get(ValidationParamKey.SIDB_ONLY.ordinal()) != null) {
            isSidbOnlyMode = (Boolean)param.get(ValidationParamKey.SIDB_ONLY.ordinal());
        }
        if (!(isSidbOnlyMode || ((Boolean)param.get(ValidationParamKey.GENERATE_STEP_OPTION.ordinal())).booleanValue() || ((Boolean)param.get(ValidationParamKey.OOP_ENABLED.ordinal())).booleanValue())) {
            validationList.add(new RemoteGIStatusValidation());
        }
        if (!isSidbOnlyMode) {
            validationList.add(new DBStatusValidation("siha"));
        }
        return validationList;
    }
}

