/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.integration.model.productsupport.topology.DBPatchingHelper;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import dbmodel.SystemInstance;
import dbmodel.common.AbstractBaseTarget;
import dbmodel.common.OracleHome;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GIMRhomevalidator
implements IValidator {
    Logger logger = Logger.getLogger(GIMRhomevalidator.class.getName());

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        ArrayList list = new ArrayList();
        SystemInstance systemInst = (SystemInstance)params.get(ValidationParamKey.SYSTEM_INST.ordinal());
        List homes = systemInst.getTargetsOfType(OracleHome.class);
        String message = null;
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        String gimrhome = DBPatchingHelper.getGIMRHomePath();
        this.logger.log(Level.FINEST, "GIMR Home is  " + gimrhome);
        if (gimrhome == null || gimrhome.isEmpty()) {
            this.logger.log(Level.INFO, "The configuration contains no GIMR ");
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            return multipleValidationResult;
        }
        ArrayList giHomes = new ArrayList();
        for (AbstractBaseTarget abt : homes) {
            OracleHome home = (OracleHome)abt;
            if (!home.getPath().equals(gimrhome)) continue;
            this.logger.log(Level.FINEST, "GIMR Home selected for patching ");
            File mgmtfile = new File(gimrhome + "/bin/mgmtca");
            boolean exists = mgmtfile.exists();
            if (!exists) {
                this.logger.log(Level.INFO, "The home does not have valid mgmtca ");
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MGMTCA_NOT_FOUND, null));
                return multipleValidationResult;
            }
            if (!mgmtfile.canExecute() || !mgmtfile.canRead()) {
                this.logger.log(Level.INFO, "mgmtca does not have required permissions ");
                multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.MGMTCA_NOPERMISSION, null));
                return multipleValidationResult;
            }
            message = " GIMR configuration is valid";
            this.logger.log(Level.FINE, message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
            return multipleValidationResult;
        }
        return multipleValidationResult;
    }
}

