/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.product.validation.validators;

import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.db.framework.validation.BundleUtils;
import com.oracle.glcm.patch.auto.db.framework.validation.IValidator;
import com.oracle.glcm.patch.auto.db.framework.validation.MultipleValidationResult;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationParam;
import com.oracle.glcm.patch.auto.db.framework.validation.ValidationResult;
import com.oracle.glcm.patch.auto.db.product.validation.DBValidationFailureReason;
import com.oracle.glcm.patch.auto.db.product.validation.ValidationParamKey;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleHomePathValidation
implements IValidator {
    private Logger logger = Logger.getLogger(OracleHomePathValidation.class.getName());
    private StringBuilder errorDetails;

    @Override
    public MultipleValidationResult validate(ValidationParam params) {
        this.logger.log(Level.FINE, "Invoking oracle home validation to check whether supplied oracle home is valid or not.");
        List oracleHomes = (List)params.get(ValidationParamKey.ORACLE_HOMES.ordinal());
        boolean ohOptionEnabled = (Boolean)params.get(ValidationParamKey.HOME_KEY_OPTION.ordinal());
        MultipleValidationResult multipleValidationResult = new MultipleValidationResult();
        ArrayList<String> invalidHomes = new ArrayList<String>();
        StringBuilder ohList = new StringBuilder();
        for (String oh : oracleHomes) {
            boolean isOhPathOk = this.isOHPathOK(oh);
            if (isOhPathOk) continue;
            invalidHomes.add(oh);
            ohList.append(oh + " ");
            this.logger.log(Level.INFO, this.errorDetails.toString());
        }
        if (!invalidHomes.isEmpty() && ohOptionEnabled) {
            String message = BundleUtils.getMessage(OracleHomePathValidation.class, "INVALID_ORACLE_HOME", ohList.toString());
            Reporting.report((String)message);
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.FAILED, DBValidationFailureReason.WRONG_OH_ARGUMENT, ohList.toString().trim()));
        } else {
            multipleValidationResult.addValidationResult(new ValidationResult(ValidationResult.ValidationStatus.SUCCESS, null, null));
        }
        return multipleValidationResult;
    }

    private boolean isOHPathOK(String path) {
        boolean isOHPathOk = true;
        File fp = new File(path);
        if (!fp.exists()) {
            this.errorDetails = new StringBuilder("OPatch cannot find ORACLE_HOME (\"");
            this.errorDetails.append(path);
            this.errorDetails.append("\")");
            isOHPathOk = false;
        } else {
            StringBuffer buff = new StringBuffer("User path: ");
            buff.append(path);
            buff.append("\n Absolute path detected: ");
            buff.append(fp.getAbsolutePath());
            this.logger.fine(buff.toString());
            if (!fp.isAbsolute()) {
                this.errorDetails = new StringBuilder("\nOracle Home Path specified is relative path.");
                this.errorDetails.append("\nOPatch cannot work with relative Oracle Home Paths, please specify the absolute path to Oracle Home.");
                isOHPathOk = false;
            } else {
                this.logger.fine("Prereq isOHPathOK passed");
            }
        }
        return isOHPathOk;
    }
}

