/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.db.utils.remote;

import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import com.oracle.cie.remote.RemoteConnectionManager;
import com.oracle.glcm.patch.auto.db.utils.remote.IRemoteCommandResult;
import com.oracle.glcm.patch.auto.topology.Home;
import com.oracle.glcm.patch.auto.topology.Host;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RemoteCommandExecutor
implements Runnable {
    private String command;
    private Host host;
    private String serializedObjLoc;
    private IRemoteCommandResult resultListener;
    private Logger logger = Logger.getLogger(RemoteCommandExecutor.class.getName());
    private Map<Home, String> commandToExecuteInHome = null;
    private Map<String, String> envVariableList = null;

    public RemoteCommandExecutor(Host host, IRemoteCommandResult resultListener) {
        this.host = host;
        this.resultListener = resultListener;
    }

    public RemoteCommandExecutor(String command, Host host, IRemoteCommandResult resultListener) {
        this(host, resultListener);
        this.command = command;
    }

    public RemoteCommandExecutor(String command, String serializedObjLoc, Host host, IRemoteCommandResult resultListener) {
        this(command, host, resultListener);
        this.serializedObjLoc = serializedObjLoc;
    }

    public void setCommandToExecuteInHomes(Map<Home, String> commandList) {
        this.commandToExecuteInHome = commandList;
    }

    public void setEnvVariables(Map<String, String> envVariables) {
        this.envVariableList = envVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (RemoteConnectionHandler handler = null;){
            Home currentHome = null;
            try {
                handler = RemoteConnectionManager.getRemoteConnectionManager().getRemoteConnectionHandler((RemoteConnectionHost)this.host);
                if (this.commandToExecuteInHome == null) {
                    this.executeAndNotify(handler, this.command, null);
                } else {
                    Set<Home> homeList = this.commandToExecuteInHome.keySet();
                    Iterator<Home> iterator = homeList.iterator();
                    while (iterator.hasNext()) {
                        Home tmp;
                        currentHome = tmp = iterator.next();
                        this.executeAndNotify(handler, this.commandToExecuteInHome.get(currentHome), currentHome);
                    }
                }
            }
            catch (RemoteConnectionException e) {
                if (handler == null) {
                    this.resultListener.notifyResult(2, e.getLocalizedMessage(), this.host, currentHome, Thread.currentThread(), null);
                } else {
                    this.resultListener.notifyResult(1, e.getLocalizedMessage(), this.host, currentHome, Thread.currentThread(), null);
                }
            }
        }
    }

    private void executeAndNotify(RemoteConnectionHandler handler, String commandToExecute, Home home) throws RemoteConnectionException, IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (this.envVariableList == null) {
                handler.exec(commandToExecute, (OutputStream)outputStream);
            } else {
                handler.exec(commandToExecute, (OutputStream)outputStream, this.envVariableList);
            }
        }
        catch (RemoteConnectionException e) {
            throw new RemoteConnectionException(e.getMessage(), (Throwable)e);
        }
        String outPutMsg = outputStream.toString();
        this.resultListener.notifyResult(0, outPutMsg, this.host, home, Thread.currentThread(), this.serializedObjLoc != null ? handler.getObject(this.serializedObjLoc) : null);
        outputStream.flush();
        outputStream.close();
    }
}

