/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency;

import com.oracle.cie.dependency.EKey;
import com.oracle.cie.dependency.TEdge;
import com.oracle.cie.dependency.TVertex;
import com.oracle.cie.dependency.VKey;
import com.oracle.cie.dependency.graph.DirectedGraph;
import com.oracle.cie.dependency.graph.VisitorAdaptor;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

class ConflictSourceFinder
extends VisitorAdaptor<VKey, TVertex, EKey, TEdge, DirectedGraph<VKey, TVertex, EKey, TEdge>> {
    private DirectedGraph<VKey, TVertex, EKey, TEdge> _graph;
    private List<TVertex> _conflictSourceItems = new ArrayList<TVertex>();

    ConflictSourceFinder(DirectedGraph<VKey, TVertex, EKey, TEdge> graph, PrintStream traceOut) {
        super(traceOut);
        this._graph = graph;
    }

    public List<TVertex> getConflictSourceItems() {
        return this._conflictSourceItems;
    }

    @Override
    public void preOp(DirectedGraph<VKey, TVertex, EKey, TEdge> graph) {
        if (this._graph != graph) {
            throw new IllegalArgumentException("Graph is not the one this visitor was created with!!!");
        }
        this._conflictSourceItems.clear();
    }

    @Override
    public boolean preVisit(TEdge edge, TVertex vertex) {
        super.preVisit(edge, vertex);
        VKey vKey = (VKey)vertex.getKey();
        if (edge == null) {
            this.trace("DISCOVERING PRIOR CONFLICT SOURCES FOR <", vertex, ">");
            return true;
        }
        this.trace("PROCESSING <", vertex, "> reached from <", edge.getDest(), ">");
        if (vKey.getSelectedState() != VKey.SelectedState.SELECTED) {
            this.traceAction("STOP-NOACTION: vertex not selected: ", vKey);
            return false;
        }
        if (((EKey)edge.getKey()).getType() == EKey.EType.CONFLICTS) {
            if (vKey.getType() == VKey.VType.TINFO) {
                this.traceAction("STOP-FOUND: direct conflict source; adding to conflict sources list: ", vKey);
                this._conflictSourceItems.add(vertex);
                return false;
            }
            this.traceAction("CONTINUE: intermediate condition: ", vKey);
            return true;
        }
        if (((VKey)((TVertex)edge.getDest()).getKey()).getType() == VKey.VType.TINFO) {
            this.traceAction("STOP-NOACTION: found dependent of the starting vertex: ", vKey);
            return false;
        }
        if (vKey.getType() == VKey.VType.TINFO) {
            this.traceAction("STOP-FOUND: indirect conflict source; adding to conflict sources list: ", vKey);
            this._conflictSourceItems.add(vertex);
            return false;
        }
        this.traceAction("CONTINUE: intermediate condition: ", vKey);
        return true;
    }
}

