/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.graph;

import com.oracle.cie.dependency.graph.Vertex;
import com.oracle.cie.dependency.graph.VertexFactory;
import java.util.HashMap;
import java.util.Map;

public class DefaultVertex<VK>
implements Vertex<VK> {
    private VK _key;
    private Vertex.Color _color;
    private Map<String, Object> _attributeMap = new HashMap<String, Object>();

    public DefaultVertex(VK key) {
        this._key = key;
    }

    @Override
    public VK getKey() {
        return this._key;
    }

    @Override
    public void setKey(VK key) {
        this._key = key;
    }

    @Override
    public void setColor(Vertex.Color c) {
        this._color = c;
    }

    @Override
    public Vertex.Color getColor() {
        return this._color;
    }

    public Object getAttribute(String key) {
        return this._attributeMap.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributeMap.put(key, value);
    }

    public void addAllAttributes(Map<String, Object> map) {
        this._attributeMap.putAll(map);
    }

    public boolean containsAttribute(String attribute) {
        return this._attributeMap.containsKey(attribute);
    }

    public boolean removeAttribute(String key) {
        return this._attributeMap.remove(key) != null;
    }

    public void clear() {
        this._attributeMap.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._key);
        sb.append(" [").append((Object)this._color).append("]");
        return sb.toString();
    }

    public static class DefaultVertexFactory<VK>
    implements VertexFactory<VK, DefaultVertex<VK>> {
        @Override
        public DefaultVertex<VK> createVertex(VK key) {
            return new DefaultVertex<VK>(key);
        }
    }
}

