/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.DependencyManagementHelper;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.repository.common.CommonCommandLine;
import com.oracle.cie.repository.common.RepositoryUtils;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleMerger {
    private static final Logger _log = Logger.getLogger(ModuleMerger.class.getName());

    public static void main(String[] args) {
        int retVal = 0;
        try {
            File[] files;
            Map<String, String> argMap;
            try {
                argMap = RepositoryUtils.parseCommandLineArgs(args);
            }
            catch (RepositoryCommonException e) {
                throw new CommonCommandLine.CommonCommandLineException(e.getMessage(), e);
            }
            if (!argMap.containsKey("-directory")) {
                throw new CommonCommandLine.CommonCommandLineException("Missing required argument: -directory");
            }
            if (!argMap.containsKey("-outputFile") && !argMap.containsKey("-outputRepoDir")) {
                throw new CommonCommandLine.CommonCommandLineException("Missing required argument(s): -outputFile and/or -outputRepoDir");
            }
            String groupId = null;
            String artifactId = null;
            String version = null;
            if (argMap.containsKey("-outputRepoDir")) {
                groupId = argMap.get("-groupId");
                artifactId = argMap.get("-artifactId");
                version = argMap.get("-version");
                if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                    throw new CommonCommandLine.CommonCommandLineException("Missing required argument: -groupId");
                }
                if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
                    throw new CommonCommandLine.CommonCommandLineException("Missing required argument: -artifactId");
                }
                if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                    throw new CommonCommandLine.CommonCommandLineException("Missing required argument: -version");
                }
            }
            File directory = new File(argMap.get("-directory"));
            File outputFile = argMap.containsKey("-outputFile") ? new File(argMap.get("-outputFile")) : null;
            File outputRepoDir = argMap.containsKey("-outputRepoDir") ? new File(argMap.get("-outputRepoDir")) : null;
            DependencyFileType outputType = DependencyFileType.pom;
            if (argMap.containsKey("-outputType")) {
                String type = argMap.get("-outputType");
                try {
                    outputType = DependencyFileType.valueOf((String)type);
                }
                catch (Exception e) {
                    throw new CommonCommandLine.CommonCommandLineException("Unrecognized output type: " + type, e);
                }
            }
            if (!directory.isDirectory()) {
                throw new RepositoryCommonException("The directory specified was not a directory or did not exist: " + directory);
            }
            if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                groupId = "merge.group";
            }
            if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
                artifactId = "merge.name";
            }
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                version = "1.0.0";
            }
            if ((files = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".pom") || name.endsWith(".ivy");
                }
            })) != null && files.length > 0) {
                ArrayList<Module> modules = new ArrayList<Module>();
                for (File f : files) {
                    modules.add(DependencyManagementFactory.getInstance().readDependenciesFile(f, DependencyFileType.pom));
                }
                Module mergedModule = DependencyManagementHelper.mergeModules(modules, (String)groupId, (String)artifactId, (String)version, (String)outputType.name());
                if (outputFile != null) {
                    DependencyManagementFactory.getInstance().getDependencyFileHandler(outputType).writeDependenciesFile(mergedModule, outputFile);
                }
                if (outputRepoDir != null) {
                    File outputRepoFile = mergedModule.getLocalLocation(outputRepoDir);
                    DependencyManagementFactory.getInstance().getDependencyFileHandler(outputType).writeDependenciesFile(mergedModule, outputRepoFile);
                }
            }
        }
        catch (CommonCommandLine.CommonCommandLineException e) {
            System.out.println(e.getMessage());
            ModuleMerger.printUsage();
            retVal = -1;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Module merger failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }

    private static void printUsage() {
        System.out.println("Usage java " + ModuleMerger.class.getName() + " -directory <directory> -outputFile <output-file> -outputType <pom/ivy> -group <module-group-id> -name <module-artifact-name> -version <module-version>");
    }
}

