/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import oracle.opatch.JarActionEntity;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class JarAction
extends JarActionEntity {
    public JarAction(PatchComponent pc, String jarName, String jarPath, String className, int lineNumber) throws NullPointerException, Exception {
        super(pc, jarName, jarPath, className, lineNumber);
    }

    @Override
    public String getActionName() {
        return "JarAction";
    }

    @Override
    public String getActionDesc() {
        return "Jar a file into jar/ear/war.";
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return "Jar the given class file into the jar inside ORACLE_HOME.";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "Jar the backup file into the jar inside ORACLE_HOME.";
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getClassPath();
        String desc = this.getNonApplicableDesc() + "\n" + OLogger.getString("OUI-67153", new Object[]{owningComp, dst, src});
        return desc;
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComp) {
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getJarName());
        String src = this.getClassPath();
        String desc = this.getNonRollbackableDesc() + "\n" + OLogger.getString("OUI-67153", new Object[]{owningComp, dst, src});
        return desc;
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws NullPointerException {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry()");
        OLogger.debug(buff);
        buff = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry(): ");
        buff.append("jarName=\"");
        buff.append(this.getJarName());
        buff.append("\", jarPath=\"");
        buff.append(this.getJarPath());
        buff.append("\", className=\"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        StringBuffer rollbackStr = new StringBuffer("\n");
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry(): ");
            buff.append("Cannot parse the Jar path, jarName=\"");
            buff.append(this.getJarName());
            buff.append("\", jarPath=\"");
            buff.append(this.getJarPath());
            buff.append("\", className=\"");
            buff.append(this.getClassName());
            buff.append("\"");
            OLogger.debug(buff);
            return rollbackStr.toString();
        }
        String[] jarList = this.getJarList();
        String[] jarPathList = this.getJarPathList();
        String[] jarAbsPathList = this.getJarAbsPathList();
        boolean isWindow = OPatchEnv.isWindows();
        StringBuffer jarCommand = null;
        String[] systemCommand = null;
        Path dstClassFile = null;
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getClassName());
        String src = path.toString();
        path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(jarList[0]);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        StringBuffer tmp = new StringBuffer(this.getActionName() + "::getRollbackScriptEntry() extract file \"");
        tmp.append(src);
        tmp.append("\" to jar file ");
        tmp.append(dst);
        tmp.append("\"");
        OLogger.debug(tmp);
        systemCommand = new String[2];
        try {
            for (int i2 = 0; i2 < jarList.length - 1; ++i2) {
                jarCommand = new StringBuffer(OPatchEnv.getJarCommand_ExtractOption());
                if (!jarAbsPathList[i2].equals("")) {
                    jarCommand.append(jarAbsPathList[i2]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(jarList[i2]);
                jarCommand.append(" ");
                if (!jarPathList[i2 + 1].equals("")) {
                    jarCommand.append(this.getJarPathList()[i2 + 1]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(jarList[i2 + 1]);
                systemCommand[0] = jarCommand.toString();
                String runDir = jarAbsPathList[i2];
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
                rollbackStr.append("\n");
            }
            StringBuffer tmpJarPath = new StringBuffer(jarAbsPathList[jarList.length - 1]);
            tmpJarPath.append(File.separator);
            tmpJarPath.append(jarList[jarList.length - 1]);
            dstClassFile = WrapperFactory.getNioServiceWrapper().getPath(tmpJarPath.toString(), new String[0]);
            if (isWindow) {
                rollbackStr.append("copy /Y ");
            } else {
                rollbackStr.append("\\cp -f ");
            }
            rollbackStr.append(srcFile.toString());
            rollbackStr.append(" ");
            rollbackStr.append(dstClassFile.toString());
            for (int i3 = jarList.length - 1; i3 > 0; --i3) {
                jarCommand = new StringBuffer(OPatchEnv.getJarCommand_UpdateOption());
                if (!jarAbsPathList[i3 - 1].equals("")) {
                    jarCommand.append(jarAbsPathList[i3 - 1]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(jarList[i3 - 1]);
                jarCommand.append(" -C ");
                jarCommand.append(jarAbsPathList[i3 - 1]);
                jarCommand.append(" ");
                if (!jarPathList[i3].equals("")) {
                    jarCommand.append(this.getJarPathList()[i3]);
                    jarCommand.append(File.separator);
                }
                jarCommand.append(jarList[i3]);
                systemCommand[0] = jarCommand.toString();
                String runDir = jarAbsPathList[i3 - 1];
                rollbackStr.append("\n");
                rollbackStr.append("cd ");
                rollbackStr.append(runDir);
                rollbackStr.append("\n");
                rollbackStr.append(systemCommand[0]);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        OLogger.debug(new StringBuffer(this.getActionName() + "::getRollbackScriptEntry() done"));
        return rollbackStr.toString();
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 1;
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer(this.getActionName() + "::applicable() ");
        OLogger.debug(buff);
        buff = new StringBuffer("  class name = \"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer("  processJarActionPaths() returns false");
            OLogger.debug(buff);
            buff = new StringBuffer("Jar action could not be processed, hence the action is not applicable.");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        String[] jarList = this.getJarList();
        String src = this.getSourceFile(patchLocation);
        StringBuffer tmpB = new StringBuffer(this.getParentDirPath(oracleHomePath));
        tmpB.append(File.separator);
        tmpB.append(jarList[0]);
        String dst = tmpB.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        buff = new StringBuffer("  checking on source ");
        buff.append(src);
        OLogger.debug(buff);
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer("Jar Action: Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        long srcFileSize = 0L;
        try {
            srcFileSize = Files.size(srcFile);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        if (srcFileSize <= 0L) {
            buff = new StringBuffer("Jar Action: Source File \"");
            buff.append(src);
            buff.append("\" is a zero-byte file");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        buff = new StringBuffer("  checking on destination ");
        buff.append(dst);
        OLogger.debug(buff);
        if (!Files.exists(dstFile, new LinkOption[0]) || !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile)) {
            buff = new StringBuffer("Jar Action: Destination File \"");
            buff.append(dst);
            buff.append("\" does not exists or is not writeable");
            this.setNonApplicableDesc(buff.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuffer buff = new StringBuffer(this.getActionName() + "::rollbackable()");
        OLogger.debug(buff);
        buff = new StringBuffer("  Action details: jarName = \"");
        if (this.getJarName() != null) {
            buff.append(this.getJarName());
        }
        buff.append("\", jarPath = \"");
        if (this.getJarPath() != null) {
            buff.append(this.getJarPath());
        }
        buff.append("\", className = \"");
        if (this.getClassName() != null) {
            buff.append(this.getClassName());
        }
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::rollbackable(): jarName = \"");
            buff.append(this.getJarName());
            buff.append("\", jarPath = \"");
            buff.append(this.getJarPath());
            buff.append("\", className = \"");
            buff.append(this.getClassName());
            buff.append("\", return false.");
            OLogger.debug(buff);
            return false;
        }
        if (this.isBuiltFrom101Home()) {
            String pathJarName = this.getJarPath() + File.separator + this.getJarName();
            String justClassName = this.getClassName().substring(pathJarName.length());
            StringBuffer path = new StringBuffer(oracleHomePath);
            path.append(File.separator);
            path.append(".patch_storage");
            path.append(File.separator);
            path.append(cookedPatchID);
            path.append(File.separator);
            path.append(this.getJarPath());
            path.append(File.separator);
            path.append(justClassName);
            path.append("_");
            path.append(this.getJarName());
            String preFileName = path.toString() + "_pre_" + cookedPatchID;
            Path preF = WrapperFactory.getNioServiceWrapper().getPath(preFileName, new String[0]);
            if (Files.exists(preF, new LinkOption[0])) {
                if (!Files.isReadable(preF)) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is not readable.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
                if (Files.isDirectory(preF, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" is a directory.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
            } else {
                String newFileName = path.toString() + "_opatch_new_" + cookedPatchID;
                Path newF = WrapperFactory.getNioServiceWrapper().getPath(newFileName, new String[0]);
                if (!Files.exists(newF, new LinkOption[0])) {
                    buff = new StringBuffer(this.getActionName() + ":: Source file \"");
                    buff.append(preF.toAbsolutePath().toString());
                    buff.append("\" does not exists.");
                    this.setNonRollbackableDesc(buff.toString());
                    return false;
                }
            }
            return true;
        }
        String psCookedPatchIDPath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        boolean isPSExist = this.checkPatchStorageExist(psCookedPatchIDPath);
        if (!isPSExist) {
            buff = new StringBuffer(this.getActionName() + ":: Directory \"");
            buff.append(WrapperFactory.getNioServiceWrapper().getPath(psCookedPatchIDPath, new String[0]).toAbsolutePath().toString());
            buff.append("\" does not exists or is not readable. ");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        buff = new StringBuffer(this.getActionName() + "::rollbackble() : calling OPatchEnv.getRollbackDirectoryPath()");
        OLogger.debug(buff);
        StringBuffer path = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getClassName());
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : path = \"");
        buff.append(path);
        buff.append("\"");
        OLogger.debug(buff);
        String src = path.toString();
        String parentPath = this.getParentDirPath(oracleHomePath);
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : parentPath = \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        path = new StringBuffer(parentPath);
        path.append(File.separator);
        path.append(this.getJarList()[0]);
        buff = new StringBuffer(this.getActionName() + "::rollbackable() : parentPath changes to \"");
        buff.append(parentPath);
        buff.append("\"");
        OLogger.debug(buff);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(dstFile, new LinkOption[0]) || !Files.isReadable(dstFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Destination file \"");
            buff.append(dst);
            buff.append("\", does not exist or is not readable.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.exists(dstFile, new LinkOption[0]) && Files.isDirectory(dstFile, new LinkOption[0])) {
            buff = new StringBuffer(this.getActionName() + ":: Destination file \"");
            buff.append(dstFile.toAbsolutePath().toString());
            buff.append("\" is a directory.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Source file \"");
            buff.append(src);
            buff.append("\", does not exist or is not readable.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            buff = new StringBuffer(this.getActionName() + ":: Source file \"");
            buff.append(dstFile.toAbsolutePath().toString());
            buff.append("\" is a directory.");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        Path parentFile = srcFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (!Files.exists(parentFile, new LinkOption[0]) || !Files.isReadable(parentFile)) {
            buff = new StringBuffer(this.getActionName() + ":: Cannot mkdirs on \"");
            try {
                buff.append(parentFile.toAbsolutePath().normalize().toString());
            }
            catch (Exception e3) {
                // empty catch block
            }
            buff.append("\".");
            this.setNonRollbackableDesc(buff.toString());
            return false;
        }
        buff = new StringBuffer(this.getActionName() + "::rollbackable() return true");
        OLogger.debug(buff);
        return true;
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof JarAction) {
            String myName = this.getJarName();
            String myPath = this.getJarPath();
            String myClass = this.getClassName();
            JarAction ja = (JarAction)o2;
            String itName = ja.getJarName();
            String itPath = ja.getJarPath();
            String itClass = ja.getClassName();
            if (myName.equals(itName) && myPath.equals(itPath) && myClass.equals(itClass)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getJarName().length();
        result = 37 * result + this.getClassName().length();
        result = 37 * result + this.getJarPath().length();
        return result;
    }
}

