/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.JarActionEntityTree;
import oracle.opatch.JarActionHelper;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.wrappers.WrapperFactory;

public abstract class JarActionEntity
extends OrderedPatchAction
implements Restorable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String jarName;
    private String jarPath;
    private String className;
    private String nonApplicableDesc;
    private String nonRollbackableDesc;
    private String backupForRollbackFailureDesc;
    private String errorMsg;
    private boolean opatchBinary = false;
    private boolean builtFrom101 = false;
    private boolean isAlreadyPatched = false;
    private boolean isDuplicate = false;
    private boolean isTriedToBackUp = false;
    private boolean backupZip = false;
    private String[] jarList;
    private String[] jarPathList;
    private String[] jarAbsPathList;

    public JarActionEntity(PatchComponent pc, String jarName, String jarPath, String className, int lineNumber) throws NullPointerException, Exception {
        super(pc, lineNumber);
        if (jarName == null || jarPath == null || className == null) {
            String errMsg = "The delete jar action is null";
            if (jarName == null) {
                errMsg = errMsg + "The delete jar name is null";
            }
            if (jarPath == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (className == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.jarName = jarName;
        this.jarPath = PatchObjectUtil.filterString(jarPath);
        this.className = PatchObjectUtil.getPlatformDependentPath(className);
    }

    public JarActionEntity(PatchComponent pc, int lineNumber) {
        super(pc, lineNumber);
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public String getClassName() {
        return this.className;
    }

    public String getNonApplicableDesc() {
        return this.nonApplicableDesc;
    }

    protected String getErrorMsg() {
        return this.errorMsg;
    }

    public String[] getJarList() {
        return this.jarList;
    }

    public String[] getJarPathList() {
        return this.jarPathList;
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return this.backupForRollbackFailureDesc;
    }

    @Override
    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::getBackupForRestoreDesc: jarName = \"");
            buff.append(this.getJarName());
            buff.append("\", jarPath = \"");
            buff.append(this.getJarPath());
            buff.append("\", className = \"");
            buff.append(this.getClassName());
            buff.append("\", return false.");
            OLogger.debug(buff);
        }
        buff.append(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getJarList()[0]);
        return buff.toString();
    }

    public String getNonRollbackableDesc() {
        return this.nonRollbackableDesc;
    }

    protected String[] getJarAbsPathList() {
        return this.jarAbsPathList;
    }

    public String getClassPath() {
        String temp = this.getChildPath();
        if (temp != null) {
            temp = temp.substring(1);
            if (File.separator.equals("\\")) {
                temp = temp.replace(File.separatorChar, '/');
            }
            return temp;
        }
        return "";
    }

    protected String getRootJarName() {
        if (this.jarList != null && this.jarList[0] != null) {
            return this.jarList[0];
        }
        return "";
    }

    @Override
    public String getChildPath() {
        String[] tempJarList = this.jarName.split(":");
        String[] tempChildClass = this.className.split(tempJarList[tempJarList.length - 1]);
        String childPath = tempChildClass[tempChildClass.length - 1];
        return childPath;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff;
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            buff = new StringBuffer("ProcessJarActionPaths() returned false");
            OLogger.debug(buff);
        }
        buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        StringBuffer tmpB = new StringBuffer();
        if (oracleHomePath == null) {
            oracleHomePath = "";
        }
        if (oracleHomePath.equals("") || !oracleHomePath.endsWith(File.separator)) {
            tmpB.append(oracleHomePath);
        }
        if (oracleHomePath.endsWith(File.separator)) {
            tmpB.append(oracleHomePath.substring(0, oracleHomePath.length()));
        }
        if (!this.jarPath.startsWith(File.separator)) {
            tmpB.append(File.separator);
            tmpB.append(this.jarPath);
        } else {
            tmpB.append(this.jarPath);
        }
        return tmpB.toString();
    }

    public String getSourceFile(String patchPath) {
        if (patchPath == null) {
            patchPath = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchPath);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.className);
        return buff.toString();
    }

    public String getCompleteFileListPath(String oracleHomePath) {
        if (!this.initializeJarListJarPathList(oracleHomePath, this.jarName, this.jarPath, this.className)) {
            StringBuffer buff = new StringBuffer("ProcessJarActionPaths() returned false");
            OLogger.debug(buff);
            return "";
        }
        StringBuffer buff = new StringBuffer(this.getParentFilePath(oracleHomePath));
        for (int i2 = 1; i2 < this.jarList.length - 1; ++i2) {
            buff.append(":");
            if (!this.jarPathList[i2].equals("") && !this.jarPathList[i2].startsWith(File.separator)) {
                buff.append(File.separator);
            }
            buff.append(this.jarPathList[i2]);
            if (!(this.jarList[i2].startsWith(File.separator) || !this.jarPathList[i2].equals("") && this.jarPathList[i2].endsWith(File.separator))) {
                buff.append(File.separator);
            }
            buff.append(this.jarList[i2]);
        }
        OLogger.debug(new StringBuffer(this.getActionName() + "::getCompleteFileListPath() returns :" + buff.toString()));
        return buff.toString();
    }

    @Override
    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getChildPath(), this.getCompleteFileListPath(oracleHomePath)};
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    @Override
    public long getSpaceNeeded(String patchLocation) {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(this.getSourceFile(patchLocation), new String[0]);
        if (Files.exists(f2, new LinkOption[0]) && !patchLocation.isEmpty()) {
            try {
                return Files.size(f2);
            }
            catch (IOException e2) {
                OLogger.debug("Cannot get file size. " + f2.toAbsolutePath().toString());
            }
        }
        return 0L;
    }

    public boolean isMultiLevel() {
        return this.jarName.indexOf(":") != -1;
    }

    protected boolean isAlreadyPatched() {
        return this.isAlreadyPatched;
    }

    public boolean isOPatchBinary() {
        return this.opatchBinary;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public boolean isBackupZip() {
        return this.backupZip;
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return false;
    }

    protected boolean isTriedToBackUp() {
        return this.isTriedToBackUp;
    }

    protected boolean isBuiltFrom101Home() {
        return this.builtFrom101;
    }

    public void setBuiltFrom101Home(boolean value) {
        this.builtFrom101 = value;
    }

    public void setAlreadyPatched(boolean value) {
        this.isAlreadyPatched = value;
    }

    public void setTriedToBackUp(boolean value) {
        this.isTriedToBackUp = true;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setOPatchBinary(boolean value) {
        this.opatchBinary = value;
    }

    public void setDuplicate(boolean value) {
        this.isDuplicate = value;
    }

    public void setBackupZip(boolean backupZip) {
        this.backupZip = backupZip;
    }

    public void setBackupForRollbackDesc(String msg) {
        this.backupForRollbackFailureDesc = msg;
    }

    public void setNonApplicableDesc(String string) {
        this.nonApplicableDesc = string;
    }

    public void setNonRollbackableDesc(String string) {
        this.nonRollbackableDesc = string;
    }

    protected boolean initializeJarListJarPathList(String oracleHomePath, String jarName, String jarPath, String className) {
        StringBuffer ap;
        StringBuffer buff = new StringBuffer(this.getActionName() + "::processJarActionPaths()");
        OLogger.debug(buff);
        String[] tempJarList = jarName.split(":");
        String[] tempPathList = new String[tempJarList.length];
        String[] tempAbsPathList = new String[tempJarList.length];
        StringBuffer tmpB = null;
        if (tempJarList == null || tempJarList.length == 0) {
            buff = new StringBuffer(this.getActionName() + "::processJarActionPaths(): tempJarList is NULL or zero, return false");
            OLogger.debug(buff);
            return false;
        }
        if (tempJarList.length > 0) {
            int i2;
            tempPathList[0] = this.getParentDirPath(oracleHomePath);
            tempAbsPathList[0] = this.getParentDirPath(oracleHomePath);
            String tmpClass = className;
            for (i2 = 0; i2 < tempJarList.length; ++i2) {
                tmpB = new StringBuffer(tempJarList[i2]);
                int lindex = tmpClass.indexOf(tmpB.toString());
                if (lindex == -1 || tmpClass.equals("")) {
                    buff = new StringBuffer(this.getActionName() + "::processJarActionPaths(): Can't find substring \"");
                    buff.append(tmpB.toString());
                    buff.append("\" inside \"");
                    buff.append(tmpClass);
                    buff.append("\"");
                    buff.append(" or className is blank string. ");
                    OLogger.debug(buff);
                    return false;
                }
                String[] tmpPath = new String[2];
                tmpPath[0] = tmpClass.substring(0, lindex);
                if (tmpPath[0].endsWith(File.separator)) {
                    tmpPath[0] = tmpPath[0].length() > 1 ? tmpPath[0].substring(0, tmpPath[0].length() - 1) : "";
                }
                tmpPath[1] = tmpClass.substring(lindex + tmpB.toString().length());
                if (tmpPath.length <= 1) {
                    buff = new StringBuffer(this.getActionName() + "::processJarActionPaths(): tmpPath length is <= 1, return false");
                    OLogger.debug(buff);
                    return false;
                }
                if (i2 == 0) {
                    tmpClass = tmpPath[1];
                    continue;
                }
                tempPathList[i2] = tmpPath[0];
                StringBuffer ap2 = new StringBuffer(tempAbsPathList[i2 - 1]);
                ap2.append(File.separator);
                ap2.append(tempPathList[i2]);
                tempAbsPathList[i2] = ap2.toString();
                tmpClass = tmpPath[1];
            }
            this.jarList = new String[tempJarList.length + 1];
            this.jarPathList = new String[tempJarList.length + 1];
            this.jarAbsPathList = new String[tempJarList.length + 1];
            for (i2 = 0; i2 < tempJarList.length; ++i2) {
                this.jarList[i2] = tempJarList[i2];
                this.jarPathList[i2] = tempPathList[i2];
                this.jarAbsPathList[i2] = tempAbsPathList[i2];
            }
            int lindex = tmpClass.lastIndexOf(File.separator);
            this.jarList[tempJarList.length] = tmpClass.substring(lindex + 1);
            this.jarPathList[tempJarList.length] = lindex >= 0 ? tmpClass.substring(0, lindex) : "";
            ap = new StringBuffer(this.jarAbsPathList[tempJarList.length - 1]);
            if (!this.jarPathList[tempJarList.length].equals("")) {
                ap.append(File.separator);
                ap.append(this.jarPathList[tempJarList.length]);
            }
        } else {
            buff = new StringBuffer(this.getActionName() + "::processJarActionPaths(): tempJarList is <= zero, return false");
            OLogger.debug(buff);
            return false;
        }
        this.jarAbsPathList[tempJarList.length] = ap.toString();
        buff = new StringBuffer(this.getActionName() + "::processJarActionPaths(): return true for successful parsing Jar path");
        OLogger.debug(buff);
        return true;
    }

    @Override
    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String[] filesList = new String[]{};
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            return filesList;
        }
        if (this.jarPathList.length > 0) {
            filesList = new String[this.jarPathList.length];
            for (int i2 = 0; i2 < this.jarPathList.length; ++i2) {
                StringBuffer tmpS = new StringBuffer(this.jarPathList[i2]);
                tmpS.append(File.separator);
                tmpS.append(this.jarList[i2]);
                filesList[i2] = tmpS.toString();
            }
        }
        return filesList;
    }

    public static void dumpJarEntry(JarFile f2) {
        if (f2 != null) {
            StringBuffer buff = new StringBuffer("JarFile \"");
            buff.append(f2.getName());
            buff.append("\":");
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            Enumeration<JarEntry> entries = f2.entries();
            while (entries.hasMoreElements()) {
                JarEntry obj = entries.nextElement();
                if (!(obj instanceof JarEntry)) continue;
                JarEntry je = obj;
                String name = je.getName();
                buff = new StringBuffer(" \"");
                buff.append(name);
                buff.append("\"");
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            }
        }
    }

    public HashMap backupForRollback(String oracleHomePath, String cookedPatchID, PatchObject po) throws RuntimeException {
        int i2;
        if (this.getPatchObject().isNotRollBackable()) {
            StringBuffer buff = new StringBuffer(this.getActionName() + "::backupForRollback() not done because the patch is not rollbackable");
            OLogger.debug(buff);
            return new HashMap();
        }
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        OLogger.printlnOnLogAndVerbose("Going to backup for rollback Jar Action(s) in a consolidated mode.");
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionEntityTree.TreeNode curNode = new JarActionEntityTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        ArrayList childs = JarActionEntityTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (i2 = 0; i2 < childs.size(); ++i2) {
            JarActionEntityTree.TreeNode topLevelNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.BACKUPFORROLLBACK, false, "");
            break;
        }
        OLogger.printlnOnLogAndVerbose("--- Clubbed Actions for this Jar Path to backup for rollback NOW -> ");
        for (i2 = 0; i2 < myList.size(); ++i2) {
            JarActionEntity ja = (JarActionEntity)myList.get(i2);
            OLogger.justlog(OLogger.INFO, ja.getChildPath());
        }
        OLogger.logTime(new StringBuffer("Backup For Rollback starts for the clubbed jars at --> "));
        HashMap failedMap = this.backupForRollBack(oracleHomePath, cookedPatchID, this);
        OLogger.logTime(new StringBuffer("Backup For Rollback ends for the clubbed jars at ---> "));
        OLogger.printlnOnLog("");
        return failedMap;
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        if (JarActionEntityTree.getRoot().isLeaf()) {
            JarActionEntityTree.addJarActionNodes(oracleHomePath, this, JarActionEntityTree.getRoot());
        }
        this.backupForRollback(oracleHomePath, cookedPatchID, new PatchObject());
        JarActionEntityTree.getRoot().setChilds(null);
    }

    @Override
    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::backupForRestore()");
        OLogger.debug(buff);
        buff = new StringBuffer(this.getActionName() + "::backupForRestore(): ");
        buff.append("jarName=\"");
        buff.append(this.getJarName());
        buff.append("\", jarPath=\"");
        buff.append(this.getJarPath());
        buff.append("\", className=\"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::backupForRestore(): ");
            buff.append("Cannot parse the Jar path, jarName=\"");
            buff.append(this.getJarName());
            buff.append("\", jarPath=\"");
            buff.append(this.getJarPath());
            buff.append("\", className=\"");
            buff.append(this.getClassName());
            buff.append("\"");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        StringBuffer path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.jarList[0]);
        String src = path.toString();
        path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getJarPath());
        path.append(File.separator);
        path.append(this.jarList[0]);
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer(this.getActionName() + "::backupForRestore(): source file \"");
            buff.append(src);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        buff = new StringBuffer(this.getActionName() + "::backupForRestore(): copy file from \"");
        buff.append(src);
        buff.append("\" to \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        SystemCall.backupFile(srcFile, dstFile);
    }

    @Override
    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        Path dstFile;
        StringBuffer buff = new StringBuffer(this.getActionName() + "::restorable()");
        OLogger.debug(buff);
        buff = new StringBuffer("  Action details: jarName = \"");
        buff.append(this.getJarName());
        buff.append("\", jarPath = \"");
        buff.append(this.getJarPath());
        buff.append("\", className = \"");
        buff.append(this.getClassName());
        buff.append("\"");
        OLogger.debug(buff);
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            buff = new StringBuffer(this.getActionName() + "::restorable(): jarName = \"");
            buff.append(this.getJarName());
            buff.append("\", jarPath = \"");
            buff.append(this.getJarPath());
            buff.append("\", className = \"");
            buff.append(this.getClassName());
            buff.append("\", return false.");
            OLogger.debug(buff);
            return false;
        }
        StringBuffer path = new StringBuffer(this.getParentDirPath(oracleHomePath));
        path.append(File.separator);
        path.append(this.jarList[0]);
        String src = path.toString();
        path = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        path.append(File.separator);
        path.append(this.getJarPath());
        path.append(File.separator);
        path.append(this.getJarName());
        String dst = path.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        if (OPatchEnv.isWindows()) {
            String dstFileStr = dst;
            String[] nestedJarFiles = dst.split(":");
            if (nestedJarFiles.length > 2) {
                dstFileStr = nestedJarFiles[0] + ":" + nestedJarFiles[1];
            }
            dstFile = WrapperFactory.getNioServiceWrapper().getPath(dstFileStr, new String[0]);
        } else {
            dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        }
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile) || Files.isDirectory(srcFile, new LinkOption[0])) {
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        return Files.exists(parentFile, new LinkOption[0]) && Files.isWritable(parentFile);
    }

    @Override
    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        if (!this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName())) {
            return;
        }
        StringBuffer buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, sessionID));
        buff.append(File.separator);
        buff.append(this.getJarPath());
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        String src = buff.toString();
        buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.getRootJarName());
        String dst = buff.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        try {
            if (Files.exists(srcFile, new LinkOption[0]) && Files.isReadable(srcFile)) {
                SystemCall.backupFile(srcFile, dstFile);
            }
        }
        catch (RuntimeException e2) {
            OLogger.warn("OUI-67004", new Object[]{dstFile.toString(), srcFile.toString(), e2.getMessage()});
        }
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuilder msg1 = new StringBuilder();
        msg1.append(this.getParentFilePath(oracleHomePath));
        String msg1Str = msg1.toString();
        if (!this.getActionName().equals("JarAction") && this.getActionName().equals("DeleteJarAction")) {
            OLogger.onlyLogInfo("OUI-69301", new Object[]{msg1Str, this.getClassName()});
        }
        if (this.isDuplicate() || this.isAlreadyPatched() || !this.isAppliedOK()) {
            return;
        }
        OLogger.printlnOnLogAndVerbose("Going to patch Jar Action(s) in a consolidated mode.");
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionEntityTree.TreeNode curNode = new JarActionEntityTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        boolean calledDirectly = JarActionEntityTree.getRoot().isLeaf();
        if (calledDirectly) {
            JarActionEntityTree.addJarActionNodes(oracleHomePath, this, JarActionEntityTree.getRoot());
        }
        ArrayList childs = JarActionEntityTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            JarActionEntityTree.TreeNode topLevelNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.APPLY, false, "");
            break;
        }
        OLogger.logTime(new StringBuffer("Apply starts for the clubbed jars at --> "));
        HashMap failedMap = JarActionHelper.apply(oracleHomePath, patchLocation, this);
        OLogger.logTime(new StringBuffer("Apply ends for the clubbed jars at --> "));
        OLogger.printlnOnLog("");
        if (calledDirectly) {
            JarActionEntityTree.getRoot().setChilds(null);
        }
        Iterator keys = failedMap.keySet().iterator();
        StringBuffer msg = new StringBuffer();
        while (keys.hasNext()) {
            String className = keys.next().toString();
            JarActionEntity ja = (JarActionEntity)failedMap.get(className);
            msg.append(OLogger.getString("OUI-67203", new Object[]{ja.getSourceFile(patchLocation), dst.toString(), ja.getErrorMsg()}) + "\n");
        }
        if (msg.length() > 0) {
            throw new RuntimeException(msg.toString());
        }
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        if (this.isOPatchBinary()) {
            oracleHomePath = OPatchEnv.getOracleHome();
        }
        StringBuilder tmpB = new StringBuilder(this.getActionName() + "::rollback()");
        tmpB.append(" executes Jar line ");
        tmpB.append(this.getLineNumber());
        OLogger.debug(tmpB.toString());
        StringBuffer fileToRollbackFrom = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        fileToRollbackFrom.append(File.separator);
        fileToRollbackFrom.append(this.getClassName());
        String fileToRollbackFromStr = fileToRollbackFrom.toString();
        if (!this.getActionName().equals("JarAction") && this.getActionName().equals("DeleteJarAction")) {
            OLogger.onlyLogInfo("OUI-69301", new Object[]{this.getParentFilePath(oracleHomePath), fileToRollbackFromStr});
        }
        if (this.isDuplicate() || this.isAlreadyPatched() || !this.isRollbackOK()) {
            return;
        }
        StringBuffer dst = new StringBuffer(oracleHomePath);
        dst.append(File.separator);
        dst.append(this.getJarPath());
        dst.append(File.separator);
        dst.append(this.getRootJarName());
        OLogger.printlnOnLogAndVerbose("Jar Path -> " + dst.toString());
        String curJarPath = this.getJarPath();
        if (!curJarPath.startsWith(File.separator)) {
            curJarPath = File.separator + curJarPath;
        }
        JarActionEntityTree.TreeNode curNode = new JarActionEntityTree.TreeNode(0, this.getRootJarName(), curJarPath, null);
        boolean calledDirectly = JarActionEntityTree.getRoot().isLeaf();
        if (calledDirectly) {
            JarActionEntityTree.addJarActionNodes(oracleHomePath, this, JarActionEntityTree.getRoot());
        }
        ArrayList childs = JarActionEntityTree.getRoot().getChilds();
        ArrayList myList = new ArrayList();
        for (int i2 = 0; i2 < childs.size(); ++i2) {
            JarActionEntityTree.TreeNode topLevelNode = (JarActionEntityTree.TreeNode)childs.get(i2);
            if (!topLevelNode.equals(curNode)) continue;
            MultiJarUtil.getAllLeavesForNode(topLevelNode, myList, MultiJarUtil.JarOperation.ROLLBACK, false, "");
            break;
        }
        String rollbackPatchLocation = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        OLogger.logTime(new StringBuffer("Rollback starts for the clubbed jars at --> "));
        HashMap failedMap = JarActionHelper.rollback(oracleHomePath, cookedPatchID, this);
        OLogger.logTime(new StringBuffer("Rollback ends for the clubbed jars at --> "));
        OLogger.printlnOnLog("");
        if (calledDirectly) {
            JarActionEntityTree.getRoot().setChilds(null);
        }
        Iterator keys = failedMap.keySet().iterator();
        StringBuffer msg = new StringBuffer();
        while (keys.hasNext()) {
            String className = keys.next().toString();
            JarActionEntity ja = (JarActionEntity)failedMap.get(className);
            fileToRollbackFrom = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            fileToRollbackFrom.append(File.separator);
            fileToRollbackFrom.append(ja.getClassName());
            msg.append(OLogger.getString("OUI-67202", new Object[]{fileToRollbackFrom.toString(), dst.toString(), ja.getErrorMsg()}) + "\n");
        }
        if (msg.length() > 0) {
            throw new RuntimeException(msg.toString());
        }
    }

    @Override
    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        if (JarActionEntityTree.getRoot().isLeaf()) {
            JarActionEntityTree.addJarActionNodes(oracleHomePath, this, JarActionEntityTree.getRoot());
        }
        HashMap failed = JarActionHelper.verify(oracleHomePath, patchLocation);
        JarActionEntityTree.getRoot().setChilds(null);
        return failed.size() <= 0;
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getActionName() + "::conflictDetectable()  ");
        boolean tmpB = this.initializeJarListJarPathList(oracleHomePath, this.getJarName(), this.getJarPath(), this.getClassName());
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    private HashMap backupForRollBack(String oracleHomePath, String cookedPatchID, JarActionEntity jarAction) {
        int i2;
        StringBuffer buff = new StringBuffer("JarActionEntity::backupForRollBack() called");
        OLogger.debug(buff.toString());
        ArrayList failedActions = new ArrayList();
        HashMap<String, JarActionEntity> failedMap = new HashMap<String, JarActionEntity>();
        JarActionEntityTree.TreeNode root = JarActionEntityTree.getRoot();
        if (root == null || root.isLeaf()) {
            return failedMap;
        }
        ArrayList topLevelJars = root.getChilds();
        for (i2 = 0; i2 < topLevelJars.size(); ++i2) {
            JarActionEntityTree.TreeNode backupNode;
            JarActionEntityTree.TreeNode tn = (JarActionEntityTree.TreeNode)topLevelJars.get(i2);
            String curJarPath = jarAction.getJarPath();
            if (!curJarPath.startsWith(File.separator)) {
                curJarPath = File.separator + curJarPath;
            }
            if (!(backupNode = new JarActionEntityTree.TreeNode(0, jarAction.getRootJarName(), curJarPath, null)).equals(tn)) continue;
            try {
                String jarName = tn.getJarName();
                String jarPath = tn.getJarPath();
                String patchingJarFilePath = JarActionHelper.getTopLevelJarFilePath(oracleHomePath, jarPath, jarName);
                Path srcJar = WrapperFactory.getNioServiceWrapper().getPath(patchingJarFilePath, new String[0]);
                if (!Files.exists(srcJar, new LinkOption[0])) {
                    buff = new StringBuffer("backupForRollBack() failed. Parent file not exist: \"");
                    buff.append(patchingJarFilePath);
                    buff.append("\"");
                    OLogger.printlnOnLog(buff.toString());
                    throw new IOException(buff.toString());
                }
                String scratchLocation = OPatchEnv.getPatchScratchDirectoryPath(oracleHomePath, cookedPatchID);
                String backForRollBackPath = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
                MultiJarUtil.backUpForRollbackBaseOnJarTree(tn, patchingJarFilePath, backForRollBackPath, scratchLocation, "", failedActions);
            }
            catch (IOException e2) {
                buff = new StringBuffer("backupForRollback for Jar file \"ORACLE_HOME" + File.separator);
                buff.append(tn.getEntryName());
                buff.append("\" failed");
                buff.append(e2.getMessage());
                OLogger.printlnOnLog(buff.toString());
                MultiJarUtil.getAllLeavesForNode(tn, failedActions, MultiJarUtil.JarOperation.BACKUPFORROLLBACK, true, e2.getMessage());
            }
            break;
        }
        for (i2 = 0; i2 < failedActions.size(); ++i2) {
            JarActionEntity ja = (JarActionEntity)failedActions.get(i2);
            failedMap.put(ja.getClassName(), ja);
        }
        return failedMap;
    }

    public String toString() {
        int i2;
        String[] jarList = this.getJarList();
        String[] jarPathList = this.getJarPathList();
        String[] jarAbsPathList = this.getJarAbsPathList();
        StringBuffer buff = new StringBuffer();
        buff.append("[" + this.getActionName() + ": jarName=\"");
        buff.append(this.getJarName());
        buff.append("\", path=\"");
        buff.append(this.getJarPath());
        buff.append("\", className=\"");
        buff.append(this.getClassName());
        buff.append("\", lineNumber=\"");
        buff.append(this.lineNumber);
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", childPath=\"");
        buff.append(this.getChildPath());
        buff.append("\", classPath=");
        buff.append(this.getClassPath());
        buff.append("\", jarList=\"");
        if (jarList == null) {
            buff.append("NULL jarList");
        } else {
            for (i2 = 0; i2 < jarList.length; ++i2) {
                buff.append("'");
                buff.append(jarList[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", jarAbsPathList=\"");
        if (jarAbsPathList == null) {
            buff.append("NULL jarAbsPathList");
        } else {
            for (i2 = 0; i2 < jarAbsPathList.length; ++i2) {
                buff.append("'");
                buff.append(jarAbsPathList[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", jarPathList=\"");
        if (jarPathList == null) {
            buff.append("NULL jarPathList");
        } else {
            for (i2 = 0; i2 < jarPathList.length; ++i2) {
                buff.append("'");
                buff.append(this.getJarPathList()[i2]);
                buff.append("', ");
            }
        }
        buff.append("\", sourcePath=\"");
        buff.append(this.getSourceFile("%patch_path%"));
        buff.append("\" opatchBinary=\"");
        buff.append(this.isOPatchBinary());
        buff.append("\" rawJarAction=\" ");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }
}

