/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.opatch.ConfigureOCMState;
import oracle.opatch.InstallOCMState;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchState;
import oracle.opatch.PatchObject;
import oracle.opatch.RACPropagationState;
import oracle.opatch.ioc.IOC;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;

public class OPatchStateManager {
    protected String managerName;
    protected Map<Integer, OPatchState> stateMap;
    protected static int currentStatePtr;
    protected String patchLoc;
    protected int stateNum;
    protected String errorMsg = null;
    protected boolean disabled = false;

    public OPatchStateManager(String patchLoc, String managerName) {
        this.managerName = managerName;
        this.stateMap = new HashMap<Integer, OPatchState>();
        currentStatePtr = 0;
        this.patchLoc = patchLoc;
    }

    public OPatchStateManager(String managerName) {
        this.managerName = managerName;
        this.stateMap = new HashMap<Integer, OPatchState>();
        currentStatePtr = 0;
    }

    public void insertStateEntry(OPatchState state) {
        this.stateMap.put(this.stateNum++, state);
    }

    public void disable() {
        this.disabled = true;
    }

    public void enable() {
        this.disabled = false;
    }

    public void setCurrentState(String stateName) {
        this.setCurrentState(stateName, true);
    }

    public void setCurrentState(String stateName, boolean log) {
        if (this.disabled) {
            return;
        }
        try {
            for (int i2 = 0; i2 < this.stateNum; ++i2) {
                if (!this.stateMap.get(i2).getStateName().equalsIgnoreCase(stateName) || !this.stateMap.get(i2).isPresent()) continue;
                currentStatePtr = i2;
                if (!log) break;
                if (!(OPatchEnv.getConsoleLogLevel() != 0 || Boolean.valueOf(OPatchACL.invokeOLogger(this, "isDebug", null).toString()).booleanValue() || OPatchEnv.isVerbose() || OPatchEnv.isOPatchSDKMode())) {
                    OPatchACL.invokeOLogger(this, "setLogLevel", new Object[]{this.stateMap.get(currentStatePtr).getDefaultLogLevel()});
                    OPatchACL.invokeOLogger(this, "setCurrentLogLevel", new Object[]{this.stateMap.get(currentStatePtr).getDefaultLogLevel()});
                }
                if (OPatchEnv.getFileLogLevel() == 0 && !Boolean.valueOf(OPatchACL.invokeOLogger(this, "isDebug", null).toString()).booleanValue() && !OPatchEnv.isVerbose()) {
                    OPatchACL.invokeOLogger(this, "setLogFileLevel", new Object[]{this.stateMap.get(currentStatePtr).getDefaultLogLevel()});
                }
                if (this.stateMap.get(currentStatePtr).getStateOrder() != 0 && this.stateMap.get(currentStatePtr).isPresent()) {
                    OLogger.justlog(OLogger.INFO, "\n--------------------- " + this.stateMap.get(currentStatePtr).getStateName() + " ---------------------\n");
                }
                try {
                    ResourceBundle rb = ResourceBundle.getBundle("oracle.opatch.OPatchErrorCodeErrorMsgRes", Locale.getDefault());
                    this.errorMsg = rb.getString(this.stateMap.get(currentStatePtr).getBaseErrorCode() + "");
                    break;
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        }
        catch (IllegalAccessException e3) {
            RuntimeException rt = new RuntimeException(e3.getMessage());
            rt.setStackTrace(e3.getStackTrace());
            throw rt;
        }
    }

    public OPatchState getCurrentState() {
        return this.stateMap.get(currentStatePtr);
    }

    public void setErrorCode(int errorCode) {
        if (this.disabled) {
            return;
        }
        this.stateMap.get(currentStatePtr).setCurrentErrorCode(errorCode);
    }

    public void setErrorCode(int errorCode, Object[] objects) {
        if (this.disabled) {
            return;
        }
        this.stateMap.get(currentStatePtr).setCurrentErrorCode(errorCode);
    }

    public int getErrorCode() {
        return this.stateMap.get(currentStatePtr).getCurrentErrorCode();
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public void printMandatoryStates(String oracleHomePath, PatchObject[] patchObject) {
        this.printMandatoryStates(oracleHomePath, patchObject, true);
    }

    public void printMandatoryStates(String oracleHomePath, PatchObject[] patchObject, boolean logOnly) {
        if (this.disabled) {
            return;
        }
        StringBuffer buff = new StringBuffer("");
        int outputLength = 0;
        if (!this.managerName.equals("")) {
            int i2;
            buff.append("OPatch will do the following:");
            for (i2 = 0; i2 < this.stateNum; ++i2) {
                if (!this.stateMap.get(i2).isMandatory()) continue;
                this.stateMap.get(i2).setPresent(patchObject);
                if (this.stateMap.get(i2).getStateName().length() <= outputLength || !this.stateMap.get(i2).isPresent()) continue;
                outputLength = this.stateMap.get(i2).getStateName().length();
            }
            if (logOnly) {
                OLogger.printlnOnLog(buff.toString());
            } else {
                OLogger.println(buff.toString());
            }
            outputLength += 3;
            for (i2 = 0; i2 < this.stateNum; ++i2) {
                buff = new StringBuffer("");
                if (this.stateMap.get(i2).isMandatory() && this.stateMap.get(i2).isPresent() && !this.stateMap.get(i2).getStateName().equals("")) {
                    int spaceLength = outputLength - this.stateMap.get(i2).getStateName().length();
                    buff.append("[" + this.stateMap.get(i2).getStateName() + "]" + OPatchEnv.getSpaceString(spaceLength) + ": ");
                    String stateAssociateMessage = this.stateMap.get(i2).getStateAssociatedMessage(oracleHomePath, patchObject);
                    buff.append(stateAssociateMessage.trim().replaceAll("\n", "\n" + OPatchEnv.getSpaceString(outputLength + 4)));
                }
                if (buff.toString().trim().length() == 0) continue;
                if (logOnly) {
                    OLogger.printlnOnLog(buff.toString().trim());
                    continue;
                }
                if (this.stateMap.get(i2).isVisible()) {
                    OLogger.println(buff.toString().trim());
                    continue;
                }
                OLogger.printlnOnLog(buff.toString().trim());
            }
            if (logOnly) {
                OLogger.printlnOnLog("");
            } else {
                OLogger.println("");
            }
        }
    }

    public void printFollowingStates(String oracleHomePath, PatchObject[] patchObject, IIPMReadServices readServices) {
        this.printFollowingStates(oracleHomePath, patchObject, readServices, true);
    }

    public void printFollowingStates(String oracleHomePath, PatchObject[] patchObject, IIPMReadServices readServices, boolean logOnly) {
        if (this.disabled) {
            return;
        }
        StringBuffer buff = new StringBuffer("");
        int outputLength = 0;
        if (!this.managerName.equals("")) {
            int i2;
            buff.append("To continue, OPatch will do the following:\n");
            for (i2 = 0; i2 < this.stateNum; ++i2) {
                this.stateMap.get(i2).setPresent(patchObject);
                if (!IOC.INSTANCE.isInventoryConverted()) {
                    if (this.stateMap.get(i2) instanceof RACPropagationState) {
                        ((RACPropagationState)this.stateMap.get(i2)).setPresentForRac(patchObject, readServices);
                    }
                    if (this.stateMap.get(i2) instanceof InstallOCMState) {
                        ((InstallOCMState)this.stateMap.get(i2)).setPresentForOCM(patchObject, readServices);
                    }
                    if (this.stateMap.get(i2) instanceof ConfigureOCMState) {
                        ((ConfigureOCMState)this.stateMap.get(i2)).setPresentForOCM(patchObject, readServices);
                    }
                }
                if (this.stateMap.get(i2).isMandatory() || !this.stateMap.get(i2).isPresent() || this.stateMap.get(i2).getStateName().length() <= outputLength) continue;
                outputLength = this.stateMap.get(i2).getStateName().length();
            }
            outputLength += 3;
            for (i2 = 0; i2 < this.stateNum; ++i2) {
                if (this.stateMap.get(i2).isMandatory() || !this.stateMap.get(i2).isPresent() || !this.stateMap.get(i2).isVisible() || this.stateMap.get(i2).getStateName().equals("")) continue;
                int spaceLength = outputLength - this.stateMap.get(i2).getStateName().length();
                buff.append("[" + this.stateMap.get(i2).getStateName() + "]" + OPatchEnv.getSpaceString(spaceLength) + ": ");
                String stateAssociateMessage = this.stateMap.get(i2).getStateAssociatedMessage(oracleHomePath, patchObject);
                buff.append(stateAssociateMessage.trim().replaceAll("\n", "\n" + OPatchEnv.getSpaceString(outputLength + 4)) + "\n");
            }
            if (logOnly) {
                OLogger.printlnOnLog(buff.toString());
            } else {
                OLogger.println(buff.toString());
            }
        }
    }

    public void returnToNonChangeState() {
        if (this.disabled) {
            return;
        }
        currentStatePtr = 0;
    }
}

