/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatch.PatchObject;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

class PartialPatchObject
extends PatchObject {
    public static final String BAPTA_PSE = "BAPTA_PSE";
    public static final String BAPTA_BUGS = "BAPTA_BUGS";
    public static final String BAPTA_FILES = "BAPTA_FILES";
    public static final String[] REQUIRE_BAPTA_KEYS = new String[]{"BAPTA_PSE", "BAPTA_BUGS", "BAPTA_FILES"};
    public static final String DATA_SEPARATOR = ",";
    public static final String KEY_SEPARATOR = ":";
    public static final String FILE_SEPARATOR = "/";
    public static final String COMPOSITE_SEPARATOR = ":";
    private static boolean READY = false;
    private String PSE;
    private String[] FILES_TOUCHED;
    private String[] BUGS_FIXED;
    private ArrayList FILE_CONTENT = new ArrayList();
    private String[] COPY_FILES_TOUCHED;
    private String[] ARCHIVE_FILES_TOUCHED;
    private String[] JAR_FILES_TOUCHED;
    public static final String OBJ_EXT = ".o";
    public static final String CLASS_EXT = ".class";
    StringBuffer buff;
    public static final String COMPONENT = "oracle.server";
    public static final String COMPONENT_VERSION = "12.0";
    private StringBuffer INV_ENTRY = new StringBuffer();
    private StringBuffer ACTION_ENTRY = new StringBuffer();
    private static StringBuffer MAKE_ENTRY = new StringBuffer();

    public PartialPatchObject() {
    }

    public PartialPatchObject(String patchLocation) throws Exception {
        super(patchLocation);
    }

    public void loadBaptaFile(String fileLoc) throws IOException {
        if (fileLoc == null) {
            throw new IOException("Given fileLoc is NULL");
        }
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            this.buff = new StringBuffer("File not exist: \"");
            this.buff.append(fileLoc).append("\"");
            throw new IOException(this.buff.toString());
        }
        if (!this.isBaptaFile(fileLoc)) {
            this.buff = new StringBuffer("File \"").append(fileLoc);
            this.buff.append("\" is not in BAPTA format which must have all ");
            for (int i2 = 0; i2 < REQUIRE_BAPTA_KEYS.length; ++i2) {
                this.buff.append(REQUIRE_BAPTA_KEYS[i2]).append(" ");
            }
            this.buff.append("keys.");
            throw new IOException(this.buff.toString());
        }
        String[] bugs = null;
        String[] files = null;
        String pse = null;
        Properties prop = new Properties();
        InputStream ins = Files.newInputStream(f2, new OpenOption[0]);
        prop.load(ins);
        Enumeration<?> en = prop.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String values = prop.getProperty(key);
            if (key.equals(BAPTA_PSE)) {
                pse = values;
                continue;
            }
            if (key.equals(BAPTA_BUGS)) {
                bugs = this.parseCommaList(values);
                continue;
            }
            if (!key.equals(BAPTA_FILES)) continue;
            files = this.parseCommaList(values);
        }
        this.buildCopyArchiveJarFile(files);
        this.FILES_TOUCHED = files;
        this.BUGS_FIXED = bugs;
        this.PSE = pse;
        this.buildInventory(this.PSE, this.BUGS_FIXED);
        this.buildAction(this.COPY_FILES_TOUCHED, this.ARCHIVE_FILES_TOUCHED, this.JAR_FILES_TOUCHED);
        READY = true;
    }

    public void createPatchMetadata(String fileLoc) throws IOException {
        if (!READY) {
            this.buff = new StringBuffer("This partial patch object has not been ");
            this.buff.append("properly intialized.");
            throw new IOException(this.buff.toString());
        }
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]);
        if (!Files.exists(f2, new LinkOption[0]) || !Files.isDirectory(f2, new LinkOption[0])) {
            this.buff = new StringBuffer("Directory \"").append(fileLoc);
            this.buff.append("\" doesn't exist or is not a directory.");
            throw new IOException(this.buff.toString());
        }
        if (!fileLoc.endsWith("oneoffs")) {
            this.buff = new StringBuffer("Directory \"").append(fileLoc);
            this.buff.append("\" must end with \"").append("oneoffs");
            this.buff.append("\"");
            throw new IOException(this.buff.toString());
        }
        StringBuffer dir = new StringBuffer(fileLoc);
        if (!fileLoc.endsWith(File.separator)) {
            dir.append(File.separator);
        }
        dir.append(this.PSE).append(File.separator).append("etc");
        dir.append(File.separator).append("config");
        dir.append(File.separator);
        String actions = dir.toString() + "actions.xml";
        String inventory = dir.toString() + "inventory.xml";
        f2 = WrapperFactory.getNioServiceWrapper().getPath(dir.toString(), new String[0]);
        Files.createDirectories(f2, new FileAttribute[0]);
        this.writeAction(actions);
        this.writeInventory(inventory);
    }

    private void buildCopyArchiveJarFile(String[] files) {
        ArrayList<String> cList = new ArrayList<String>();
        ArrayList<String> aList = new ArrayList<String>();
        ArrayList<String> jList = new ArrayList<String>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            String line = files[i2];
            if (!line.endsWith(OBJ_EXT) && !line.endsWith(CLASS_EXT)) {
                cList.add(line);
                continue;
            }
            if (line.endsWith(OBJ_EXT)) {
                aList.add(line);
                continue;
            }
            if (!line.endsWith(CLASS_EXT)) continue;
            jList.add(line);
        }
        this.COPY_FILES_TOUCHED = new String[cList.size()];
        this.COPY_FILES_TOUCHED = cList.toArray(this.COPY_FILES_TOUCHED);
        this.ARCHIVE_FILES_TOUCHED = new String[aList.size()];
        this.ARCHIVE_FILES_TOUCHED = aList.toArray(this.ARCHIVE_FILES_TOUCHED);
        this.JAR_FILES_TOUCHED = new String[jList.size()];
        this.JAR_FILES_TOUCHED = jList.toArray(this.JAR_FILES_TOUCHED);
    }

    private void buildAction(String[] copies, String[] archives, String[] jars) {
        String path;
        int index;
        String entry;
        int i2;
        this.ACTION_ENTRY.append("<oneoff_actions>").append("\n");
        this.ACTION_ENTRY.append("<").append(COMPONENT).append(" version=\"");
        this.ACTION_ENTRY.append(COMPONENT_VERSION).append("\"").append(" opt_req=\"");
        this.ACTION_ENTRY.append("R\"").append(">").append("\n");
        for (i2 = 0; i2 < copies.length; ++i2) {
            entry = copies[i2];
            index = entry.lastIndexOf(FILE_SEPARATOR);
            String file = entry.substring(index + 1, entry.length());
            String path2 = entry.substring(0, index);
            String fileNamePath = path2 + file;
            this.ACTION_ENTRY.append("\t").append("<copy name=\"");
            this.ACTION_ENTRY.append(file).append("\" path=\"%ORACLE_HOME%");
            this.ACTION_ENTRY.append(FILE_SEPARATOR).append(path2).append("\" ");
            this.ACTION_ENTRY.append(" file_name=\"").append(fileNamePath).append("\"/>");
            this.ACTION_ENTRY.append("\n");
        }
        for (i2 = 0; i2 < archives.length; ++i2) {
            entry = archives[i2];
            index = entry.lastIndexOf(":");
            String obj = entry.substring(index + 1, entry.length());
            String pathWithLib = entry.substring(0, index);
            index = pathWithLib.lastIndexOf(FILE_SEPARATOR);
            String lib = pathWithLib.substring(index + 1, pathWithLib.length());
            path = pathWithLib.substring(0, index);
            String objNamePath = pathWithLib + File.separator + obj;
            this.ACTION_ENTRY.append("\t").append("<archive name=\"");
            this.ACTION_ENTRY.append(lib).append("\" path=\"%ORACLE_HOME%");
            this.ACTION_ENTRY.append(FILE_SEPARATOR).append(path).append("\" ");
            this.ACTION_ENTRY.append(" object_name=\"").append(objNamePath).append("\"/>");
            this.ACTION_ENTRY.append("\n");
        }
        for (i2 = 0; i2 < jars.length; ++i2) {
            entry = jars[i2];
            index = entry.lastIndexOf(":");
            String classWithPath = entry.substring(index + 1, entry.length());
            String pathWithJar = entry.substring(0, index);
            index = pathWithJar.lastIndexOf(FILE_SEPARATOR);
            String jar = pathWithJar.substring(index + 1, pathWithJar.length());
            path = pathWithJar.substring(0, index);
            String classNamePath = pathWithJar + File.separator + classWithPath;
            this.ACTION_ENTRY.append("\t").append("<jar name=\"");
            this.ACTION_ENTRY.append(jar).append("\" path=\"%ORACLE_HOME%");
            this.ACTION_ENTRY.append(FILE_SEPARATOR).append(path).append("\" ");
            this.ACTION_ENTRY.append(" class_name=\"").append(classNamePath).append("\"/>");
            this.ACTION_ENTRY.append("\n");
        }
        this.ACTION_ENTRY.append("</").append(COMPONENT).append(">").append("\n");
        this.ACTION_ENTRY.append("</oneoff_actions>").append("\n");
    }

    private void writeAction(String fileLoc) throws IOException {
        this.savePatchMetadata(fileLoc, this.ACTION_ENTRY.toString());
    }

    private void buildInventory(String pse, String[] bugs) {
        this.INV_ENTRY.append("<oneoff_inventory>").append("\n");
        this.INV_ENTRY.append("<reference_id number=\"").append(pse).append("\"/>");
        this.INV_ENTRY.append("\n").append("<base_bugs>").append("\n");
        for (int i2 = 0; i2 < bugs.length; ++i2) {
            String bug = bugs[i2];
            this.INV_ENTRY.append("\t");
            this.INV_ENTRY.append("<bug number=\"").append(bug).append("\" description=\"");
            this.INV_ENTRY.append("Dummy bug ").append(bug).append("\"/>");
            this.INV_ENTRY.append("\n");
        }
        this.INV_ENTRY.append("</base_bugs>").append("\n");
        this.INV_ENTRY.append("</oneoff_inventory>").append("\n");
    }

    private void writeInventory(String fileLoc) throws IOException {
        this.savePatchMetadata(fileLoc, this.INV_ENTRY.toString());
    }

    private void savePatchMetadata(String fileLoc, String xmlContent) throws IOException {
        StringReader actionsReader = new StringReader(xmlContent);
        Document actionsDoc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            actionsDoc = builder.parse(new InputSource(actionsReader));
            BufferedWriter actionsWriter = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
            StreamResult xmlStream = new StreamResult(actionsWriter);
            DOMSource source = new DOMSource(actionsDoc);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            String defaultEncodingName = new OutputStreamWriter(System.out).getEncoding();
            t.setOutputProperty("encoding", defaultEncodingName);
            t.transform(source, xmlStream);
            actionsWriter.close();
        }
        catch (Exception e2) {
            IOException io = new IOException(e2.getMessage());
            io.setStackTrace(e2.getStackTrace());
            throw io;
        }
    }

    public void dumpList(String title, String[] list) {
        System.out.println(title);
        for (int i2 = 0; i2 < list.length; ++i2) {
            System.out.println(list[i2]);
        }
    }

    private String[] parseCommaList(String commaList) {
        StringTokenizer tk = new StringTokenizer(commaList, DATA_SEPARATOR);
        int n2 = tk.countTokens();
        String[] list = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String ele = (String)tk.nextElement();
            list[i2] = ele.trim();
        }
        return list;
    }

    private boolean isBaptaFile(String fileLoc) throws IOException {
        int i2;
        String line;
        int count = 0;
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]);
        BufferedReader fis = Files.newBufferedReader(f2, Charset.forName("UTF-8"));
        BufferedReader bis = new BufferedReader(fis);
        while ((line = bis.readLine()) != null) {
            for (i2 = 0; i2 < REQUIRE_BAPTA_KEYS.length; ++i2) {
                String key = REQUIRE_BAPTA_KEYS[i2];
                if (!line.startsWith(key)) continue;
                ++count;
            }
            this.FILE_CONTENT.add(line);
        }
        bis.close();
        for (i2 = 0; i2 < REQUIRE_BAPTA_KEYS.length; ++i2) {
            int matchCount = 0;
            String key = REQUIRE_BAPTA_KEYS[i2];
            for (int j2 = 0; j2 < this.FILE_CONTENT.size(); ++j2) {
                line = (String)this.FILE_CONTENT.get(j2);
                if (!line.startsWith(key)) continue;
                ++matchCount;
            }
            if (matchCount == true) continue;
            this.buff = new StringBuffer("Key \"").append(key).append("\" appears ");
            this.buff.append("more than once.");
            throw new IOException(this.buff.toString());
        }
        return count == REQUIRE_BAPTA_KEYS.length;
    }

    @Override
    public String toString() {
        this.buff = new StringBuffer();
        this.buff.append("[PartialPatchObject: actions=");
        this.buff.append(this.ACTION_ENTRY.toString()).append(", inventory=");
        this.buff.append(this.INV_ENTRY.toString());
        this.buff.append("]");
        return this.buff.toString();
    }

    @Override
    public String getPatchID() {
        return this.PSE;
    }

    public static void main(String[] argv) {
        String fileLoc = "/tmp/bapta.txt";
        String invenLoc = "/tmp/TestPatch/etc/config/inventory";
        String actionLoc = "/tmp/TestPatch/etc/config/actions";
        if (argv.length >= 3) {
            fileLoc = argv[0];
            invenLoc = argv[1];
            actionLoc = argv[2];
        }
        PartialPatchObject ppo = new PartialPatchObject();
        try {
            ppo.loadBaptaFile(fileLoc);
            ppo.writeInventory(invenLoc);
            ppo.writeAction(actionLoc);
            System.out.println(ppo);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    static {
        MAKE_ENTRY.append("<make change_dir=\"%ORACLE_HOME%/rdbms/lib/\" ");
        MAKE_ENTRY.append("make_file=\"ins_rdbms.mk\" make_target=\"iexp\"/>");
    }
}

