/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class UpdateTimeStamp {
    private static int BUF_LENGTH = 1024;
    private static byte[] buf = new byte[BUF_LENGTH];

    protected static void updateTime(String sourcePath, String destPath, long time) throws RuntimeException {
        ZipOutputStream zout = null;
        ZipInputStream zin = null;
        try {
            OLogger.printlnOnLogAndVerbose("Destination Path to update timestamps : " + destPath);
            zout = UpdateTimeStamp.UserZipOutputStream(destPath);
            OLogger.printlnOnLogAndVerbose("Source Path to pick up for updating timestamps : " + sourcePath);
            zin = UpdateTimeStamp.UserZipInputStream(sourcePath, zout);
            UpdateTimeStamp.updateDate(zin, zout, time);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            throw e2;
        }
        finally {
            try {
                zout.close();
                zin.close();
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
    }

    private static ZipInputStream UserZipInputStream(String sourcePath, ZipOutputStream zos) {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(sourcePath, new String[0]), new OpenOption[0]));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return zis;
    }

    private static ZipOutputStream UserZipOutputStream(String destPath) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(destPath, new String[0]), new OpenOption[0]));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return zos;
    }

    private static ZipEntry newZipEntry(ZipEntry ze) {
        ZipEntry e2 = new ZipEntry(ze.getName());
        e2.setComment(ze.getComment());
        return e2;
    }

    private static void updateDate(ZipInputStream zis, ZipOutputStream zos, long time) {
        try {
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                ze.setTime(time);
                zos.putNextEntry(UpdateTimeStamp.newZipEntry(ze));
                if (UpdateTimeStamp.isArchive(ze)) {
                    UpdateTimeStamp.processSubArchive(zis, zos, time);
                } else {
                    UpdateTimeStamp.copyData(zis, zos);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
            zos.finish();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static void copyData(ZipInputStream zis, ZipOutputStream zos) {
        try {
            while (zis.available() == 1) {
                int readCount = zis.read(buf, 0, buf.length);
                if (readCount <= 0) continue;
                zos.write(buf, 0, readCount);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static void processSubArchive(ZipInputStream zis, ZipOutputStream zos, long time) {
        try {
            ZipOutputStream archZos = new ZipOutputStream(zos);
            archZos.setMethod(8);
            UpdateTimeStamp.updateDate(new ZipInputStream(zis), archZos, time);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    private static boolean isArchive(ZipEntry ze) {
        String zName = ze.getName().toUpperCase();
        return zName.endsWith(".JAR") || zName.endsWith(".WAR") || zName.endsWith(".RAR") || zName.endsWith(".ZIP") || zName.endsWith(".EAR");
    }

    protected static boolean isArchive(String fileName) {
        String zName = fileName.toUpperCase();
        return zName.endsWith(".JAR") || zName.endsWith(".WAR") || zName.endsWith(".RAR") || zName.endsWith(".ZIP") || zName.endsWith(".EAR");
    }
}

