/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cas;

import java.nio.file.Path;
import oracle.glcm.opatch.content.api.IOracleHome;
import oracle.glcm.opatch.content.api.IStabilityMgmt;
import oracle.glcm.opatch.content.sdk.CasPublic;
import oracle.glcm.opatch.content.sdk.CasSDK;
import oracle.opatch.OPatchCASOracleHome;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.CacheProcessor;
import oracle.opatch.wrappers.WrapperFactory;

public class CASStabilityServices {
    public boolean isLastCheckpointCompleted(String oracleHomePath) throws Throwable {
        IStabilityMgmt sm = null;
        try {
            String ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OPatchCASOracleHome coh = new OPatchCASOracleHome(ohPath, ".cas", customLogPath);
            sm = CasPublic.newStabilityMgmt((IOracleHome)coh);
            boolean bl = sm.isLastCheckpointCompleted();
            return bl;
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("CASStabilityServices::isLastCheckpointCompleted error: " + t.getMessage());
            OLogger.printStackTrace(t);
            throw t;
        }
        finally {
            if (sm != null) {
                ((CasSDK)sm).cleanup();
            }
        }
    }

    public void restore(String oracleHomePath) throws Throwable {
        IStabilityMgmt sm = null;
        try {
            String ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OPatchCASOracleHome coh = new OPatchCASOracleHome(ohPath, ".cas", customLogPath);
            sm = CasPublic.newStabilityMgmt((IOracleHome)coh);
            sm.restore();
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("CASStabilityServices::restore error: " + t.getMessage());
            OLogger.printStackTrace(t);
            throw t;
        }
        finally {
            if (sm != null) {
                ((CasSDK)sm).cleanup();
            }
            CacheProcessor.clearcachedfiles(oracleHomePath);
        }
    }

    public void beginPhaseTwoCheckpoint(String oracleHomePath) throws Throwable {
        IStabilityMgmt sm = null;
        try {
            String ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OPatchCASOracleHome coh = new OPatchCASOracleHome(ohPath, ".cas", customLogPath);
            sm = CasPublic.newStabilityMgmt((IOracleHome)coh);
            sm.createPhaseTwoCheckpoint(false);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("CASStabilityServices::beginPhaseTwoCheckpoint error: " + t.getMessage());
            OLogger.printStackTrace(t);
            throw t;
        }
        finally {
            if (sm != null) {
                ((CasSDK)sm).cleanup();
            }
        }
    }

    public void endPhaseTwoCheckpoint(String oracleHomePath) throws Throwable {
        IStabilityMgmt sm = null;
        try {
            String ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]).toString();
            Path customLogPath = null;
            String customLogDir = OPatchEnv.getCustomLogDir();
            if (customLogDir != null && !customLogDir.equals("")) {
                customLogPath = WrapperFactory.getNioServiceWrapper().getPath(customLogDir, new String[0]).resolve("opatch-cas");
            }
            OPatchCASOracleHome coh = new OPatchCASOracleHome(ohPath, ".cas", customLogPath);
            sm = CasPublic.newStabilityMgmt((IOracleHome)coh);
            sm.createPhaseTwoCheckpoint(true);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("CASStabilityServices::endPhaseTwoCheckpoint error: " + t.getMessage());
            OLogger.printStackTrace(t);
            throw t;
        }
        finally {
            if (sm != null) {
                ((CasSDK)sm).cleanup();
            }
        }
    }
}

