/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConfiguration;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictResolutionPlanner;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.MergePatch;
import oracle.opatch.conflicttextualinterpreter.MergePatchBuilder;
import oracle.opatch.conflicttextualinterpreter.NPatchPlan;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.OPatchValidationException;
import oracle.opatch.conflicttextualinterpreter.RelationAdjustment;
import oracle.opatch.conflicttextualinterpreter.SetResolution;

public class ConflictResolutionPlanner
implements IConflictResolutionPlanner {
    private IConflictMap m_orgMap;
    private ConflictMap m_finalMap;
    private HashMap m_dependentMap;
    private List<MergePatch> m_mergePatchList;

    public ConflictResolutionPlanner(IConflictMap map) {
        this.m_orgMap = map;
    }

    @Override
    public ConflictMap getFinalConflictMap() {
        return this.m_finalMap;
    }

    @Override
    public INPatchPlan plan(IConfiguration cfg) throws OPatchValidationException {
        NPatchPlan myPlan = new NPatchPlan();
        this.m_finalMap = new ConflictMap(this.m_orgMap);
        Collection<IStep> runningSteps = cfg.configure();
        for (IStep step : runningSteps) {
            if (step instanceof RelationAdjustment) {
                ((RelationAdjustment)step).setOriginalMap(this.m_orgMap);
            }
            step.process(this.m_finalMap, myPlan);
        }
        this.generateDependentMap(this.m_finalMap);
        SetResolution.releaseResolution();
        return myPlan;
    }

    @Override
    public HashMap getDependentMap() {
        return this.m_dependentMap;
    }

    @Override
    public List<MergePatch> getMergePatchList() {
        return this.m_mergePatchList;
    }

    private void generateDependentMap(IConflictMap map) {
        this.m_dependentMap = new HashMap();
        this.m_mergePatchList = new ArrayList<MergePatch>();
        HashSet empty = new HashSet();
        Collection<IPatch> pis = map.getPi();
        MergePatchBuilder builder = MergePatchBuilder.getInstance();
        for (IPatch pi : pis) {
            NPatchRelations relations = map.getRelations(pi);
            Collection prereqIds = this.getBeingPrereqsID(pi, map);
            if (!(relations.getSubsets().isEmpty() && relations.getDuplicates().isEmpty() && relations.getWorses().isEmpty() && map.getRelations(pi).getLowerPSUs().isEmpty() && !pi.isSubSetOfBigPoh() || prereqIds.isEmpty())) {
                this.m_dependentMap.put(pi, prereqIds);
            }
            if (OPatchEnv.isIgnoreConflict() && !relations.getConflicts().isEmpty() && !prereqIds.isEmpty()) {
                this.m_dependentMap.put(pi, prereqIds);
            }
            if (relations.getSupersets().isEmpty()) continue;
            ArrayList<IPatch> subsetPatches = new ArrayList<IPatch>();
            for (NPatchRelation relation : relations.getSupersets()) {
                IPatch subsetPatch = relation.to();
                if (!subsetPatch.isInOh() || subsetPatch.isActive()) continue;
                subsetPatches.add(subsetPatch);
            }
            this.m_mergePatchList.add(builder.build(pi, subsetPatches, map));
        }
        Collection<IPatch> pohs = map.getPoh();
        for (IPatch poh : pohs) {
            HashSet<String> dependentPatchIds;
            NPatchRelations relations = map.getRelations(poh);
            if (!relations.getWorses().isEmpty() || !relations.getLowerPSUs().isEmpty() || poh.isSubSetOfBigPi() || !relations.getSubsets().isEmpty() && poh.isComposite()) {
                if (poh.isComposite()) {
                    this.m_dependentMap.put(poh, empty);
                    continue;
                }
                dependentPatchIds = new HashSet<String>();
                dependentPatchIds.addAll(poh.getBeingOverlaysID());
                dependentPatchIds.addAll(poh.getBeingPrereqsID());
                if (!dependentPatchIds.isEmpty()) {
                    this.m_dependentMap.put(poh, dependentPatchIds);
                }
            }
            if (!OPatchEnv.isForceConflict() || relations.getConflicts().isEmpty()) continue;
            if (poh.isComposite()) {
                this.m_dependentMap.put(poh, empty);
                continue;
            }
            dependentPatchIds = new HashSet();
            dependentPatchIds.addAll(poh.getBeingOverlaysID());
            dependentPatchIds.addAll(poh.getBeingPrereqsID());
            if (dependentPatchIds.isEmpty()) continue;
            this.m_dependentMap.put(poh, dependentPatchIds);
        }
    }

    private Collection getBeingPrereqsID(IPatch pi, IConflictMap map) {
        Collection<String> prereqIds = pi.getBeingPrereqsID();
        HashSet<String> finalPrereqIds = new HashSet<String>();
        if (pi.isComposite()) {
            HashSet<String> subPatchIds = new HashSet<String>();
            prereqIds = new HashSet<String>();
            for (IPatch subPatch : pi.getSubPatches()) {
                subPatchIds.add(subPatch.getPatchId());
                prereqIds.addAll(subPatch.getBeingPrereqsID());
            }
            subPatchIds.add(pi.getPatchId());
            prereqIds.addAll(pi.getBeingPrereqsID());
            prereqIds.removeAll(subPatchIds);
        }
        HashSet prereqs = new HashSet();
        for (String prereqId : prereqIds) {
            prereqs.addAll(map.getPatches(prereqId));
        }
        for (IPatch prereq : prereqs) {
            if (prereq.isInOh()) continue;
            finalPrereqIds.add(prereq.getPatchId());
        }
        return finalPrereqIds;
    }

    @Override
    public IConflictMap getOrginalConflictMap() {
        return this.m_orgMap;
    }
}

