/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HomeInventoryHelper {
    private static String fileSeparator = File.separator;

    public static void savePatchMetaFileToInventory(String oracleHomePath, PatchObject patchObject) throws RuntimeException {
        String patchID = patchObject.getPatchID();
        String patchLoc = patchObject.getPatchLocation();
        boolean cont = true;
        StringBuffer buff = new StringBuffer("ApplySession::savePatchMetaFileToInventory()");
        OLogger.debug(buff);
        String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchObject.getTripletPatchID());
        String patchLocation = patchObject.getPatchLocation();
        StringBuffer etcConfig = new StringBuffer(ohPatchLocToSave);
        etcConfig.append(fileSeparator);
        etcConfig.append("etc");
        etcConfig.append(fileSeparator);
        String ohEtcLoc = etcConfig.toString();
        StringBuffer custom = new StringBuffer(ohPatchLocToSave);
        custom.append(fileSeparator);
        custom.append("custom");
        custom.append(fileSeparator);
        String ohCustomLoc = custom.toString();
        etcConfig.append("config");
        StringBuffer ohActionLoc = new StringBuffer(etcConfig.toString());
        ohActionLoc.append(fileSeparator);
        ohActionLoc.append("actions.xml");
        StringBuffer ohCompositeLoc = new StringBuffer(etcConfig.toString());
        ohCompositeLoc.append(fileSeparator);
        ohCompositeLoc.append("composite.xml");
        StringBuffer ohInventoryLoc = new StringBuffer(etcConfig.toString());
        ohInventoryLoc.append(fileSeparator);
        ohInventoryLoc.append("inventory.xml");
        StringBuffer ohMaintenanceAliasLoc = new StringBuffer(etcConfig.toString());
        ohMaintenanceAliasLoc.append(fileSeparator);
        ohMaintenanceAliasLoc.append("maintenance_alias.xml");
        StringBuffer ohPADLoc = new StringBuffer(etcConfig.toString());
        ohPADLoc.append(fileSeparator);
        ohPADLoc.append("patchdeploy.xml");
        StringBuffer ohDeployLoc = new StringBuffer(etcConfig.toString());
        ohDeployLoc.append(fileSeparator);
        ohDeployLoc.append("deploy.xml");
        StringBuffer ohAutomationLoc = new StringBuffer(etcConfig.toString());
        ohAutomationLoc.append(fileSeparator);
        ohAutomationLoc.append("automation.xml");
        StringBuffer ohInterviewLoc = new StringBuffer(etcConfig.toString());
        ohInterviewLoc.append(fileSeparator);
        ohInterviewLoc.append("sequence.xml");
        StringBuffer ohEmLoc = new StringBuffer(etcConfig.toString());
        ohEmLoc.append(fileSeparator);
        ohEmLoc.append("em.xml");
        StringBuffer jlibDir = new StringBuffer(ohPatchLocToSave);
        jlibDir.append(fileSeparator);
        jlibDir.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
        StringBuffer ohOextJar = new StringBuffer(jlibDir.toString());
        ohOextJar.append(fileSeparator);
        ohOextJar.append("oext.jar");
        StringBuffer ohFileMappingLoc = new StringBuffer(etcConfig.toString());
        ohFileMappingLoc.append(fileSeparator);
        ohFileMappingLoc.append("file-mapping.xml");
        Path patchLocFile = WrapperFactory.getNioServiceWrapper().getPath(ohPatchLocToSave, new String[0]);
        StringBuffer patchCustomLoc = new StringBuffer(patchLoc);
        patchCustomLoc.append(fileSeparator);
        patchCustomLoc.append("custom");
        String patchEtcConfig = PatchObject.getEtcConfigPath(patchLoc);
        StringBuffer patchActionLoc = new StringBuffer(patchEtcConfig);
        patchActionLoc.append(fileSeparator);
        patchActionLoc.append("actions.xml");
        StringBuffer patchCompositeLoc = new StringBuffer(patchEtcConfig);
        patchCompositeLoc.append(fileSeparator);
        patchCompositeLoc.append("composite.xml");
        StringBuffer patchInventoryLoc = new StringBuffer(patchEtcConfig);
        patchInventoryLoc.append(fileSeparator);
        patchInventoryLoc.append("inventory.xml");
        StringBuffer patchChecksumLoc = new StringBuffer(patchEtcConfig.toString());
        patchChecksumLoc.append(fileSeparator);
        patchChecksumLoc.append("checksum.xml");
        StringBuffer patchMaintenanceAliasLoc = new StringBuffer(patchEtcConfig);
        patchMaintenanceAliasLoc.append(fileSeparator);
        patchMaintenanceAliasLoc.append("maintenance_alias.xml");
        StringBuffer patchPADLoc = new StringBuffer(patchEtcConfig);
        patchPADLoc.append(fileSeparator);
        patchPADLoc.append("patchdeploy.xml");
        StringBuffer patchDeployLoc = new StringBuffer(patchEtcConfig);
        patchDeployLoc.append(fileSeparator);
        patchDeployLoc.append("deploy.xml");
        StringBuffer patchAutomationLoc = new StringBuffer(patchEtcConfig);
        patchAutomationLoc.append(fileSeparator);
        patchAutomationLoc.append("automation.xml");
        StringBuffer patchInterviewLoc = new StringBuffer(patchEtcConfig);
        patchInterviewLoc.append(fileSeparator);
        patchInterviewLoc.append("sequence.xml");
        StringBuffer checksumLoc = new StringBuffer(etcConfig.toString());
        checksumLoc.append(fileSeparator);
        checksumLoc.append("checksum.xml");
        StringBuffer patchOextJarFileLoc = new StringBuffer(patchLoc);
        patchOextJarFileLoc.append(fileSeparator);
        patchOextJarFileLoc.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
        patchOextJarFileLoc.append(fileSeparator);
        patchOextJarFileLoc.append("oext.jar");
        StringBuffer patchEmXmlLoc = new StringBuffer(patchEtcConfig);
        patchEmXmlLoc.append(fileSeparator);
        patchEmXmlLoc.append("em.xml");
        StringBuffer patchFileMappingLoc = new StringBuffer(patchEtcConfig);
        patchFileMappingLoc.append(fileSeparator);
        patchFileMappingLoc.append("file-mapping.xml");
        boolean ok = true;
        if (!Files.exists(patchLocFile, new LinkOption[0])) {
            try {
                Files.createDirectories(patchLocFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
        }
        if (!Files.exists(patchLocFile = WrapperFactory.getNioServiceWrapper().getPath(etcConfig.toString(), new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(patchLocFile, new FileAttribute[0]);
            }
            catch (IOException e3) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
        }
        if (!Files.exists(patchLocFile = WrapperFactory.getNioServiceWrapper().getPath(jlibDir.toString(), new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(patchLocFile, new FileAttribute[0]);
            }
            catch (IOException e4) {
                OPatchStateManagerFactory.getInstance().setErrorCode(117);
                throw new RuntimeException("HomeInventoryHelper::savePatchMetaFileToInventory() cannot copy patch object to " + ohPatchLocToSave);
            }
        }
        String srcInv = patchInventoryLoc.toString();
        String dstInv = ohInventoryLoc.toString();
        Path srcInvFile = WrapperFactory.getNioServiceWrapper().getPath(srcInv, new String[0]);
        Path dstInvFile = WrapperFactory.getNioServiceWrapper().getPath(dstInv, new String[0]);
        String srcChecksum = patchChecksumLoc.toString();
        String dstChecksum = checksumLoc.toString();
        Path srcChecksumFile = WrapperFactory.getNioServiceWrapper().getPath(srcChecksum, new String[0]);
        Path dstChecksumFile = WrapperFactory.getNioServiceWrapper().getPath(dstChecksum, new String[0]);
        String srcMaintenanceAlias = patchMaintenanceAliasLoc.toString();
        String dstMaintenanceAlias = ohMaintenanceAliasLoc.toString();
        Path srcMaintenanceAliasFile = WrapperFactory.getNioServiceWrapper().getPath(srcMaintenanceAlias, new String[0]);
        Path dstMaintenanceAliasFile = WrapperFactory.getNioServiceWrapper().getPath(dstMaintenanceAlias, new String[0]);
        String srcPAD = patchPADLoc.toString();
        String dstPAD = ohPADLoc.toString();
        Path srcPADFile = WrapperFactory.getNioServiceWrapper().getPath(srcPAD, new String[0]);
        Path dstPADFile = WrapperFactory.getNioServiceWrapper().getPath(dstPAD, new String[0]);
        String srcDeploy = patchDeployLoc.toString();
        String dstDeploy = ohDeployLoc.toString();
        Path srcDeployFile = WrapperFactory.getNioServiceWrapper().getPath(srcDeploy, new String[0]);
        Path dstDeployFile = WrapperFactory.getNioServiceWrapper().getPath(dstDeploy, new String[0]);
        String srcInterview = patchInterviewLoc.toString();
        String dstInterview = ohInterviewLoc.toString();
        Path srcInterviewFile = WrapperFactory.getNioServiceWrapper().getPath(srcInterview, new String[0]);
        Path dstInterviewFile = WrapperFactory.getNioServiceWrapper().getPath(dstInterview, new String[0]);
        String srcAutomation = patchAutomationLoc.toString();
        String dstAutomation = ohAutomationLoc.toString();
        Path srcAutomationFile = WrapperFactory.getNioServiceWrapper().getPath(srcAutomation, new String[0]);
        Path dstAutomationFile = WrapperFactory.getNioServiceWrapper().getPath(dstAutomation, new String[0]);
        String dstAct = ohActionLoc.toString();
        Path dstActFile = WrapperFactory.getNioServiceWrapper().getPath(dstAct, new String[0]);
        String srcComposite = patchCompositeLoc.toString();
        String dstComposite = ohCompositeLoc.toString();
        Path srcCompositeFile = WrapperFactory.getNioServiceWrapper().getPath(srcComposite, new String[0]);
        Path dstCompositeFile = WrapperFactory.getNioServiceWrapper().getPath(dstComposite, new String[0]);
        Path ohEmLocFile = WrapperFactory.getNioServiceWrapper().getPath(ohEmLoc.toString(), new String[0]);
        Path patchEmLocFile = WrapperFactory.getNioServiceWrapper().getPath(patchEmXmlLoc.toString(), new String[0]);
        String srcOext = patchOextJarFileLoc.toString();
        String dstOext = ohOextJar.toString();
        Path srcOextFile = WrapperFactory.getNioServiceWrapper().getPath(srcOext, new String[0]);
        Path dstOextFile = WrapperFactory.getNioServiceWrapper().getPath(dstOext, new String[0]);
        String srcFileMapping = patchFileMappingLoc.toString();
        String dstFileMapping = ohFileMappingLoc.toString();
        Path srcFileMappingFile = WrapperFactory.getNioServiceWrapper().getPath(srcFileMapping, new String[0]);
        Path dstFileMappingFile = WrapperFactory.getNioServiceWrapper().getPath(dstFileMapping, new String[0]);
        if (!Files.exists(srcInvFile, new LinkOption[0])) {
            patchInventoryLoc = new StringBuffer(patchEtcConfig);
            patchInventoryLoc.append(fileSeparator);
            patchInventoryLoc.append("inventory");
            srcInv = patchInventoryLoc.toString();
            srcInvFile = WrapperFactory.getNioServiceWrapper().getPath(srcInv, new String[0]);
        }
        SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcInvFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstInvFile.toString(), new String[0]));
        if (Files.exists(srcPADFile, new LinkOption[0])) {
            OLogger.printlnOnLog("Saving \"" + dstPAD + "\"" + " to OH.");
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcPADFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstPADFile.toString(), new String[0]));
        }
        if (Files.exists(srcCompositeFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcCompositeFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstCompositeFile.toString(), new String[0]));
        }
        if (Files.exists(srcMaintenanceAliasFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcMaintenanceAliasFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstMaintenanceAliasFile.toString(), new String[0]));
        }
        if (Files.exists(srcDeployFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcDeployFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstDeployFile.toString(), new String[0]));
        }
        if (Files.exists(srcInterviewFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcInterviewFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstInterviewFile.toString(), new String[0]));
        }
        if (Files.exists(srcAutomationFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcAutomationFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstAutomationFile.toString(), new String[0]));
        }
        if (Files.exists(patchEmLocFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(patchEmLocFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(ohEmLocFile.toString(), new String[0]));
        }
        OPatchSessionHelper.commitChecksumXML(checksumLoc.toString(), patchObject, oracleHomePath);
        if (!Files.exists(dstChecksumFile, new LinkOption[0]) && Files.exists(srcChecksumFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcChecksumFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstChecksumFile.toString(), new String[0]));
        }
        String actionsXML = patchObject.actionsToXML();
        StringReader actionsReader = new StringReader(actionsXML);
        Document actionsDoc = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            actionsDoc = builder.parse(new InputSource(actionsReader));
            BufferedWriter actionsWriter = Files.newBufferedWriter(dstActFile, Charset.forName("UTF-8"), new OpenOption[0]);
            StreamResult xmlStream = new StreamResult(actionsWriter);
            DOMSource source = new DOMSource(actionsDoc);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.transform(source, xmlStream);
            actionsWriter.close();
        }
        catch (Exception e5) {
            OPatchStateManagerFactory.getInstance().setErrorCode(116);
            OLogger.printlnOnLog("Not able to save actions.xml file to inventory.");
            RuntimeException re = new RuntimeException(e5);
            throw re;
        }
        if (Files.exists(srcOextFile, new LinkOption[0])) {
            try {
                SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcOextFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstOextFile.toString(), new String[0]));
            }
            catch (RuntimeException e6) {
                OPatchStateManagerFactory.getInstance().setErrorCode(116);
                OLogger.printlnOnLog("Not able to copy oext.jar to inventory.");
                throw e6;
            }
        }
        if (Files.exists(srcFileMappingFile, new LinkOption[0])) {
            SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(srcFileMappingFile.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(dstFileMappingFile.toString(), new String[0]));
        }
        try {
            if (patchObject.isNotRollBackable()) {
                HomeInventoryHelper.addNonRollbackableTagToInv(dstInvFile);
            }
        }
        catch (Exception e7) {
            OPatchStateManagerFactory.getInstance().setErrorCode(116);
            OLogger.printlnOnLog("Not able to modify inventory.xml to add non rollbackable flag.");
            RuntimeException re = new RuntimeException(e7);
            throw re;
        }
    }

    private static void addNonRollbackableTagToInv(Path invFile) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        Element nonRollBackEle;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(invFile.toFile());
        Element root = document.getDocumentElement();
        NodeList nodeList = document.getElementsByTagName("not_rollbackable");
        if (nodeList != null && nodeList.getLength() > 0) {
            nonRollBackEle = (Element)nodeList.item(0);
            String value = nonRollBackEle.getTextContent();
            if (value != null && value.equalsIgnoreCase("true")) {
                OLogger.debug("The not_rollbackable tag is already set to true. Hence not modifying the invetory file - " + invFile);
                return;
            }
            OLogger.debug("The not_rollbackable tag is set to false. Hence modifying the value in invetory file - " + invFile);
        } else {
            OLogger.debug("The not_rollbackable tag does not exist in the invetory file - " + invFile + ". Adding the tag");
            nonRollBackEle = document.createElement("not_rollbackable");
            root.appendChild(nonRollBackEle);
        }
        nonRollBackEle.setTextContent("true");
        DOMSource source = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(invFile.toFile());
        transformer.transform(source, result);
        OLogger.printlnOnLog("The invetory file - " + invFile + " successfully modified to add not_rollbackable tag");
    }

    public static OneOffEntry getOneOffEntry(String oracleHomePath, String patchID) throws RuntimeException {
        PatchObject patchObject = null;
        try {
            patchObject = PatchObject.getInstance(oracleHomePath, patchID, OPatchEnv.needSearchTripletID());
        }
        catch (Exception e2) {
            StringBuffer buff = new StringBuffer("Unable to create patchObject\n");
            buff.append("Possible causes are:\n");
            StringBuffer sb = new StringBuffer();
            sb.append("ORACLE_HOME" + fileSeparator);
            sb.append("inventory");
            sb.append(fileSeparator);
            sb.append("oneoffs" + fileSeparator + patchID);
            buff.append("   " + sb);
            buff.append(" is corrupted. ");
            if (e2.getMessage() != null) {
                buff.append(e2.getMessage()).append("\n");
            } else {
                buff.append("\n");
                buff.append("   No read permission to above directory\n");
                buff.append("Please remove one-off entry [ " + patchID);
                String comps = IPMUtil.getCompsXMLLocation(oracleHomePath);
                buff.append(" ] from " + comps + " and retry if above directory corrupted, ");
                buff.append("or Please check the contents of the directory ");
                buff.append(sb);
                buff.append(" for read permission");
            }
            RuntimeException re = new RuntimeException(buff.toString(), e2);
            throw re;
        }
        return patchObject.toOneOffEntry("ORACLE_HOME");
    }

    public static void removePatchDirectoryStructure(String ohPatchLocToSave) throws Exception {
        String actionsFile = PatchObject.getActionFilePath(ohPatchLocToSave);
        String actionsFileWithoutXML = PatchObject.getActionWithOutXMLFilePath(ohPatchLocToSave);
        String inventoryFile = PatchObject.getInventoryFilePath(ohPatchLocToSave);
        String padFile = PatchObject.getPADFilePath(ohPatchLocToSave);
        String inventoryFileWithoutXML = PatchObject.getInventoryWithOutXMLFilePath(ohPatchLocToSave);
        String etcPath = PatchObject.getEtcPath(ohPatchLocToSave);
        String etcConfigPath = PatchObject.getEtcConfigPath(ohPatchLocToSave);
        String jlibPath = PatchObject.getJlibPath(ohPatchLocToSave);
        String oextJarFile = PatchObject.getExternalJarFilePath(ohPatchLocToSave);
        String emXmlFile = PatchObject.getEmXmlFilePath(ohPatchLocToSave);
        String interviewFile = PatchObject.getInterviewFilePath(ohPatchLocToSave);
        String deployFile = PatchObject.getDeployFilePath(ohPatchLocToSave);
        String automationFile = PatchObject.getAutomationFilePath(ohPatchLocToSave);
        String checksumFile = PatchObject.getChecksumFilePath(ohPatchLocToSave);
        String compositeFile = PatchObject.getCompositeFilePath(ohPatchLocToSave);
        Path ohCompositeLocFile = WrapperFactory.getNioServiceWrapper().getPath(compositeFile, new String[0]);
        Path patchLocFile = WrapperFactory.getNioServiceWrapper().getPath(ohPatchLocToSave, new String[0]);
        Path patchLocEtcFile = WrapperFactory.getNioServiceWrapper().getPath(etcPath, new String[0]);
        Path patchLocEtcConfigFile = WrapperFactory.getNioServiceWrapper().getPath(etcConfigPath, new String[0]);
        Path ohActionLocFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFile, new String[0]);
        Path ohActionWoXmlLocFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFileWithoutXML, new String[0]);
        Path ohInventoryLocFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFile, new String[0]);
        Path ohInventoryWoXmlLocFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFileWithoutXML, new String[0]);
        Path ohPADLocFile = WrapperFactory.getNioServiceWrapper().getPath(padFile, new String[0]);
        Path patchLocJlibFile = WrapperFactory.getNioServiceWrapper().getPath(jlibPath, new String[0]);
        Path ohOextJarFile = WrapperFactory.getNioServiceWrapper().getPath(oextJarFile, new String[0]);
        Path ohEmXmlFile = WrapperFactory.getNioServiceWrapper().getPath(emXmlFile, new String[0]);
        Path ohInterviewFile = WrapperFactory.getNioServiceWrapper().getPath(interviewFile, new String[0]);
        Path ohDeployFile = WrapperFactory.getNioServiceWrapper().getPath(deployFile, new String[0]);
        Path ohAutomationFile = WrapperFactory.getNioServiceWrapper().getPath(automationFile, new String[0]);
        Path ohChecksumFile = WrapperFactory.getNioServiceWrapper().getPath(checksumFile, new String[0]);
        Path fileMappingPath = WrapperFactory.getNioServiceWrapper().getPath(PatchObject.getFileMappingPath(ohPatchLocToSave), new String[0]);
        if (Files.exists(ohInventoryLocFile, new LinkOption[0])) {
            Files.delete(ohInventoryLocFile);
        }
        if (Files.exists(ohPADLocFile, new LinkOption[0])) {
            Files.delete(ohPADLocFile);
        }
        if (Files.exists(ohInventoryWoXmlLocFile, new LinkOption[0])) {
            Files.delete(ohInventoryWoXmlLocFile);
        }
        if (Files.exists(ohEmXmlFile, new LinkOption[0])) {
            Files.delete(ohEmXmlFile);
        }
        if (Files.exists(ohActionLocFile, new LinkOption[0])) {
            Files.delete(ohActionLocFile);
        }
        if (Files.exists(ohCompositeLocFile, new LinkOption[0])) {
            Files.delete(ohCompositeLocFile);
        }
        if (Files.exists(ohChecksumFile, new LinkOption[0])) {
            Files.delete(ohChecksumFile);
        }
        if (Files.exists(fileMappingPath, new LinkOption[0])) {
            Files.delete(fileMappingPath);
        }
        if (Files.exists(ohActionWoXmlLocFile, new LinkOption[0])) {
            Files.delete(ohActionWoXmlLocFile);
        }
        if (Files.exists(ohInterviewFile, new LinkOption[0])) {
            Files.delete(ohInterviewFile);
        }
        if (Files.exists(ohDeployFile, new LinkOption[0])) {
            Files.delete(ohDeployFile);
        }
        if (Files.exists(ohAutomationFile, new LinkOption[0])) {
            Files.delete(ohAutomationFile);
        }
        if (Files.exists(ohOextJarFile, new LinkOption[0])) {
            Files.delete(ohOextJarFile);
        }
        if (Files.exists(patchLocEtcConfigFile, new LinkOption[0])) {
            Files.delete(patchLocEtcConfigFile);
        }
        if (Files.exists(patchLocEtcFile, new LinkOption[0])) {
            Files.delete(patchLocEtcFile);
        }
        if (Files.exists(patchLocJlibFile, new LinkOption[0])) {
            Files.delete(patchLocJlibFile);
        }
        if (Files.exists(patchLocFile, new LinkOption[0])) {
            OPatchSessionHelper.deleteRecurse(ohPatchLocToSave);
            Files.delete(patchLocFile);
        }
    }

    protected static void createMissingInventoryActionsFiles(String oracleHomePath) {
        try {
            StringBuffer ohOneoffs = new StringBuffer(oracleHomePath);
            ohOneoffs.append(fileSeparator);
            ohOneoffs.append("inventory");
            ohOneoffs.append(fileSeparator);
            ohOneoffs.append("oneoffs");
            StringBuffer etcConfig = new StringBuffer("etc");
            etcConfig.append(fileSeparator);
            etcConfig.append("config");
            etcConfig.append(fileSeparator);
            String actions = etcConfig.toString() + "actions";
            String actionsXML = etcConfig.toString() + "actions.xml";
            String inventory = etcConfig.toString() + "inventory";
            String inventoryXML = etcConfig.toString() + "inventory.xml";
            Path oneoffsFolder = WrapperFactory.getNioServiceWrapper().getPath(ohOneoffs.toString(), new String[0]);
            DirectoryStream<Path> patchSubfolders = Files.newDirectoryStream(oneoffsFolder);
            for (Path patchSubfolder : patchSubfolders) {
                if (!Files.isDirectory(patchSubfolder, new LinkOption[0])) continue;
                try {
                    Path fileActions = WrapperFactory.getNioServiceWrapper().getPath(patchSubfolder.toString(), actions);
                    Path fileActionsXML = WrapperFactory.getNioServiceWrapper().getPath(patchSubfolder.toString(), actionsXML);
                    if (Files.exists(fileActionsXML, new LinkOption[0]) && !Files.exists(fileActions, new LinkOption[0])) {
                        SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(fileActionsXML.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(fileActions.toString(), new String[0]));
                    }
                }
                catch (Exception e2) {
                    OLogger.printStackTrace(e2);
                }
                try {
                    Path fileInventory = WrapperFactory.getNioServiceWrapper().getPath(patchSubfolder.toString(), inventory);
                    Path fileInventoryXML = WrapperFactory.getNioServiceWrapper().getPath(patchSubfolder.toString(), inventoryXML);
                    if (!Files.exists(fileInventoryXML, new LinkOption[0]) || Files.exists(fileInventory, new LinkOption[0])) continue;
                    SystemCall.copyFile(WrapperFactory.getNioServiceWrapper().getPath(fileInventoryXML.toString(), new String[0]), WrapperFactory.getNioServiceWrapper().getPath(fileInventory.toString(), new String[0]));
                }
                catch (Exception e3) {
                    OLogger.printStackTrace(e3);
                }
            }
        }
        catch (Exception e4) {
            OLogger.printStackTrace(e4);
        }
    }
}

