/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.IOException;
import java.lang.reflect.Method;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class OUIInventorySession {
    private OiicStandardInventorySession iSession = null;

    protected OUIInventorySession(String opatchVersion) {
        this.iSession = new OiicStandardInventorySession("OPatch", opatchVersion);
    }

    protected void initSession(int nAccessLevel) throws OiitTargetLockNotAvailableException, IOException, OiiiInventoryDoesNotExistException, IllegalArgumentException {
        StringBuffer msg = new StringBuffer("==> OUIInventorySession::initSession(): ");
        this.logDebuggedIds(msg);
        if (this.iSession != null) {
            if (OPatchEnv.isNextGen()) {
                OiiiInstallAreaControl.reset();
            }
            this.iSession.initSession(nAccessLevel);
        }
    }

    protected void initOPatchWriteSession(String oracleHomePath) throws Throwable {
        StringBuffer msg = new StringBuffer("==> OUIInventorySession::initOPatchWriteSession(): ");
        this.logDebuggedIds(msg);
        if (this.iSession != null) {
            try {
                Method iSessionMethod = this.iSession.getClass().getMethod("initSession", Integer.TYPE, String.class);
                Class<?> areaControlClass = Class.forName("oracle.sysman.oii.oiii.OiiiInstallAreaControl");
                int nAccessLevel = areaControlClass.getDeclaredField("ACCESSLEVEL_OPATCH_WRITE").getInt(areaControlClass);
                iSessionMethod.invoke((Object)this.iSession, nAccessLevel, oracleHomePath);
            }
            catch (Throwable th) {
                if (th instanceof NoSuchMethodException | th instanceof SecurityException | th instanceof ClassNotFoundException | th instanceof IllegalAccessException | th instanceof NoSuchFieldException) {
                    UnsupportedOperationException uoe = new UnsupportedOperationException("Parallel patching is not supported. Unable to initialize OUI inventory session with ACCESSLEVEL_OPATCH_WRITE\n" + th.getMessage());
                    uoe.setStackTrace(th.getStackTrace());
                    throw uoe;
                }
                throw th;
            }
        }
    }

    protected void endSession() {
        StringBuffer msg = new StringBuffer("==> OUIInventorySession::endSession(): ");
        this.logDebuggedIds(msg);
        if (this.iSession != null) {
            this.iSession.endSession();
        }
    }

    protected OiiiInstallAreaControl getInstallAreaControl() {
        if (this.iSession != null) {
            return this.iSession.getInstallAreaControl();
        }
        return null;
    }

    private void logDebuggedIds(StringBuffer msg) {
        long pid = OPatchEnv.getProcessID();
        long tid = OLogger.getThreadID();
        msg.append("Process ID: ");
        msg.append(pid);
        msg.append(". Thread ID: ");
        msg.append(tid);
        OLogger.debug(msg);
    }
}

