/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import oracle.opatch.Applicable;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.Restorable;
import oracle.opatch.Rules;
import oracle.opatch.SystemCall;
import oracle.opatch.Verifiable;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchutil.DeltaFileProcessor;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.wrappers.WrapperFactory;

public class onewaycopyAction
extends OrderedPatchAction
implements Restorable,
Applicable,
RemoteShellPropagate,
ConflictDetectable,
Verifiable {
    private String copyName;
    private String path;
    private String fileName;
    private String nonApplicableDesc;
    private String permission = "";

    public onewaycopyAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String tmp;
        String copyName = null;
        String path = null;
        String fileName = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for onewaycopyAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("name")) {
                copyName = val;
            }
            if (arg.equals("path")) {
                path = val;
            }
            if (arg.equals("file_name")) {
                fileName = val;
            }
            if (arg.equals("mode")) {
                this.permission = val;
            }
            if (!arg.equals("shaolue")) continue;
            this.setHashValue(val);
        }
        if (copyName == null || path == null || fileName == null) {
            String errMsg = "The copy action is null";
            if (copyName == null) {
                errMsg = errMsg + "The copy name is null";
            }
            if (path == null) {
                errMsg = errMsg + "The file path is null";
            }
            if (fileName == null) {
                errMsg = errMsg + "The file name is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.copyName = copyName;
        this.path = tmp = PatchObjectUtil.filterString(path);
        this.fileName = tmp = PatchObjectUtil.getPlatformDependentPath(fileName);
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        StringBuffer buff = null;
        if (beforeApply) {
            Path copyFile = WrapperFactory.getNioServiceWrapper().getPath(this.getParentFilePath(oracleHomePath), new String[0]);
            if (Files.exists(copyFile, new LinkOption[0])) {
                buff = new StringBuffer("File \"");
                buff.append(copyFile.toString());
                buff.append("\" is not a new file.\n");
                OLogger.debug(buff);
                return false;
            }
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        StringBuffer tmpFile = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
        tmpFile.append(File.separator);
        tmpFile.append(this.fileName);
        tmpFile.append("_opatch_");
        tmpFile.append(cookedPatchID);
        Path copyFile = WrapperFactory.getNioServiceWrapper().getPath(tmpFile.toString(), new String[0]);
        if (Files.exists(copyFile, new LinkOption[0])) {
            buff = new StringBuffer("File \"");
            buff.append(copyFile.toString());
            buff.append("\" is present, so its a new file.\n");
            OLogger.debug(buff);
            return true;
        }
        buff = new StringBuffer("File \"");
        buff.append(copyFile.toString());
        buff.append("\" is not present, so its not a new file.\n");
        OLogger.debug(buff);
        return false;
    }

    public String getCopyName() {
        return this.copyName;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getSourceFile(String patchLocation) {
        if (patchLocation == null) {
            patchLocation = File.separator;
        }
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append("files");
        buff.append(File.separator);
        buff.append(this.fileName);
        return buff.toString();
    }

    public String getSourceFile() {
        return this.copyName;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(this.getParentDirPath(oracleHomePath));
        buff.append(File.separator);
        buff.append(this.copyName);
        return buff.toString();
    }

    public String getParentDirPath(String oracleHomePath) {
        if (oracleHomePath == null) {
            oracleHomePath = File.separator;
        }
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.path);
        return buff.toString();
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("[onewaycopyAction: copyName=\"");
        buff.append(this.copyName);
        buff.append("\", path=\"");
        buff.append(this.path);
        buff.append("\", fileName=\"");
        buff.append(this.fileName);
        buff.append("\", lineNumer=\"");
        buff.append(String.valueOf(this.lineNumber));
        buff.append("\", parentPath=\"");
        buff.append(this.getParentFilePath("%ORACLE_HOME%"));
        buff.append("\", sourcePath=\"");
        buff.append(this.getSourceFile("%patch_path%"));
        buff.append("\", mode=\"");
        buff.append(this.getPermission());
        buff.append("\" rawonewaycopyAction=\" ");
        buff.append(this.getRawActionEntry());
        buff.append("\"]");
        return buff.toString();
    }

    @Override
    public boolean restorable(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer("onewaycopyAction::restorable()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        String backupDir = OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer path = new StringBuffer(backupDir);
        path.append(File.separator);
        path.append(this.fileName);
        String dst = path.toString();
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(source);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0]) && !Files.isReadable(srcFile)) {
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (!Files.exists(parentFile, new LinkOption[0])) {
            try {
                Files.createDirectories(parentFile, new FileAttribute[0]);
            }
            catch (IOException e2) {
                return false;
            }
        }
        return Files.exists(parentFile, new LinkOption[0]) && Files.isWritable(parentFile);
    }

    @Override
    public void backupForRestore(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("onewaycopyAction::backupForRestore()");
        OLogger.debug(buff);
        String source = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String dst = buff.toString();
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(source, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer("onewaycopyAction::backupForRestore(): source file \"");
            buff.append(source);
            buff.append("\" not exist, do not back up");
            OLogger.debug(buff);
            return;
        }
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        try {
            buff = new StringBuffer("onewaycopyAction::backupForRestore(): back up \"");
            buff.append(source);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            if (!OPatchEnv.isWindows() && Files.exists(dstFile, new LinkOption[0]) && !Files.isWritable(dstFile) && !"".equals(this.permission)) {
                OUIReplacer.setPermission(dst.toString(), this.permission);
            }
            SystemCall.backupFile(srcFile, dstFile);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(t.getStackTrace());
            throw e2;
        }
    }

    @Override
    public void restore(String oracleHomePath, String sessionID, boolean apply, boolean rollback, String cookedPatchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("onewaycopyAction::restore()");
        OLogger.debug(buff);
        buff = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
        buff.append(File.separator);
        buff.append(this.fileName);
        String src = buff.toString();
        String dst = this.getParentFilePath(oracleHomePath);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("onewaycopyAction::restore(): restore file from \"");
            buff.append(src);
            buff.append("\" to \"");
            buff.append(dst);
            buff.append("\"");
            OLogger.debug(buff);
            if (!OPatchEnv.isWindows() && Files.exists(dstFile, new LinkOption[0]) && !Files.isWritable(dstFile) && !"".equals(this.permission)) {
                OUIReplacer.setPermission(dst.toString(), this.permission);
            }
            SystemCall.copyFile(srcFile, dstFile);
        }
    }

    @Override
    public String getBackupForRestoreDesc(String oracleHomePath, String cookedPatchID) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getParentFilePath(oracleHomePath));
        return buff.toString();
    }

    @Override
    public boolean applicable(String oracleHomePath, String patchLocation) {
        StringBuffer buff = new StringBuffer("onewaycopyAction::applicable()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("  Action details: src = \"");
        buff.append(src);
        buff.append("\", dst = \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.debug(buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0]) || !Files.isReadable(srcFile)) {
            buff = new StringBuffer("onewaycopyAction : Source File \"");
            buff.append(src);
            buff.append("\" does not exists or is not readable");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        Path parentFile = dstFile.getParent();
        if (Files.exists(parentFile, new LinkOption[0]) && !Files.isReadable(parentFile)) {
            buff = new StringBuffer("onewaycopyAction : Directory is not readable: \"");
            buff.append(parentFile.toString());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (Files.exists(dstFile, new LinkOption[0]) && !OPatchSessionHelper.CanWrite(oracleHomePath, dstFile) && (OPatchEnv.isWindows() || "".equals(this.permission))) {
            buff = new StringBuffer("onewaycopyAction : Desctination File \"");
            buff.append(dst);
            buff.append("\" is not writeable.");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        if (!Files.exists(dstFile, new LinkOption[0]) && Files.exists(parentFile, new LinkOption[0]) && !Files.isWritable(parentFile)) {
            buff = new StringBuffer("onewaycopyAction : Directory is not writeable: \"");
            buff.append(parentFile.toString());
            buff.append("\"");
            this.nonApplicableDesc = buff.toString();
            return false;
        }
        return true;
    }

    @Override
    public boolean verify(String oracleHomePath, String patchLocation) throws IOException {
        StringBuffer buff = new StringBuffer("onewaycopyAction::verify()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer("\n(C): Comparing file \"");
        buff.append(src);
        buff.append("\" and \"");
        buff.append(dst);
        buff.append("\"");
        OLogger.log(OLogger.FINE, buff.toString());
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("Source file \"");
            buff.append(src);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        if (!Files.exists(dstFile, new LinkOption[0])) {
            buff = new StringBuffer("Destination file \"");
            buff.append(dst);
            buff.append("\" does not exist.  Can't verify.");
            OLogger.log(OLogger.WARNING, buff.toString());
            return false;
        }
        InputStream srcStream = Files.newInputStream(srcFile, new OpenOption[0]);
        InputStream dstStream = Files.newInputStream(dstFile, new OpenOption[0]);
        boolean identical = onewaycopyAction.fileCompare(srcStream, dstStream);
        srcStream.close();
        dstStream.close();
        buff = new StringBuffer("  2 files are identical? ");
        buff.append(String.valueOf(identical).toUpperCase());
        OLogger.log(OLogger.FINE, buff.toString());
        if (!identical) {
            this.printVerificationFailure(this, src, dst);
        }
        return identical;
    }

    @Override
    public void apply(String oracleHomePath, String patchLocation) throws RuntimeException {
        StringBuffer buff = new StringBuffer("onewaycopyAction::apply()");
        OLogger.debug(buff);
        String src = this.getSourceFile(patchLocation);
        String dst = this.getParentFilePath(oracleHomePath);
        buff = new StringBuffer(" onewaycopyAction: src=\"");
        buff.append(src);
        buff.append("\", dst=\"");
        buff.append(dst);
        buff.append("\"");
        OLogger.verbose(this, buff);
        Path srcFile = WrapperFactory.getNioServiceWrapper().getPath(src, new String[0]);
        Path dstFile = WrapperFactory.getNioServiceWrapper().getPath(dst, new String[0]);
        Path parentFile = dstFile.getParent();
        DeltaFileProcessor deltaFileProcessor = OUSession.getDeltaFileProcessor();
        boolean sameHash = deltaFileProcessor.compareHash(srcFile, dstFile, this);
        if (!sameHash) {
            deltaFileProcessor.addNApplyDeltaFiles(dst, this);
        }
        boolean report = !Rules.SystemWrite_continue();
        buff = report ? new StringBuffer("onewaycopyAction::apply() in report mode.") : new StringBuffer("onewaycopyAction::apply().");
        OLogger.debug(buff);
        if (!Files.exists(parentFile, new LinkOption[0])) {
            if (!report && !sameHash) {
                try {
                    Files.createDirectories(parentFile, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    OLogger.debug("Errors occured while creating the directory '" + parentFile + "'");
                }
            } else {
                OLogger.debug("Directory " + parentFile + " no exist. Ignored since we are in analyze mode.");
            }
        }
        if (!Files.exists(parentFile, new LinkOption[0]) && !report) {
            buff = new StringBuffer("onewaycopyAction::apply(): cannot mkdirs on parent directory ");
            try {
                buff.append(parentFile.toAbsolutePath().normalize().toString());
            }
            catch (Exception e3) {
                // empty catch block
            }
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (!Files.exists(srcFile, new LinkOption[0])) {
            buff = new StringBuffer("onewaycopyAction::apply()");
            buff.append(": the src file is not there.  This should not happen because ");
            buff.append("caller has certified that this onewaycopyAction is applicable. src = ");
            buff.append(src);
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            if (!report) {
                StringBuffer ts = new StringBuffer("Start Copy Action at ");
                OLogger.logTime(ts);
                if (!OPatchEnv.isWindows() && Files.exists(dstFile, new LinkOption[0]) && !Files.isWritable(dstFile) && !"".equals(this.permission)) {
                    OUIReplacer.setPermission(dst.toString(), this.permission);
                }
                SystemCall.copyFile(srcFile, dstFile);
                if (!OPatchEnv.isWindows() && !"".equals(this.permission)) {
                    OUIReplacer.setPermission(dst.toString(), this.permission);
                }
                ts = new StringBuffer("Finish Copy Action at ");
                OLogger.logTime(ts);
            } else {
                buff = new StringBuffer("onewaycopyAction::apply() skips copying the file from ");
                buff.append(srcFile);
                buff.append(" to ");
                buff.append(dstFile);
                OLogger.debug(buff);
            }
        }
        catch (RuntimeException e4) {
            OLogger.printStackTrace(e4);
            String warnMsg = OLogger.getString("OUI-67204", new Object[]{src, dst, ""});
            buff = new StringBuffer("onewaycopyAction::apply() failed: \"");
            buff.append(e4.getMessage());
            buff.append("\"");
            OLogger.debug(buff);
            RuntimeException re = new RuntimeException(warnMsg);
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
        buff = new StringBuffer(" onewaycopyAction done");
        OLogger.verbose(this, buff);
    }

    @Override
    public String getApplicableDesc(String oracleHomePath, String owningComp) {
        String src = this.getSourceFile();
        String dst = this.getParentFilePath(oracleHomePath);
        String desc = this.nonApplicableDesc + "\n" + OLogger.getString("OUI-67152", new Object[]{owningComp, src, dst});
        return desc;
    }

    @Override
    public String getFilePathToPropagate(String oracleHomePath) throws RuntimeException {
        return this.getParentFilePath(oracleHomePath);
    }

    @Override
    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("onewaycopyAction::conflictDetectable()  ");
        String dst = this.getParentFilePath(oracleHomePath);
        boolean tmpB = dst != null && !dst.equals("");
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    @Override
    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        String dst = this.getParentFilePath(oracleHomePath);
        String[] filesList = new String[]{dst};
        return filesList;
    }

    @Override
    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        return ConflictHandler.checkCommonConflict(oracleHomePath, oneoffs, this);
    }

    @Override
    public boolean equals(Object o2) {
        if (o2 instanceof onewaycopyAction) {
            String myFileName = this.getFilename();
            String myPath = this.getPath();
            String myCopyName = this.getCopyName();
            onewaycopyAction it = (onewaycopyAction)o2;
            String itFileName = it.getFilename();
            String itPath = it.getPath();
            String itCopyName = it.getCopyName();
            if (myFileName.equals(itFileName) && myPath.equals(itPath) && myCopyName.equals(itCopyName)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fileName.length();
        result = 37 * result + this.copyName.length();
        result = 37 * result + this.path.length();
        return result;
    }

    @Override
    public String getActionName() {
        return "CopyAction";
    }

    @Override
    public String getActionDesc() {
        return "Copy a file from source to destination.";
    }

    @Override
    public String getApplyDescription(String oracleHomePath) {
        return OLogger.getString("OUI-67501", new Object[]{this.getParentFilePath(oracleHomePath)});
    }

    @Override
    public String getChildPath() {
        return this.getSourceFile();
    }

    @Override
    public boolean rollbackable(String oracleHomePath, String cookedPatchID) {
        return true;
    }

    @Override
    public void rollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
    }

    @Override
    public String getRollbackScriptEntry(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return "";
    }

    @Override
    public void backupForRollback(String oracleHomePath, String cookedPatchID) throws RuntimeException {
    }

    @Override
    public String getRollbackableDesc(String oracleHomePath, String owningComponent) {
        return "";
    }

    @Override
    public String getBackupForRollbackDesc(String oracleHomePath) {
        return "";
    }

    @Override
    public String getRollbackDescription(String oracleHomePath) {
        return "";
    }
}

