/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.Util;
import weblogic.management.configuration.NodeManagerMBean;
import weblogic.nodemanager.NMException;
import weblogic.nodemanager.client.NMClient;
import weblogic.nodemanager.client.ShellClient;

final class NodeManagerClient {
    private NMClient nmClient;
    private final Properties p;
    protected Exception excep = null;

    NodeManagerClient(NodeManagerMBean nm, String domainName, String domainDir, String username, String password, String name, Properties p2) {
        this.p = p2;
        String type = Util.norm(nm.getNMType());
        if ("".equals(type)) {
            type = "SSL";
        }
        String host = nm.getListenAddress();
        int port = nm.getListenPort();
        String home = nm.getNodeManagerHome();
        String cmd = nm.getShellCommand();
        this.setupNMC(type, host, port, home, cmd, domainName, domainDir, username, password, name);
    }

    private void setupNMC(String type, String host, int port, String home, String cmd, String domainName, String domainDir, String username, String password, String name) {
        StringBuilder sb = new StringBuilder("Node Manager Details\n");
        sb.append("Type       [").append(type).append("]\n");
        sb.append("Host       [").append(host).append("]\n");
        sb.append("Port       [").append("" + port).append("]\n");
        sb.append("Home       [").append(home).append("]\n");
        sb.append("Command    [").append(cmd).append("]\n");
        sb.append("DomainName [").append(domainName).append("]\n");
        sb.append("DomainDIR  [").append(domainDir).append("]\n");
        sb.append("Username   [").append(username).append("]\n");
        sb.append("Server     [").append(name).append("]\n");
        Logger.logi(sb.toString());
        try {
            this.nmClient = NMClient.getInstance((String)type);
            this.nmClient.setHost(host);
            this.nmClient.setPort(port);
            if (type.equalsIgnoreCase("ssh") || type.equalsIgnoreCase("rsh")) {
                if (home != null) {
                    this.nmClient.setNMDir(home);
                }
                if (cmd != null) {
                    ((ShellClient)this.nmClient).setShellCommand(cmd);
                }
            }
            this.nmClient.setDomainName(domainName);
            this.nmClient.setNMUser(username);
            this.nmClient.setNMPass(password);
            this.nmClient.setServerName(name);
        }
        catch (Exception e2) {
            Logger.loge(e2);
            this.excep = e2;
        }
    }

    void done() {
        try {
            this.nmClient.done();
        }
        catch (Exception e2) {
            Logger.loge(e2);
            this.excep = e2;
        }
    }

    String getState() {
        try {
            return this.nmClient.getState(0);
        }
        catch (NMException e2) {
            Logger.loge((Exception)((Object)e2));
            this.excep = new Exception(e2.getMessage() + ". It may be caused by wrong credential information for Node Manager");
            return null;
        }
        catch (Exception e3) {
            Logger.loge(e3);
            this.excep = e3;
            return null;
        }
    }

    boolean start(int timeout) {
        if ("RUNNING".equals(this.getState())) {
            return true;
        }
        try {
            if (this.p != null) {
                this.nmClient.start(this.p);
            } else {
                this.nmClient.start();
            }
            return this.wait(timeout, "RUNNING");
        }
        catch (Exception e2) {
            Logger.loge("Error while starting Admin Server.");
            Logger.loge(e2);
            this.excep = e2;
            return false;
        }
    }

    boolean stop(int timeout) {
        if (!"RUNNING".equals(this.getState())) {
            return true;
        }
        try {
            this.nmClient.kill();
            return this.waitOtherState(timeout, "RUNNING");
        }
        catch (Exception e2) {
            Logger.loge("Error while stopping Admin Server.");
            Logger.loge(e2);
            this.excep = e2;
            return false;
        }
    }

    boolean wait(int timeout, String state) {
        if (Logger.debug) {
            Logger.debug("Waiting for Operation to complete State Required [" + state + "] timeout [" + timeout + "]");
        }
        for (int i2 = 0; i2 < timeout; i2 += 5) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (Exception e2) {
                Logger.loge(e2);
                this.excep = e2;
            }
            if (!state.equals(this.getState())) continue;
            return true;
        }
        Logger.loge("Checking state through Node manager. Operation timed out.");
        return false;
    }

    boolean waitOtherState(int timeout, String state) {
        if (Logger.debug) {
            Logger.debug("Waiting for Operation to complete State Not Expected [" + state + "] timeout [" + timeout + "]");
        }
        for (int i2 = 0; i2 < timeout; i2 += 5) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (Exception e2) {
                Logger.loge(e2);
                this.excep = e2;
            }
            if (state.equals(this.getState())) continue;
            return true;
        }
        Logger.loge("Checking state through Node manager. Operation timed out.");
        return false;
    }
}

