/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchlogger;

import com.oracle.cie.common.util.logging.LogFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.glcm.opatch.content.lib.CStoreDirImpl;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OUIReplacer;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.CmdLinePrintStream;
import oracle.opatch.opatchlogger.ConsoleFormatter;
import oracle.opatch.opatchlogger.FileFormatter;
import oracle.opatch.opatchlogger.MyConsoleHandler;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchlogger.PlainFileFormatter;
import oracle.opatch.opatchlogger.SDKPrintStream;
import oracle.opatch.opatchprereq.OPatchChecks;
import oracle.opatch.wrappers.WrapperFactory;

public class OLoggerImpl {
    private boolean enableConsoleLater = false;
    private boolean commonLoggingEnabled = false;
    private int extendLogID = 0;
    private ArrayList warningList = new ArrayList();
    StringBuffer buff = new StringBuffer();
    FileWriter logFile = null;
    private PrintStream originalOutStream = null;
    private PrintStream originalErrStream = null;
    private boolean streamBackup = false;
    private Date date = new Date();
    private CmdLinePrintStream cmdLineStream = null;
    private SDKPrintStream sdkStream = null;
    private boolean logFileClosed = false;
    private String logFileLocation = "";
    private String debugLogFileLocation = "";
    private FileHandler debugFH = null;
    private Logger logger = Logger.getLogger("oracle.opatch.OPatch." + Thread.currentThread().getName());
    private FileHandler fh = null;
    private ConsoleHandler ch = null;
    protected FileHandler lsinvFH = null;
    protected FileHandler OUIFH = null;
    private int logLevel = OLogger.INFO;
    private int currentLogLevel = OLogger.INFO;
    private int logFileLevel = OLogger.INFO;
    private int defaultLogLevel = OLogger.INFO;
    static Map<Integer, Level> levelStrMap = new HashMap<Integer, Level>();

    protected String getTimeString() {
        return this.date.toString();
    }

    protected void setTimeString() {
        Date myDate;
        this.date = myDate = new Date();
    }

    protected String getCurrentTimeString() {
        Date date = new Date();
        return date.toString();
    }

    ConsoleHandler getConsoleHandler() {
        return this.ch;
    }

    int getExtendLogID() {
        return this.extendLogID;
    }

    void setExtendLogID(int logID) {
        this.extendLogID = logID;
    }

    FileHandler getCurrentFileHandler() {
        return this.fh;
    }

    protected void setEnableConsoleLater(boolean b2) {
        this.enableConsoleLater = b2;
    }

    protected void disableConsoleOutput(boolean force) {
        int tmpLogLevel;
        if (this.ch == null) {
            this.ch = new MyConsoleHandler();
            this.ch.setFormatter(new ConsoleFormatter());
            this.logger.addHandler(this.ch);
        }
        this.currentLogLevel = tmpLogLevel = this.logLevel;
        this.logLevel = OLogger.OFF;
        this.ch.setLevel(Level.OFF);
        if (OLogger.isOPatchCmdLineMode() || force) {
            if (null != this.cmdLineStream) {
                this.cmdLineStream.setConsoleOut(null);
                this.cmdLineStream.setConsoleErr(null);
                System.setOut(this.cmdLineStream);
                System.setErr(this.cmdLineStream);
            }
        } else if (this.sdkStream != null) {
            System.setOut(this.sdkStream);
            System.setErr(this.sdkStream);
        }
    }

    protected void enableConsoleOutput(boolean force) {
        if (this.ch != null) {
            OLogger.setLogLevel(this.currentLogLevel);
            if (this.originalOutStream != null && this.logFileClosed && !this.enableConsoleLater) {
                System.setOut(this.originalOutStream);
                System.setErr(this.originalErrStream);
            } else if (OLogger.isOPatchCmdLineMode() || force) {
                if (null != this.cmdLineStream) {
                    this.cmdLineStream.setConsoleOut(this.originalOutStream);
                    this.cmdLineStream.setConsoleErr(this.originalErrStream);
                    System.setOut(this.cmdLineStream);
                    System.setErr(this.cmdLineStream);
                }
            } else {
                if (this.ch != null) {
                    this.logger.removeHandler(this.ch);
                    this.ch.close();
                }
                if (this.originalOutStream != null) {
                    System.setOut(this.originalOutStream);
                    System.setErr(this.originalErrStream);
                }
            }
        }
    }

    protected void enableConsoleOutput(int level, boolean force) {
        if (this.ch != null) {
            OLogger.setLogLevel(level);
            if (this.originalOutStream != null && this.logFileClosed && !this.enableConsoleLater) {
                System.setOut(this.originalOutStream);
                System.setErr(this.originalErrStream);
            } else if ((OLogger.isOPatchCmdLineMode() || force) && null != this.cmdLineStream) {
                this.cmdLineStream.setConsoleOut(this.originalOutStream);
                this.cmdLineStream.setConsoleErr(this.originalErrStream);
                System.setOut(this.cmdLineStream);
                System.setErr(this.cmdLineStream);
            }
        }
    }

    protected HashMap disableLogOutput() {
        HashMap<Handler, Level> handlerMap = new HashMap<Handler, Level>();
        Handler[] handlers = this.logger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            Handler temp = handlers[index];
            if (!(temp instanceof FileHandler)) continue;
            handlerMap.put(temp, temp.getLevel());
            temp.setLevel(Level.OFF);
        }
        return handlerMap;
    }

    protected void enableLogOutput(HashMap handlerMap) {
        Handler[] handlers = this.logger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            Handler temp = handlers[index];
            if (!(temp instanceof FileHandler)) continue;
            temp.setLevel((Level)handlerMap.get(temp));
        }
    }

    void printWarningList() {
        int len = this.warningList.size();
        String[] list = new String[len];
        StringBuffer buff = null;
        if (len > 0) {
            OLogger.println("--------------------------------------------------------------------------------");
            OLogger.println("The following warnings have occurred during OPatch execution:");
            for (int i2 = 0; i2 < len; ++i2) {
                Object obj = this.warningList.get(i2);
                if (!(obj instanceof String)) continue;
                buff = new StringBuffer(String.valueOf(i2 + 1));
                buff.append(") ");
                buff.append((String)obj);
                OLogger.println(buff.toString());
            }
            OLogger.println("--------------------------------------------------------------------------------");
        }
    }

    void printWarningListOnLog() {
        int len = this.warningList.size();
        String[] list = new String[len];
        StringBuffer buff = null;
        if (len > 0) {
            OLogger.printlnOnLog("--------------------------------------------------------------------------------");
            OLogger.printlnOnLog("The following warnings have occurred during OPatch execution:");
            for (int i2 = 0; i2 < len; ++i2) {
                Object obj = this.warningList.get(i2);
                if (!(obj instanceof String)) continue;
                buff = new StringBuffer(String.valueOf(i2 + 1));
                buff.append(") ");
                buff.append((String)obj);
                OLogger.printlnOnLog(buff.toString());
            }
            OLogger.printlnOnLog("--------------------------------------------------------------------------------");
        }
    }

    private void initLogger(String javaFileName, String consoleLevelStr, String fileLevelStr) throws Exception {
        this.logFileLocation = javaFileName;
        String logSessionId = System.getProperty("CommonLog.LOG_SESSION_ID");
        String cmdName = System.getProperty("CommonLog.COMMAND_NAME");
        if (logSessionId != null && cmdName != null && !logSessionId.isEmpty() && !cmdName.isEmpty()) {
            this.commonLoggingEnabled = true;
        }
        int userSpecifiedConsoleLevel = OPatchACL.getConsoleLogLevel(this);
        int userSpecifiedFileLevel = OPatchACL.getFileLogLevel(this);
        Level consoleLevel = Level.parse(consoleLevelStr);
        Level fileLevel = Level.parse(fileLevelStr);
        this.logLevel = userSpecifiedConsoleLevel == 0 ? consoleLevel.intValue() : userSpecifiedConsoleLevel;
        String customLogLevel = System.getenv("LOG_LEVEL");
        if (customLogLevel != null && this.isAvailableLogLevel(customLogLevel)) {
            fileLevel = Level.parse(customLogLevel);
            System.setProperty(CStoreDirImpl.class.getSimpleName() + ".logLevel", customLogLevel);
        }
        this.logFileLevel = userSpecifiedFileLevel == 0 ? fileLevel.intValue() : userSpecifiedFileLevel;
        if (!this.commonLoggingEnabled) {
            this.logger.setUseParentHandlers(false);
        }
        Handler[] handlers = this.logger.getHandlers();
        for (int index = 0; index < handlers.length; ++index) {
            this.logger.removeHandler(handlers[index]);
        }
        this.logger.setLevel(Level.ALL);
        this.ch = new MyConsoleHandler();
        this.ch.setLevel(levelStrMap.get(this.logLevel));
        this.ch.setFormatter(new ConsoleFormatter());
        this.logger.addHandler(this.ch);
        if (this.commonLoggingEnabled) {
            this.logFileLocation = this.setupCommongLogging(this.logFileLocation, this.ch, logSessionId, cmdName);
            this.commonLoggingEnabled = true;
        } else {
            this.fh = new FileHandler(this.logFileLocation, true);
            this.fh.setLevel(levelStrMap.get(this.logFileLevel));
            this.logger.addHandler(this.fh);
        }
        OUIReplacer.changePermission(this.logFileLocation, 416);
    }

    protected void initJavaLogger(String oracleHomePath, String javaFileName, String consoleLevelStr, String fileLevelStr, boolean plainFileFormat) throws Exception {
        OPatchEnv.setLogFileLocationSpecified(true);
        OPatchEnv.setSpecifiedLogFileLocation(javaFileName);
        try {
            this.initLogger(javaFileName, consoleLevelStr, fileLevelStr);
            if (this.commonLoggingEnabled) {
                javaFileName = OPatchEnv.getSpecifiedLogFileLocation();
            }
            if (this.fh != null) {
                if (plainFileFormat) {
                    this.fh.setFormatter(new PlainFileFormatter());
                } else {
                    this.fh.setFormatter(new FileFormatter());
                }
            }
            Path javaLogFile = WrapperFactory.getNioServiceWrapper().getPath(javaFileName, new String[0]);
            PrintStream systemOut = new PrintStream(Files.newOutputStream(javaLogFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            if (!this.streamBackup) {
                this.originalOutStream = System.out;
                this.originalErrStream = System.err;
                this.streamBackup = true;
            }
            this.sdkStream = new SDKPrintStream(systemOut);
            System.setOut(this.sdkStream);
            System.setErr(this.sdkStream);
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        }
    }

    protected void initJavaLogger(String oracleHomePath, String cookedPatchID, String keyword, String consoleLevelStr, String fileLevelStr, boolean printLogFile, boolean plainFileFormat) throws Exception {
        String javaFileName = OLogger.getSpecifiedLogFileLocation(oracleHomePath, cookedPatchID, keyword);
        OPatchEnv.setLogFileLocationSpecified(true);
        OPatchEnv.setSpecifiedLogFileLocation(javaFileName);
        try {
            Level consoleLevel = Level.parse(consoleLevelStr);
            this.initLogger(javaFileName, consoleLevelStr, fileLevelStr);
            if (this.commonLoggingEnabled) {
                javaFileName = OPatchEnv.getSpecifiedLogFileLocation();
            }
            if (consoleLevel.intValue() == OLogger.OFF && !OPatchEnv.isOPatchSDKMode() && printLogFile) {
                System.out.println("Please monitor OPatch log file: " + javaFileName);
            }
            if (this.fh != null) {
                if (plainFileFormat) {
                    this.fh.setFormatter(new PlainFileFormatter());
                } else {
                    this.fh.setFormatter(new FileFormatter());
                }
            }
            Path javaLogFile = WrapperFactory.getNioServiceWrapper().getPath(javaFileName, new String[0]);
            PrintStream systemOut = new PrintStream(Files.newOutputStream(javaLogFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            if (!this.streamBackup) {
                this.originalOutStream = System.out;
                this.originalErrStream = System.err;
                this.streamBackup = true;
            }
            this.sdkStream = new SDKPrintStream(systemOut);
            System.setOut(this.sdkStream);
            System.setErr(this.sdkStream);
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        }
    }

    protected void initJavaLogger(String oracleHomePath, String consoleLevelStr, String fileLevelStr) throws Exception {
        OPatchEnv.setLogFileLocationSpecified(false);
        String fileLoc = OPatchACL.getLogFileLocation(this, oracleHomePath);
        Path dirPath = WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]);
        boolean ok = true;
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (Exception e2) {
                ok = false;
            }
            if (!ok && !OPatchEnv.isWindows() && OUIReplacer.isRootAccess(oracleHomePath)) {
                String ohOwner = OPatchEnv.getOHOwner(oracleHomePath);
                String mkdirCmd = "mkdir -p " + fileLoc;
                ok = SystemCall.process(mkdirCmd, ohOwner).isOK();
            }
        }
        if (!ok) {
            throw new Exception("Unable to create directory for log location.");
        }
        String customLogDir = OPatchEnv.getCustomLogDir();
        String javaFileName = "";
        javaFileName = customLogDir != null && !customLogDir.equals("") ? OPatchACL.getLogFileForJavaLog(this, customLogDir) : OPatchACL.getLogFileForJavaLog(this, oracleHomePath);
        try {
            Level consoleLevel = Level.parse(consoleLevelStr);
            this.initLogger(javaFileName, consoleLevelStr, fileLevelStr);
            if (this.commonLoggingEnabled) {
                javaFileName = OPatchEnv.getSpecifiedLogFileLocation();
            }
            if (consoleLevel.intValue() == OLogger.OFF && !OPatchEnv.isOPatchSDKMode()) {
                System.out.println("Please monitor OPatch log file: " + javaFileName);
            }
            if (this.fh != null) {
                this.fh.setFormatter(new FileFormatter());
            }
            Path javaLogFile = WrapperFactory.getNioServiceWrapper().getPath(javaFileName, new String[0]);
            if (OLogger.isOPatchCmdLineMode()) {
                if (!this.streamBackup) {
                    this.originalOutStream = System.out;
                    this.originalErrStream = System.err;
                    this.streamBackup = true;
                }
                this.cmdLineStream = new CmdLinePrintStream(this.originalOutStream, this.originalErrStream, javaFileName);
                System.setOut(this.cmdLineStream);
                System.setErr(this.cmdLineStream);
            } else {
                PrintStream systemOut = new PrintStream(Files.newOutputStream(javaLogFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
                OPatchEnv.setLogFileLocationSpecified(true);
                OPatchEnv.setSpecifiedLogFileLocation(javaFileName);
                if (!this.streamBackup) {
                    this.originalOutStream = System.out;
                    this.originalErrStream = System.err;
                    this.streamBackup = true;
                }
                this.sdkStream = new SDKPrintStream(systemOut);
                System.setOut(this.sdkStream);
                System.setErr(this.sdkStream);
            }
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
        }
    }

    protected void reInitJavaLogger(String logFileLocation, String consoleLevelStr, String fileLevelStr, boolean plainFileFormat) throws Exception {
        Path logFile = WrapperFactory.getNioServiceWrapper().getPath(logFileLocation, new String[0]);
        if (!Files.exists(logFile, new LinkOption[0]) || Files.isDirectory(logFile, new LinkOption[0])) {
            throw new Exception("Log file location is invalid.");
        }
        String javaFileName = logFileLocation;
        try {
            this.initLogger(javaFileName, consoleLevelStr, fileLevelStr);
            if (this.commonLoggingEnabled) {
                javaFileName = OPatchEnv.getSpecifiedLogFileLocation();
            }
            if (this.fh != null) {
                if (plainFileFormat) {
                    this.fh.setFormatter(new PlainFileFormatter());
                } else {
                    this.fh.setFormatter(new FileFormatter());
                }
            }
            Path javaLogFile = WrapperFactory.getNioServiceWrapper().getPath(javaFileName, new String[0]);
            PrintStream systemOut = new PrintStream(Files.newOutputStream(javaLogFile, StandardOpenOption.CREATE, StandardOpenOption.APPEND));
            if (!this.streamBackup) {
                this.originalOutStream = System.out;
                this.originalErrStream = System.err;
                this.streamBackup = true;
            }
            this.sdkStream = new SDKPrintStream(systemOut);
            System.setOut(this.sdkStream);
            System.setErr(this.sdkStream);
        }
        catch (IllegalArgumentException e2) {
            e2.printStackTrace();
        }
    }

    protected void initOUICheckerLogFile(String oracleHomePath) throws IOException {
        String fileName = "";
        String fileLoc = "";
        try {
            fileName = OPatchACL.getLogFileNameAndLocation(this, oracleHomePath);
            fileLoc = OPatchACL.getLogFileLocation(this, oracleHomePath);
        }
        catch (IllegalAccessException e1) {
            // empty catch block
        }
        Path file = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        Path dirPath = WrapperFactory.getNioServiceWrapper().getPath(fileLoc, new String[0]);
        boolean ok = true;
        if (!Files.exists(dirPath, new LinkOption[0])) {
            try {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            catch (Exception e2) {
                ok = false;
            }
        }
        if (ok) {
            this.logger.setUseParentHandlers(false);
            Handler[] rootHandlers = Logger.getLogger("").getHandlers();
            Logger rootLogger = Logger.getLogger("");
            for (int index = 0; index < rootHandlers.length; ++index) {
                rootLogger.removeHandler(rootHandlers[index]);
            }
            Handler[] handlers = this.logger.getHandlers();
            for (int index = 0; index < handlers.length; ++index) {
                this.logger.removeHandler(handlers[index]);
            }
            this.logger.setLevel(Level.ALL);
            this.OUIFH = new FileHandler(fileName, true);
            this.OUIFH.setLevel(levelStrMap.get(this.logFileLevel));
            this.OUIFH.setFormatter(new FileFormatter());
            this.logger.addHandler(this.OUIFH);
        }
    }

    protected void closeLogFile() {
        try {
            if (this.fh != null) {
                this.logger.removeHandler(this.fh);
                this.fh.close();
            }
            if (this.lsinvFH != null) {
                this.logger.removeHandler(this.lsinvFH);
                this.lsinvFH.close();
            }
            if (this.OUIFH != null) {
                this.logger.removeHandler(this.OUIFH);
                this.OUIFH.close();
            }
            if (this.debugFH != null) {
                this.logger.removeHandler(this.debugFH);
                this.debugFH.close();
            }
            Handler[] handlers = this.logger.getHandlers();
            for (int index = 0; index < handlers.length; ++index) {
                this.logger.removeHandler(handlers[index]);
            }
            this.logFileClosed = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void justlog(int level, String str) {
        HashMap<Handler, Level> handlerMap = new HashMap<Handler, Level>();
        Handler[] handlers = this.logger.getHandlers();
        Handler hand = null;
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            hand = handlers[i2];
            if (hand == null || !(hand instanceof ConsoleHandler)) continue;
            handlerMap.put(hand, hand.getLevel());
            hand.setLevel(Level.OFF);
        }
        if (this.fh != null || this.OUIFH != null || this.debugFH != null || this.commonLoggingEnabled) {
            this.logger.log(levelStrMap.get(level), str);
        }
        for (Map.Entry entry : handlerMap.entrySet()) {
            hand = (Handler)entry.getKey();
            hand.setLevel((Level)entry.getValue());
        }
    }

    protected void justDebugLog(String str) {
        HashMap<Handler, Level> handlerMap = new HashMap<Handler, Level>();
        Handler[] handlers = this.logger.getHandlers();
        Handler hand = null;
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            hand = handlers[i2];
            if (hand != null && hand instanceof ConsoleHandler) {
                handlerMap.put(hand, hand.getLevel());
                hand.setLevel(Level.OFF);
                continue;
            }
            if (!(hand instanceof FileHandler) || hand.getLevel() == Level.FINEST) continue;
            handlerMap.put(hand, hand.getLevel());
            hand.setLevel(Level.OFF);
        }
        if (this.debugFH != null) {
            this.logger.log(Level.FINEST, str);
        }
        for (Map.Entry entry : handlerMap.entrySet()) {
            hand = (Handler)entry.getKey();
            hand.setLevel((Level)entry.getValue());
        }
    }

    protected void resetWarningList() {
        this.warningList = new ArrayList();
    }

    private void outputToConsole(String s, boolean newLine) {
        HashMap<Handler, Level> handlerMap = new HashMap<Handler, Level>();
        Handler[] handlers = this.logger.getHandlers();
        Handler hand = null;
        for (int i2 = 0; i2 < handlers.length; ++i2) {
            hand = handlers[i2];
            if (hand == null || !(hand instanceof FileHandler)) continue;
            handlerMap.put(hand, hand.getLevel());
            hand.setLevel(Level.OFF);
        }
        if (newLine) {
            s = s + "\n";
        }
        if (this.commonLoggingEnabled) {
            this.logger.setUseParentHandlers(false);
        }
        this.logger.log(Level.INFO, s);
        if (this.commonLoggingEnabled) {
            this.logger.setUseParentHandlers(true);
        }
        for (Map.Entry entry : handlerMap.entrySet()) {
            hand = (Handler)entry.getKey();
            hand.setLevel((Level)entry.getValue());
        }
    }

    protected void printlnOnConsole(String s) {
        if (this.ch != null) {
            this.outputToConsole(s, true);
        } else {
            System.out.println(s);
        }
    }

    protected void printOnConsole(String s) {
        if (this.ch != null) {
            this.outputToConsole(s, false);
        } else {
            System.out.print(s);
        }
    }

    protected void printlnOnError(String s) {
        if (null != this.fh) {
            this.fh.setLevel(Level.OFF);
            this.logger.log(Level.SEVERE, s + "\n");
            this.fh.setLevel(levelStrMap.get(this.logFileLevel));
        } else if (this.commonLoggingEnabled) {
            this.logger.log(Level.SEVERE, s + "\n");
        }
    }

    protected void printlnOnLog(int level, String s) {
        boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
        if (calledFromOUI) {
            if (this.OUIFH == null && !OPatchEnv.isLogDisabled()) {
                try {
                    this.initOUICheckerLogFile(OPatchEnv.getOracleHome());
                }
                catch (IOException e2) {
                    this.OUIFH = null;
                }
                catch (Exception e3) {
                    this.OUIFH = null;
                }
            }
            if (OPatchChecks.inDebugMode()) {
                this.setLogFileLevel(OLogger.FINEST);
            } else {
                this.setLogFileLevel(OLogger.INFO);
            }
            this.justlog(level, s);
        } else {
            this.justlog(level, s);
        }
    }

    protected String logres(int level, String key) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(key));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, key): level=");
            str.append(level);
            str.append(", key=");
            str.append(key);
        }
        OLogger.log(level, str.toString());
        return str.toString();
    }

    protected String logres(int level, String key, Object[] objs) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(key, objs));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, key, objs): level=");
            str.append(level);
            str.append(", key=");
            str.append(key);
        }
        OLogger.log(level, str.toString());
        return str.toString();
    }

    protected String logres(int level, String sRes, String key, Object[] objs) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(sRes, key, objs));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, sRes, key, objs): level=");
            str.append(level);
            str.append(", sRes=");
            str.append(sRes);
            str.append(", key=");
            str.append(key);
        }
        OLogger.log(level, str.toString());
        return str.toString();
    }

    protected String logres(int level, String sRes, String key) {
        StringBuffer str = new StringBuffer(key);
        str.append(":");
        try {
            str.append(OLogger.getString(sRes, key));
        }
        catch (IllegalArgumentException e2) {
            str.append("Matching message not found in the Resource Bundle, logres(level, sRes, key): level=");
            str.append(level);
            str.append(", sRes=");
            str.append(sRes);
            str.append(", key=");
            str.append(key);
        }
        OLogger.log(level, str.toString());
        return str.toString();
    }

    protected String warn(String key) {
        String str = this.logres(OLogger.WARNING, key);
        this.warningList.add(str);
        return str;
    }

    protected String warn(String key, Object[] objs) {
        String str = this.logres(OLogger.WARNING, key, objs);
        this.warningList.add(str);
        return str;
    }

    protected String warn(String sRes, String key, Object[] objs) {
        String str = this.logres(OLogger.WARNING, sRes, key, objs);
        this.warningList.add(str);
        return str;
    }

    protected String warn(String sRes, String key) {
        String str = this.logres(OLogger.WARNING, sRes, key);
        this.warningList.add(str);
        return str;
    }

    protected String getSafeFormatTimeStamp() {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
            return dateFormatter.format(this.date);
        }
        catch (Throwable t) {
            return "";
        }
    }

    protected void setLogLevel(int logLevel) {
        if (this.ch != null) {
            this.ch.setLevel(levelStrMap.get(logLevel));
        }
        this.logLevel = logLevel;
    }

    protected void setLogFileLevel(int logFileLevel) {
        if (this.fh != null) {
            this.fh.setLevel(levelStrMap.get(logFileLevel));
        }
        if (this.OUIFH != null) {
            this.OUIFH.setLevel(levelStrMap.get(logFileLevel));
        }
        if (this.lsinvFH != null) {
            this.lsinvFH.setLevel(levelStrMap.get(logFileLevel));
        }
        this.logFileLevel = logFileLevel;
        if (this.commonLoggingEnabled) {
            String commonLogLevel = System.getProperty("CommonLog.LOG_LEVEL");
            if (commonLogLevel == null || commonLogLevel.isEmpty()) {
                this.logger.setLevel(levelStrMap.get(logFileLevel));
            } else {
                try {
                    Level level = Level.parse(commonLogLevel);
                    this.logger.setLevel(level);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.setLevel(levelStrMap.get(logFileLevel));
                    this.justlog(logFileLevel, "Appropriate log level is not specified by CommonLog.LOG_LEVEL VM argument. Setting log level to  " + levelStrMap.get(logFileLevel));
                }
            }
        }
    }

    protected int getLogFileLevel() {
        return this.logFileLevel;
    }

    protected void setCurrentLogLevel(int currentLogLevel) {
        this.currentLogLevel = currentLogLevel;
    }

    protected int getLogLevel() {
        return this.logLevel;
    }

    protected void setLsInventoryFileHandler(FileHandler handler) {
        this.lsinvFH = handler;
    }

    protected String getLogFileLocation() {
        return this.logFileLocation;
    }

    protected String getDebugLogFileLocation() {
        return this.debugLogFileLocation;
    }

    protected int getWarningListLength() {
        return this.warningList.size();
    }

    protected void addHandler(Handler handler) {
        if (null != handler) {
            this.logger.addHandler(handler);
        }
    }

    protected void rmHandler(Handler handler) {
        if (null != handler) {
            this.logger.removeHandler(handler);
        }
    }

    protected boolean isLoggerInitialized() {
        boolean loggerInitialized = false;
        Handler[] handlers = this.logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            loggerInitialized = true;
        }
        return loggerInitialized;
    }

    protected boolean isAvailableLogLevel(String customLogLevel) {
        for (Level level : levelStrMap.values()) {
            if (!level.getName().equalsIgnoreCase(customLogLevel)) continue;
            return true;
        }
        return false;
    }

    public static void addResourceToClassLoader(Path resource) throws IOException {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> classLoaderClass = URLClassLoader.class;
        try {
            Method method = classLoaderClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)systemClassLoader, resource.toUri().toURL());
        }
        catch (Exception e2) {
            throw new IOException("Error while loading resource: " + resource.getFileName());
        }
    }

    private String setupCommongLogging(String opatchDefaultLogFile, ConsoleHandler ch, String logSessionId, String cmdName) {
        System.setProperty("LOG_SESSION_ID", logSessionId);
        System.setProperty("COMMAND_NAME", cmdName);
        String logFile = opatchDefaultLogFile;
        String loggingLevel = levelStrMap.get(this.logFileLevel).getName();
        String defaultLogDir = new File(opatchDefaultLogFile).getParent();
        if (defaultLogDir != null && loggingLevel != null && !defaultLogDir.isEmpty() && !loggingLevel.isEmpty()) {
            LogFactory.getFactory().setupLogging(new File(defaultLogDir), loggingLevel);
        } else {
            LogFactory.getFactory().setupLogging();
        }
        this.logger.setLevel(levelStrMap.get(this.logFileLevel));
        if (null != LogFactory.getFactory().getRootDestination()) {
            logFile = LogFactory.getFactory().getRootDestination().getDestName();
        }
        OPatchEnv.setLogFileLocationSpecified(true);
        OPatchEnv.setSpecifiedLogFileLocation(logFile);
        return logFile;
    }

    static {
        levelStrMap.put(OLogger.FINEST, Level.FINEST);
        levelStrMap.put(OLogger.FINER, Level.FINER);
        levelStrMap.put(OLogger.FINE, Level.FINE);
        levelStrMap.put(OLogger.CONFIG, Level.CONFIG);
        levelStrMap.put(OLogger.INFO, Level.INFO);
        levelStrMap.put(OLogger.WARNING, Level.WARNING);
        levelStrMap.put(OLogger.SEVERE, Level.SEVERE);
        levelStrMap.put(OLogger.OFF, Level.OFF);
    }
}

