/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.jar.JarFile;
import oracle.opatch.opatchlogger.OLogger;

public class ClassPathAdder {
    private static boolean loadedViaPreMain = false;
    public static Instrumentation inst;
    private static ClassLoader customClassLoader;

    public static void setCustomClassLoader(ClassLoader classLoader) {
        customClassLoader = classLoader;
    }

    public static void add(Path path) throws Exception {
        if (Files.isDirectory(path, new LinkOption[0]) || path.toString().endsWith(".jar")) {
            ClassPathAdder.add(path.toUri().toURL(), path);
        } else {
            OLogger.justlog(OLogger.WARNING, path + " is not a jar or a directory.");
        }
    }

    private static void add(URL url, Path path) throws Exception {
        ClassLoader urlClassLoader = ClassLoader.getSystemClassLoader();
        if (urlClassLoader instanceof URLClassLoader) {
            Class<URLClassLoader> clazz = URLClassLoader.class;
            Method method = clazz.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            if (customClassLoader != null) {
                OLogger.justlog(OLogger.INFO, url + " Adding jars to custom class loader  " + customClassLoader.getClass().getCanonicalName());
                method.invoke((Object)customClassLoader, url);
            }
            OLogger.justlog(OLogger.INFO, url + " Adding jars to System Class loader  " + urlClassLoader.getClass().getCanonicalName());
            method.invoke((Object)urlClassLoader, url);
            OLogger.justlog(OLogger.INFO, url + " is loaded.");
        } else {
            if (inst == null) {
                OLogger.justlog(OLogger.WARNING, "inst is null. Could not load " + path.toString());
                throw new Exception("Could not load " + path.toString());
            }
            if (path.toString().endsWith(".jar") && Files.exists(path, new LinkOption[0])) {
                inst.appendToSystemClassLoaderSearch(new JarFile(path.toAbsolutePath().toString()));
                OLogger.justlog(OLogger.INFO, path.toString() + " is loaded.");
                return;
            }
            OLogger.justlog(OLogger.WARNING, path.toString() + " not loaded.");
        }
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        loadedViaPreMain = true;
        ClassPathAdder.agentmain(agentArgs, instrumentation);
    }

    public static void agentmain(String agentArgs, Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation");
        }
        if (inst == null) {
            inst = instrumentation;
        }
    }

    static {
        customClassLoader = null;
    }
}

